/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostFormatProcessorHelper {
    private final CommonCodeStyleSettings mySettings;
    private int myDelta;
    private TextRange myResultTextRange;

    @Deprecated
    public PostFormatProcessorHelper(CodeStyleSettings rootSettings) {
        this.mySettings = rootSettings.getCommonSettings("");
    }

    public PostFormatProcessorHelper(CommonCodeStyleSettings settings) {
        this.mySettings = settings;
    }

    public CommonCodeStyleSettings getSettings() {
        return this.mySettings;
    }

    public void updateResultRange(int oldTextLength, int newTextLength) {
        if (this.myResultTextRange == null) {
            return;
        }
        int thisChange = newTextLength - oldTextLength;
        this.myDelta += thisChange;
        this.myResultTextRange = new TextRange(this.myResultTextRange.getStartOffset(), this.myResultTextRange.getEndOffset() + thisChange);
    }

    public int mapOffset(int sourceOffset) {
        return this.myDelta + sourceOffset;
    }

    @NotNull
    public TextRange mapRange(@NotNull TextRange sourceRange) {
        return new TextRange(this.myDelta + sourceRange.getStartOffset(), this.myDelta + sourceRange.getEndOffset());
    }

    public boolean isElementPartlyInRange(@NotNull PsiElement element) {
        if (this.myResultTextRange == null) {
            return true;
        }
        TextRange elementRange = element.getTextRange();
        if (elementRange.getEndOffset() < this.myResultTextRange.getStartOffset()) {
            return false;
        }
        return elementRange.getStartOffset() <= this.myResultTextRange.getEndOffset();
    }

    public boolean isElementFullyInRange(PsiElement element) {
        if (this.myResultTextRange == null) {
            return true;
        }
        TextRange elementRange = element.getTextRange();
        return elementRange.getStartOffset() >= this.myResultTextRange.getStartOffset() && elementRange.getEndOffset() <= this.myResultTextRange.getEndOffset();
    }

    public static boolean isMultiline(@Nullable PsiElement statement) {
        if (statement == null) {
            return false;
        }
        return statement.textContains('\n');
    }

    public void setResultTextRange(TextRange resultTextRange) {
        this.myResultTextRange = resultTextRange;
        this.myDelta = 0;
    }

    public TextRange getResultTextRange() {
        return this.myResultTextRange;
    }
}

