/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.openapi.options.SchemeExporter;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.json.CodeStyleSchemeJsonDescriptor;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeJsonExporter
extends SchemeExporter<CodeStyleScheme> {
    public static final String CODE_STYLE_JSON_EXT = "codestyle.json";

    public void exportScheme(@NotNull CodeStyleScheme scheme2, @NotNull OutputStream outputStream) {
        this.exportScheme(scheme2, outputStream, null);
    }

    public void exportScheme(@NotNull CodeStyleScheme scheme2, @NotNull OutputStream outputStream, @Nullable List<String> languageNames) {
        GsonBuilder builder2 = new GsonBuilder();
        builder2.setPrettyPrinting();
        builder2.registerTypeAdapter(CodeStyleSchemeJsonDescriptor.PropertyListHolder.class, (Object)new JsonSerializer<CodeStyleSchemeJsonDescriptor.PropertyListHolder>(){

            public JsonElement serialize(CodeStyleSchemeJsonDescriptor.PropertyListHolder src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject o = new JsonObject();
                for (AbstractCodeStylePropertyMapper mapper : src) {
                    JsonObject langProperties = CodeStyleSchemeJsonExporter.serializeMapper(mapper);
                    o.add(mapper.getLanguageDomainId(), (JsonElement)langProperties);
                }
                return o;
            }
        });
        Gson gson2 = builder2.create();
        String json = gson2.toJson((Object)new CodeStyleSchemeJsonDescriptor(scheme2, languageNames));
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            writer.write(json);
        }
    }

    private static JsonObject serializeMapper(AbstractCodeStylePropertyMapper src) {
        JsonObject o = new JsonObject();
        for (String name : src.enumProperties()) {
            CodeStylePropertyAccessor accessor = src.getAccessor(name);
            if (accessor == null) continue;
            Object externalized = accessor.get();
            if (externalized instanceof String) {
                o.addProperty(name, (String)externalized);
                continue;
            }
            if (externalized instanceof Integer) {
                o.addProperty(name, (Number)((Integer)externalized));
                continue;
            }
            if (externalized instanceof Boolean) {
                o.addProperty(name, (Boolean)externalized);
                continue;
            }
            if (!(externalized instanceof List)) continue;
            JsonArray array = new JsonArray();
            for (Object element : (List)externalized) {
                if (!(element instanceof String)) continue;
                array.add((String)element);
            }
            o.add(name, (JsonElement)array);
        }
        return o;
    }

    public String getExtension() {
        return CODE_STYLE_JSON_EXT;
    }
}

