/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveCache {
    private final AtomicReferenceArray<Map> myPhysicalMaps = new AtomicReferenceArray(4);
    private final AtomicReferenceArray<Map> myNonPhysicalMaps = new AtomicReferenceArray(4);
    private final RecursionGuard myGuard = RecursionManager.createGuard((String)"resolveCache");
    private static final Object NULL_RESULT = ObjectUtils.sentinel((String)"ResolveCache.NULL_RESULT");
    private static final StrongValueReference NULL_VALUE_REFERENCE = new StrongValueReference(NULL_RESULT);
    private static final StrongValueReference EMPTY_RESOLVE_RESULT = new StrongValueReference(ResolveResult.EMPTY_ARRAY);

    public static ResolveCache getInstance(Project project) {
        ProgressIndicatorProvider.checkCanceled();
        return (ResolveCache)ServiceManager.getService((Project)project, ResolveCache.class);
    }

    public ResolveCache(@NotNull MessageBus messageBus) {
        messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                ResolveCache.this.clearCache(isPhysical);
            }
        });
    }

    @NotNull
    private static <K, V> Map<K, V> createWeakMap() {
        return new ConcurrentWeakKeySoftValueHashMap<K, V>(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy()){

            @NotNull
            protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(@NotNull V value, @NotNull ReferenceQueue<? super V> queue2) {
                StrongValueReference result2 = value == NULL_RESULT || value instanceof Object[] && ((Object[])value).length == 0 ? ResolveCache.createStrongReference(value) : super.createValueReference(value, queue2);
                return result2;
            }

            public V get(@NotNull Object key) {
                Object v = super.get(key);
                return v == NULL_RESULT ? null : v;
            }
        };
    }

    public void clearCache(boolean isPhysical) {
        if (isPhysical) {
            ResolveCache.clearArray(this.myPhysicalMaps);
        }
        ResolveCache.clearArray(this.myNonPhysicalMaps);
    }

    private static void clearArray(AtomicReferenceArray<?> array) {
        for (int i = 0; i < array.length(); ++i) {
            array.set(i, null);
        }
    }

    @Nullable
    private <TRef extends PsiReference, TResult> TResult resolve(@NotNull TRef ref, @NotNull AbstractResolver<? super TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode, boolean isPoly, boolean isPhysical) {
        int index;
        Map<TRef, TResult> map2;
        TResult result2;
        ProgressIndicatorProvider.checkCanceled();
        if (isPhysical) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        if ((result2 = (map2 = this.getMap(isPhysical, index = ResolveCache.getIndex(incompleteCode, isPoly))).get(ref)) != null) {
            return result2;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        Object object = result2 = needToPreventRecursion ? this.myGuard.doPreventingRecursion((Object)Trinity.create(ref, (Object)incompleteCode, (Object)isPoly), true, () -> resolver.resolve(ref, incompleteCode)) : resolver.resolve(ref, incompleteCode);
        if (result2 instanceof ResolveResult) {
            ResolveCache.ensureValidPsi((ResolveResult)result2);
        } else if (result2 instanceof ResolveResult[]) {
            ResolveCache.ensureValidResults((ResolveResult[])result2);
        } else if (result2 instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)((PsiElement)result2));
        }
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, map2, result2);
        }
        return result2;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        return this.resolveWithCaching(ref, resolver, needToPreventRecursion, incompleteCode, ref.getElement().getContainingFile());
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        ResolveResult[] result2 = (ResolveResult[])this.resolve((PsiReference)ref, (AbstractResolver)resolver, needToPreventRecursion, incompleteCode, true, containingFile.isPhysical());
        return result2 == null ? ResolveResult.EMPTY_ARRAY : result2;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantContextResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean physical = containingFile.isPhysical();
        int index = ResolveCache.getIndex(incompleteCode, true);
        Map map2 = this.getMap(physical, index);
        ResolveResult[] result2 = (ResolveResult[])map2.get(ref);
        if (result2 != null) {
            return result2;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        ResolveResult[] resolveResultArray = result2 = needToPreventRecursion ? (ResolveResult[])this.myGuard.doPreventingRecursion((Object)Pair.create(ref, (Object)incompleteCode), true, () -> resolver.resolve(ref, containingFile, incompleteCode)) : resolver.resolve(ref, containingFile, incompleteCode);
        if (result2 != null) {
            ResolveCache.ensureValidResults(result2);
        }
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, map2, result2);
        }
        return result2 == null ? ResolveResult.EMPTY_ARRAY : result2;
    }

    private static void ensureValidResults(ResolveResult[] result2) {
        for (ResolveResult resolveResult : result2) {
            ResolveCache.ensureValidPsi(resolveResult);
        }
    }

    private static void ensureValidPsi(ResolveResult resolveResult) {
        PsiElement element = resolveResult.getElement();
        if (element != null) {
            PsiUtilCore.ensureValid((PsiElement)element);
        }
    }

    @Nullable
    public <T extends PsiPolyVariantReference> ResolveResult[] getCachedResults(@NotNull T ref, boolean physical, boolean incompleteCode, boolean isPoly) {
        Map map2 = this.getMap(physical, ResolveCache.getIndex(incompleteCode, isPoly));
        return (ResolveResult[])map2.get(ref);
    }

    @Nullable
    public <TRef extends PsiReference, TResult> TResult resolveWithCaching(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        return this.resolve(ref, resolver, needToPreventRecursion, incompleteCode, false, ref.getElement().isPhysical());
    }

    @NotNull
    private <TRef extends PsiReference, TResult> Map<TRef, TResult> getMap(boolean physical, int index) {
        AtomicReferenceArray<Map> array = physical ? this.myPhysicalMaps : this.myNonPhysicalMaps;
        Map map2 = array.get(index);
        while (map2 == null) {
            Map newMap = ResolveCache.createWeakMap();
            map2 = array.compareAndSet(index, null, newMap) ? newMap : array.get(index);
        }
        return map2;
    }

    private static int getIndex(boolean incompleteCode, boolean isPoly) {
        return (incompleteCode ? 0 : 1) * 2 + (isPoly ? 0 : 1);
    }

    private static <TRef extends PsiReference, TResult> void cache(@NotNull TRef ref, @NotNull Map<? super TRef, TResult> map2, TResult result2) {
        Object cached = map2.get(ref);
        if (cached != null && cached == result2) {
            return;
        }
        cached = result2 == null ? NULL_RESULT : result2;
        map2.put(ref, cached);
    }

    @NotNull
    private static <K, V> StrongValueReference<K, V> createStrongReference(@NotNull V value) {
        return value == NULL_RESULT ? NULL_VALUE_REFERENCE : (value == ResolveResult.EMPTY_ARRAY ? EMPTY_RESOLVE_RESULT : new StrongValueReference(value));
    }

    private static class StrongValueReference<K, V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        private final V myValue;

        StrongValueReference(@NotNull V value) {
            this.myValue = value;
        }

        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            throw new UnsupportedOperationException();
        }

        public V get() {
            return this.myValue;
        }
    }

    @FunctionalInterface
    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }

    @FunctionalInterface
    public static interface PolyVariantContextResolver<T extends PsiPolyVariantReference> {
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, @NotNull PsiFile var2, boolean var3);
    }

    @FunctionalInterface
    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, boolean var2);
    }

    @FunctionalInterface
    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(@NotNull TRef var1, boolean var2);
    }
}

