/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NamedObjectProviderBinding
implements ProviderBinding {
    private final Map<String, List<ProviderBinding.ProviderInfo<ElementPattern>>> myNamesToProvidersMap = new THashMap(5);
    private final Map<String, List<ProviderBinding.ProviderInfo<ElementPattern>>> myNamesToProvidersMapInsensitive = new THashMap(5);

    public void registerProvider(@NonNls @NotNull String[] names, @NotNull ElementPattern filter, boolean caseSensitive, @NotNull PsiReferenceProvider provider, double priority) {
        Map<String, List<ProviderBinding.ProviderInfo<ElementPattern>>> map2 = caseSensitive ? this.myNamesToProvidersMap : this.myNamesToProvidersMapInsensitive;
        for (String attributeName : names) {
            String key = caseSensitive ? attributeName : attributeName.toLowerCase();
            SmartList psiReferenceProviders = map2.get(key);
            if (psiReferenceProviders == null) {
                psiReferenceProviders = new SmartList();
                map2.put(key, (List<ProviderBinding.ProviderInfo<ElementPattern>>)psiReferenceProviders);
            }
            psiReferenceProviders.add(new ProviderBinding.ProviderInfo<ElementPattern>(provider, filter, priority));
        }
    }

    @Override
    public void addAcceptableReferenceProviders(@NotNull PsiElement position, @NotNull List<? super ProviderBinding.ProviderInfo<ProcessingContext>> list2, @NotNull PsiReferenceService.Hints hints) {
        String name = this.getName(position);
        if (name != null) {
            NamedObjectProviderBinding.addMatchingProviders(position, this.myNamesToProvidersMap.get(name), list2, hints);
            NamedObjectProviderBinding.addMatchingProviders(position, this.myNamesToProvidersMapInsensitive.get(name.toLowerCase()), list2, hints);
        }
    }

    @Override
    public void unregisterProvider(@NotNull PsiReferenceProvider provider) {
        for (List<ProviderBinding.ProviderInfo<ElementPattern>> list2 : this.myNamesToProvidersMap.values()) {
            for (ProviderBinding.ProviderInfo<ElementPattern> trinity : new ArrayList<ProviderBinding.ProviderInfo<ElementPattern>>(list2)) {
                if (!trinity.provider.equals(provider)) continue;
                list2.remove(trinity);
            }
        }
        for (List<ProviderBinding.ProviderInfo<ElementPattern>> list2 : this.myNamesToProvidersMapInsensitive.values()) {
            for (ProviderBinding.ProviderInfo<ElementPattern> trinity : new ArrayList<ProviderBinding.ProviderInfo<ElementPattern>>(list2)) {
                if (!trinity.provider.equals(provider)) continue;
                list2.remove(trinity);
            }
        }
    }

    @Nullable
    protected abstract String getName(@NotNull PsiElement var1);

    static void addMatchingProviders(@NotNull PsiElement position, @Nullable List<? extends ProviderBinding.ProviderInfo<ElementPattern>> providerList, @NotNull Collection<? super ProviderBinding.ProviderInfo<ProcessingContext>> output, @NotNull PsiReferenceService.Hints hints) {
        if (providerList == null) {
            return;
        }
        for (int i = 0; i < providerList.size(); ++i) {
            ProviderBinding.ProviderInfo<ElementPattern> info = providerList.get(i);
            if (hints != PsiReferenceService.Hints.NO_HINTS && !info.provider.acceptsHints(position, hints)) continue;
            ProcessingContext context = new ProcessingContext();
            if (hints != PsiReferenceService.Hints.NO_HINTS) {
                context.put(PsiReferenceService.HINTS, (Object)hints);
            }
            boolean suitable = false;
            try {
                suitable = ((ElementPattern)info.processingContext).accepts((Object)position, context);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (!suitable) continue;
            output.add(new ProviderBinding.ProviderInfo<ProcessingContext>(info.provider, context, info.priority));
        }
    }
}

