/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceProviderBean;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceProvidersRegistryImpl
extends ReferenceProvidersRegistry {
    private static final LanguageExtension<PsiReferenceContributor> CONTRIBUTOR_EXTENSION = new LanguageExtension(PsiReferenceContributor.EP_NAME.getName());
    private static final LanguageExtension<PsiReferenceProviderBean> REFERENCE_PROVIDER_EXTENSION = new LanguageExtension(PsiReferenceProviderBean.EP_NAME.getName());
    private final Map<Language, PsiReferenceRegistrarImpl> myRegistrars = ContainerUtil.newConcurrentMap();

    @NotNull
    private static PsiReferenceRegistrarImpl createRegistrar(Language language) {
        PsiReferenceRegistrarImpl registrar = new PsiReferenceRegistrarImpl();
        for (PsiReferenceContributor contributor : CONTRIBUTOR_EXTENSION.allForLanguageOrAny(language)) {
            contributor.registerReferenceProviders((PsiReferenceRegistrar)registrar);
        }
        List referenceProviderBeans = REFERENCE_PROVIDER_EXTENSION.allForLanguageOrAny(language);
        for (final PsiReferenceProviderBean providerBean : referenceProviderBeans) {
            ElementPattern pattern = providerBean.createElementPattern();
            if (pattern == null) continue;
            registrar.registerReferenceProvider(pattern, new PsiReferenceProvider(){
                PsiReferenceProvider myProvider;

                @NotNull
                public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                    if (this.myProvider == null) {
                        this.myProvider = providerBean.instantiate();
                        if (this.myProvider == null) {
                            this.myProvider = ReferenceProvidersRegistry.NULL_REFERENCE_PROVIDER;
                        }
                    }
                    return this.myProvider.getReferencesByElement(element, context);
                }
            });
        }
        registrar.markInitialized();
        return registrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiReferenceRegistrarImpl getRegistrar(@NotNull Language language) {
        PsiReferenceRegistrarImpl registrar = this.myRegistrars.get(language);
        if (registrar == null) {
            ReferenceProvidersRegistryImpl referenceProvidersRegistryImpl = this;
            synchronized (referenceProvidersRegistryImpl) {
                registrar = this.myRegistrars.get(language);
                if (registrar == null) {
                    registrar = ReferenceProvidersRegistryImpl.createRegistrar(language);
                    this.myRegistrars.put(language, registrar);
                }
            }
        }
        return registrar;
    }

    @Override
    @NotNull
    protected PsiReference[] doGetReferencesFromProviders(@NotNull PsiElement context, @NotNull PsiReferenceService.Hints hints) {
        List<ProviderBinding.ProviderInfo<ProcessingContext>> providers = this.getRegistrar(context.getLanguage()).getPairsByElement(context, hints);
        MultiMap<Double, PsiReference[]> allReferencesMap = ReferenceProvidersRegistryImpl.mapNotEmptyReferencesFromProviders(context, providers);
        if (allReferencesMap.isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        List result2 = ContainerUtil.newSmartList();
        double maxPriority = ReferenceProvidersRegistryImpl.getMaxPriority(allReferencesMap.keySet());
        List<PsiReference> maxPriorityRefs = ReferenceProvidersRegistryImpl.collectReferences(allReferencesMap.get((Object)maxPriority));
        ContainerUtil.addAllNotNull((Collection)result2, maxPriorityRefs);
        ContainerUtil.addAllNotNull((Collection)result2, ReferenceProvidersRegistryImpl.getLowerPriorityReferences(allReferencesMap, maxPriority, maxPriorityRefs));
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    @NotNull
    private static MultiMap<Double, PsiReference[]> mapNotEmptyReferencesFromProviders(@NotNull PsiElement context, @NotNull List<? extends ProviderBinding.ProviderInfo<ProcessingContext>> providers) {
        MultiMap map2 = new MultiMap();
        for (ProviderBinding.ProviderInfo<ProcessingContext> providerInfo : providers) {
            PsiReference[] refs = ReferenceProvidersRegistryImpl.getReferences(context, providerInfo);
            if ((ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal()) && Registry.is((String)"ide.check.reference.provider.underlying.element")) {
                ReferenceProvidersRegistryImpl.assertReferenceUnderlyingElement(context, refs, providerInfo.provider);
            }
            if (refs.length <= 0) continue;
            map2.putValue((Object)providerInfo.priority, (Object)refs);
        }
        return map2;
    }

    private static void assertReferenceUnderlyingElement(@NotNull PsiElement context, PsiReference[] refs, PsiReferenceProvider provider) {
        for (PsiReference reference : refs) {
            if (reference != null) assert (reference.getElement() == context) : "reference " + reference + " was created for " + context + " but target " + reference.getElement() + ", provider " + provider;
        }
    }

    @NotNull
    private static PsiReference[] getReferences(@NotNull PsiElement context, @NotNull ProviderBinding.ProviderInfo<? extends ProcessingContext> providerInfo) {
        try {
            return providerInfo.provider.getReferencesByElement(context, (ProcessingContext)providerInfo.processingContext);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            return PsiReference.EMPTY_ARRAY;
        }
    }

    @NotNull
    private static List<PsiReference> getLowerPriorityReferences(@NotNull MultiMap<Double, PsiReference[]> allReferencesMap, double maxPriority, @NotNull List<? extends PsiReference> maxPriorityRefs) {
        List result2 = ContainerUtil.newSmartList();
        for (Map.Entry entry : allReferencesMap.entrySet()) {
            if (maxPriority == (Double)entry.getKey()) continue;
            for (Object[] references : (Collection)entry.getValue()) {
                if (!ReferenceProvidersRegistryImpl.haveNotIntersectedTextRanges(maxPriorityRefs, (PsiReference[])references)) continue;
                ContainerUtil.addAllNotNull((Collection)result2, (Object[])references);
            }
        }
        return result2;
    }

    private static boolean haveNotIntersectedTextRanges(@NotNull List<? extends PsiReference> higherPriorityRefs, @NotNull PsiReference[] lowerPriorityRefs) {
        for (PsiReference ref : lowerPriorityRefs) {
            if (ref == null) continue;
            for (PsiReference psiReference : higherPriorityRefs) {
                if (psiReference == null || !ReferenceRange.containsRangeInElement((PsiReference)psiReference, (TextRange)ref.getRangeInElement())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static List<PsiReference> collectReferences(@Nullable Collection<PsiReference[]> references) {
        if (references == null) {
            return Collections.emptyList();
        }
        List list2 = ContainerUtil.newSmartList();
        for (Object[] objectArray : references) {
            ContainerUtil.addAllNotNull((Collection)list2, (Object[])objectArray);
        }
        return list2;
    }

    private static double getMaxPriority(@NotNull Set<Double> doubles) {
        double maxPriority = -100.0;
        for (Double aDouble : doubles) {
            if (!(aDouble > maxPriority)) continue;
            maxPriority = aDouble;
        }
        return maxPriority;
    }

    @Deprecated
    public static void disableUnderlyingElementChecks(@NotNull Disposable parentDisposable) {
        Registry.get((String)"ide.check.reference.provider.underlying.element").setValue(false, parentDisposable);
    }
}

