/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeManipulator
extends AbstractElementManipulator<XmlAttribute> {
    private static final Logger LOG = Logger.getInstance(XmlAttributeManipulator.class);

    public XmlAttribute handleContentChange(@NotNull XmlAttribute attribute, @NotNull TextRange range2, String newContent) throws IncorrectOperationException {
        String attr = attribute.getText();
        ASTNode astNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
        assert (astNode != null);
        PsiElement namePsi = astNode.getPsi();
        int startOffsetInParent = namePsi.getStartOffsetInParent();
        TextRange nameRange = new TextRange(startOffsetInParent, startOffsetInParent + namePsi.getTextLength());
        if (nameRange.contains(range2)) {
            String content = attr.substring(0, range2.getStartOffset()) + newContent + attr.substring(range2.getEndOffset(), nameRange.getEndOffset());
            attribute.setName(content);
        } else {
            XmlAttributeValue value = attribute.getValueElement();
            if (value == null) {
                assert (range2.getStartOffset() == 0 && range2.getEndOffset() == 0);
                attribute.setValue(newContent);
                return attribute;
            }
            StringBuilder replacement = new StringBuilder(value.getText());
            int offset = value.getTextRange().getStartOffset() - attribute.getTextRange().getStartOffset();
            replacement.replace(range2.getStartOffset() - offset, range2.getEndOffset() - offset, newContent);
            attribute.setValue(replacement.toString());
        }
        return attribute;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlAttribute attribute) {
        XmlAttributeValue value = attribute.getValueElement();
        if (value == null) {
            return TextRange.from((int)0, (int)0);
        }
        TextRange range2 = attribute.getValueTextRange();
        if (range2 == null) {
            LOG.error("Null range in " + attribute + " '" + attribute.getText() + "'");
        }
        return range2.shiftRight(value.getStartOffsetInParent());
    }
}

