/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import org.jetbrains.annotations.NotNull;

public class XmlProcessingInstructionManipulator
extends AbstractElementManipulator<XmlProcessingInstruction> {
    public XmlProcessingInstruction handleContentChange(@NotNull XmlProcessingInstruction element, @NotNull TextRange range2, String newContent) throws IncorrectOperationException {
        String text;
        CheckUtil.checkWritable((PsiElement)element);
        CompositeElement attrNode = (CompositeElement)element.getNode();
        LeafElement valueNode = attrNode.findLeafElementAt(range2.getStartOffset());
        HtmlDescriptorsTable.LOG.assertTrue(valueNode != null, (Object)("Leaf not found in " + attrNode + " at offset " + range2.getStartOffset() + " in element " + element));
        PsiElement elementToReplace = valueNode.getPsi();
        try {
            text = elementToReplace.getText();
            int offsetInParent = elementToReplace.getStartOffsetInParent();
            String textBeforeRange = text.substring(0, range2.getStartOffset() - offsetInParent);
            String textAfterRange = text.substring(range2.getEndOffset() - offsetInParent);
            newContent = element.getText().startsWith("'") || element.getText().endsWith("'") ? newContent.replace("'", "&apos;") : newContent.replace("\"", "&quot;");
            text = textBeforeRange + newContent + textAfterRange;
        }
        catch (StringIndexOutOfBoundsException e) {
            HtmlDescriptorsTable.LOG.error("Range: " + range2 + " in text: '" + element.getText() + "'", (Throwable)e);
            throw e;
        }
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree(attrNode);
        LeafElement newValueElement = Factory.createSingleLeafElement(XmlTokenType.XML_TAG_CHARACTERS, text, charTableByTree, element.getManager());
        attrNode.replaceChildInternal(valueNode, newValueElement);
        return element;
    }
}

