/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependentNSReference
extends BasicAttributeValueReference {
    @NotNull
    private final URLReference myReference;
    private final boolean myForceFetchResultValid;

    public DependentNSReference(PsiElement element, TextRange range2, @NotNull URLReference ref) {
        this(element, range2, ref, false);
    }

    public DependentNSReference(PsiElement element, TextRange range2, @NotNull URLReference ref, boolean valid) {
        super(element, range2);
        this.myReference = ref;
        this.myForceFetchResultValid = valid;
    }

    @Nullable
    public PsiElement resolve() {
        String canonicalText = this.getCanonicalText();
        PsiFile file2 = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, this.myElement.getContainingFile(), null);
        if (file2 != null) {
            return file2;
        }
        PsiElement element = this.myReference.resolve();
        if (element == null && !this.myForceFetchResultValid && !XmlUtil.isUrlText(canonicalText, this.myElement.getProject())) {
            return this.myElement;
        }
        return element;
    }

    public boolean isSoft() {
        return false;
    }

    public boolean isForceFetchResultValid() {
        return this.myForceFetchResultValid;
    }

    @NotNull
    public URLReference getNamespaceReference() {
        return this.myReference;
    }
}

