/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.AttributeValueSelfReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdRefReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IdReferenceProvider
extends PsiReferenceProvider {
    @NonNls
    public static final String FOR_ATTR_NAME = "for";
    @NonNls
    public static final String ID_ATTR_NAME = "id";
    @NonNls
    public static final String STYLE_ID_ATTR_NAME = "styleId";
    @NonNls
    public static final String NAME_ATTR_NAME = "name";
    private static final THashSet<String> ourNamespacesWithoutNameReference = new THashSet();

    public String[] getIdForAttributeNames() {
        return new String[]{FOR_ATTR_NAME, ID_ATTR_NAME, NAME_ATTR_NAME, STYLE_ID_ATTR_NAME};
    }

    public ElementFilter getIdForFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                XmlTag tag;
                PsiElement grandParent = ((PsiElement)element).getParent().getParent();
                return grandParent instanceof XmlTag && !(tag = (XmlTag)grandParent).getNamespacePrefix().isEmpty();
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element instanceof XmlAttributeValue) {
            boolean allowReferences;
            boolean jsfNs;
            XmlExtension extension = XmlExtension.getExtensionByElement(element);
            if (extension != null && extension.hasDynamicComponents(element)) {
                return PsiReference.EMPTY_ARRAY;
            }
            final PsiElement parentElement = element.getParent();
            if (!(parentElement instanceof XmlAttribute)) {
                return PsiReference.EMPTY_ARRAY;
            }
            String name = ((XmlAttribute)parentElement).getName();
            String ns = ((XmlAttribute)parentElement).getParent().getNamespace();
            boolean bl = jsfNs = Arrays.asList(XmlUtil.JSF_CORE_URIS).contains(ns) || Arrays.asList(XmlUtil.JSF_HTML_URIS).contains(ns);
            if (FOR_ATTR_NAME.equals(name)) {
                return new PsiReference[]{jsfNs && element.getText().indexOf(58) == -1 ? new IdRefReference(element) : new IdRefReference(element){

                    @Override
                    public boolean isSoft() {
                        XmlAttributeDescriptor descriptor = ((XmlAttribute)parentElement).getDescriptor();
                        return descriptor != null && !descriptor.hasIdRefType();
                    }
                }};
            }
            boolean bl2 = allowReferences = !ourNamespacesWithoutNameReference.contains((Object)ns);
            if (ID_ATTR_NAME.equals(name) && allowReferences || STYLE_ID_ATTR_NAME.equals(name) || NAME_ATTR_NAME.equals(name) && allowReferences) {
                AttributeValueSelfReference attributeValueSelfReference;
                if (jsfNs) {
                    attributeValueSelfReference = new AttributeValueSelfReference(element);
                } else {
                    if (IdReferenceProvider.hasOuterLanguageElement(element)) {
                        return PsiReference.EMPTY_ARRAY;
                    }
                    attributeValueSelfReference = new GlobalAttributeValueSelfReference(element, true);
                }
                return new PsiReference[]{attributeValueSelfReference};
            }
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean hasOuterLanguageElement(@NotNull PsiElement element) {
        for (PsiElement child2 = element.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            if (!(child2 instanceof OuterLanguageElement)) continue;
            return true;
        }
        return false;
    }

    static {
        ourNamespacesWithoutNameReference.add((Object)"http://java.sun.com/JSP/Page");
        ourNamespacesWithoutNameReference.add((Object)"http://struts.apache.org/tags-bean");
        ourNamespacesWithoutNameReference.add((Object)"http://jakarta.apache.org/struts/tags-bean");
        ourNamespacesWithoutNameReference.add((Object)"http://struts.apache.org/tags-logic");
        Collections.addAll(ourNamespacesWithoutNameReference, XmlUtil.JSTL_CORE_URIS);
        ourNamespacesWithoutNameReference.add((Object)"http://struts.apache.org/tags-tiles");
        Collections.addAll(ourNamespacesWithoutNameReference, XmlUtil.SCHEMA_URIS);
    }

    public static class GlobalAttributeValueSelfReference
    extends AttributeValueSelfReference {
        private final boolean mySoft;

        public GlobalAttributeValueSelfReference(PsiElement element, boolean soft) {
            super(element);
            this.mySoft = soft;
        }

        @Override
        public boolean isSoft() {
            return this.mySoft;
        }
    }
}

