/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ProcessingContext;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspxIncludePathReferenceProvider
extends PsiReferenceProvider
implements CustomizableReferenceProvider {
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element instanceof XmlAttributeValue) {
            XmlAttributeValue attributeValue = (XmlAttributeValue)element;
            String valueString = attributeValue.getValue();
            if (valueString.indexOf(63) >= 0) {
                return this.getReferencesByString(valueString.substring(0, valueString.indexOf(63)), (PsiElement)attributeValue, 1);
            }
            return this.getReferencesByString(valueString, (PsiElement)attributeValue, 1);
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            XmlTagValue value = tag.getValue();
            String text = value.getText();
            String trimmedText = text.trim();
            return this.getReferencesByString(trimmedText, (PsiElement)tag, value.getTextRange().getStartOffset() + text.indexOf(trimmedText) - element.getTextOffset());
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    private PsiReference[] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
        return JspxIncludePathReferenceProvider.getFileReferencesFromString(str, position, offsetInPosition, this);
    }

    public static PsiReference[] getFileReferencesFromString(String str, @NotNull PsiElement position, int offsetInPosition, PsiReferenceProvider provider) {
        return JspxIncludePathReferenceProvider.getFileReferenceSet(str, position, offsetInPosition, provider).getAllReferences();
    }

    public static FileReferenceSet getFileReferenceSet(String str, @NotNull PsiElement position, int offsetInPosition, PsiReferenceProvider provider) {
        return new FileReferenceSet(str, position, offsetInPosition, provider, true){

            @Override
            protected boolean useIncludingFileAsContext() {
                return false;
            }
        };
    }

    @Override
    public void setOptions(@Nullable Map<CustomizableReferenceProvider.CustomizationKey, Object> options) {
        this.myOptions = options;
    }

    @Override
    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myOptions;
    }
}

