/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CreateXmlElementIntentionAction;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import org.jetbrains.annotations.NotNull;

public class SchemaReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<TypeOrElementOrAttributeReference> {
    @Override
    public void registerFixes(@NotNull TypeOrElementOrAttributeReference ref, @NotNull QuickFixActionRegistrar registrar) {
        if (ref.getType() == TypeOrElementOrAttributeReference.ReferenceType.TypeReference) {
            registrar.register((IntentionAction)new CreateXmlElementIntentionAction("xml.schema.create.complex.type.intention.name", "complexType", ref));
            registrar.register((IntentionAction)new CreateXmlElementIntentionAction("xml.schema.create.simple.type.intention.name", "simpleType", ref));
        } else if (ref.getType() != null) {
            String key = null;
            String declarationTagName = null;
            if (ref.getType() == TypeOrElementOrAttributeReference.ReferenceType.ElementReference) {
                declarationTagName = "element";
                key = "xml.schema.create.element.intention.name";
            } else if (ref.getType() == TypeOrElementOrAttributeReference.ReferenceType.AttributeReference) {
                declarationTagName = "attribute";
                key = "xml.schema.create.attribute.intention.name";
            } else if (ref.getType() == TypeOrElementOrAttributeReference.ReferenceType.AttributeGroupReference) {
                declarationTagName = "attributeGroup";
                key = "xml.schema.create.attribute.group.intention.name";
            } else if (ref.getType() == TypeOrElementOrAttributeReference.ReferenceType.GroupReference) {
                declarationTagName = "group";
                key = "xml.schema.create.group.intention.name";
            }
            assert (key != null);
            registrar.register((IntentionAction)new CreateXmlElementIntentionAction(key, declarationTagName, ref));
        }
    }

    @Override
    @NotNull
    public Class<TypeOrElementOrAttributeReference> getReferenceClass() {
        return TypeOrElementOrAttributeReference.class;
    }
}

