/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AstSpine
implements StubbedSpine {
    static final AstSpine EMPTY_SPINE = new AstSpine(Collections.emptyList());
    private final List<CompositeElement> myNodes;

    AstSpine(@NotNull List<CompositeElement> nodes) {
        this.myNodes = nodes;
    }

    @Override
    public int getStubCount() {
        return this.myNodes.size();
    }

    @Override
    @Nullable
    public PsiElement getStubPsi(int index) {
        return index >= this.myNodes.size() ? null : this.myNodes.get(index).getPsi();
    }

    public int getStubIndex(@NotNull StubBasedPsiElement psi) {
        return this.myNodes.indexOf((CompositeElement)psi.getNode());
    }

    @Override
    @Nullable
    public IElementType getStubType(int index) {
        return index >= this.myNodes.size() ? null : this.myNodes.get(index).getElementType();
    }

    @NotNull
    public List<CompositeElement> getSpineNodes() {
        return this.myNodes;
    }
}

