/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.diagnostic.PluginException;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import com.intellij.reference.SoftReference;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyParseableElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.LazyParseableElement");
    private static final StaticGetter<CharSequence> NO_TEXT = new StaticGetter(null);
    private final ChameleonLock lock;
    @NotNull
    private volatile Getter<CharSequence> myText;
    private volatile boolean myParsed;
    private static boolean ourParsingAllowed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyParseableElement(@NotNull IElementType type, @Nullable CharSequence text) {
        super(type);
        ChameleonLock chameleonLock = this.lock = new ChameleonLock();
        synchronized (chameleonLock) {
            if (text == null) {
                this.myParsed = true;
                this.myText = NO_TEXT;
            } else {
                this.myText = new StaticGetter((Object)ImmutableCharSequence.asImmutable((CharSequence)text));
                this.setCachedLength(text.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myParsed) {
                this.myText = NO_TEXT;
            } else {
                this.setCachedLength(((CharSequence)this.myText.get()).length());
            }
        }
    }

    @Override
    @NotNull
    public String getText() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.toString();
        }
        String s = super.getText();
        this.myText = new SoftReference((Object)s);
        return s;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence text = this.myText();
        if (text == null) {
            text = super.getText();
            this.myText = new SoftReference((Object)text);
        }
        return text;
    }

    @Override
    public int getTextLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getTextLength();
    }

    @Override
    public int getNotCachedLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getNotCachedLength();
    }

    @Override
    public int hc() {
        CharSequence text = this.myText();
        return text == null ? super.hc() : LeafElement.leafHC(text);
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start2) {
        CharSequence text = this.myText();
        if (text != null) {
            return LeafElement.leafTextMatches(text, buffer, start2);
        }
        return super.textMatches(buffer, start2);
    }

    public boolean isParsed() {
        return this.myParsed;
    }

    private CharSequence myText() {
        return (CharSequence)this.myText.get();
    }

    @Override
    final void setFirstChildNode(TreeElement child2) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setFirstChildNode(child2);
    }

    @Override
    final void setLastChildNode(TreeElement child2) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setLastChildNode(child2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureParsed() {
        if (!ourParsingAllowed) {
            LOG.error("Parsing not allowed!!!");
        }
        if (this.myParsed) {
            return;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            HeavyProcessLatch.INSTANCE.stopThreadPrioritizing();
        }
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myParsed) {
                return;
            }
            CharSequence text = (CharSequence)this.myText.get();
            assert (text != null);
            FileElement fileElement = TreeUtil.getFileElement(this);
            if (fileElement == null) {
                LOG.error("Chameleons must not be parsed till they're in file tree: " + this);
            } else {
                fileElement.assertReadAccessAllowed();
            }
            if (this.rawFirstChild() != null) {
                LOG.error("Reentrant parsing?");
            }
            DebugUtil.performPsiModification("lazy-parsing", () -> {
                TreeElement parsedNode = (TreeElement)((ILazyParseableElementTypeBase)this.getElementType()).parseContents((ASTNode)this);
                this.assertTextLengthIntact(text, parsedNode);
                if (parsedNode != null) {
                    this.setChildren(parsedNode);
                }
                this.myParsed = true;
                this.myText = new SoftReference((Object)text);
            });
        }
    }

    private void assertTextLengthIntact(CharSequence text, TreeElement child2) {
        int length = 0;
        while (child2 != null) {
            length += child2.getTextLength();
            child2 = child2.getTreeNext();
        }
        if (length != text.length()) {
            LOG.error("Text mismatch in " + LogUtil.objectAndClass((Object)this.getElementType()), (Throwable)PluginException.createByClass((String)"Text mismatch", null, this.getElementType().getClass()), new Attachment[]{new Attachment("code.txt", text.toString())});
        }
    }

    private void setChildren(@NotNull TreeElement parsedNode) {
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            try {
                TreeElement last = LazyParseableElement.rawSetParents(parsedNode, this);
                super.setFirstChildNode(parsedNode);
                super.setLastChildNode(last);
            }
            catch (Throwable e) {
                LOG.error("Chameleon expansion may not be interrupted by exceptions", e);
            }
        });
    }

    @Override
    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.rawAddChildrenWithoutNotifications(first);
    }

    @Override
    public TreeElement getFirstChildNode() {
        this.ensureParsed();
        return super.getFirstChildNode();
    }

    @Override
    public TreeElement getLastChildNode() {
        this.ensureParsed();
        return super.getLastChildNode();
    }

    public int copyTo(@Nullable char[] buffer, int start2) {
        CharSequence text = this.myText();
        if (text == null) {
            return -1;
        }
        if (buffer != null) {
            CharArrayUtil.getChars((CharSequence)text, (char[])buffer, (int)start2);
        }
        return start2 + text.length();
    }

    public static void setParsingAllowed(boolean allowed) {
        ourParsingAllowed = allowed;
    }

    private static class ChameleonLock {
        private ChameleonLock() {
        }

        @NonNls
        public String toString() {
            return "chameleon parsing lock";
        }
    }
}

