/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LeafElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.impl.source.tree.LeafElement");
    private static final Key<SoftReference<String>> CACHED_TEXT = Key.create((String)"CACHED_TEXT");
    private static final int TEXT_MATCHES_THRESHOLD = 5;
    private final CharSequence myText;

    protected LeafElement(@NotNull IElementType type, CharSequence text) {
        super(type);
        this.myText = text;
    }

    @Override
    @NotNull
    public LeafElement clone() {
        LeafElement clone = (LeafElement)super.clone();
        clone.clearCaches();
        return clone;
    }

    public int getTextLength() {
        return this.myText.length();
    }

    @NotNull
    public CharSequence getChars() {
        return this.myText;
    }

    @NotNull
    public String getText() {
        CharSequence text = this.myText;
        if (text.length() > 1000 && !(text instanceof String)) {
            String cachedText = (String)SoftReference.dereference((Reference)((Reference)this.getUserData(CACHED_TEXT)));
            if (cachedText == null) {
                cachedText = text.toString();
                this.putUserData(CACHED_TEXT, new SoftReference((Object)cachedText));
            }
            return cachedText;
        }
        return text.toString();
    }

    public char charAt(int position) {
        return this.myText.charAt(position);
    }

    public int copyTo(@Nullable char[] buffer, int start2) {
        int length = this.myText.length();
        if (buffer != null) {
            CharArrayUtil.getChars((CharSequence)this.myText, (char[])buffer, (int)start2, (int)length);
        }
        return start2 + length;
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] buffer = new char[this.myText.length()];
        CharArrayUtil.getChars((CharSequence)this.myText, (char[])buffer, (int)0);
        return buffer;
    }

    public boolean textContains(char c) {
        char[] chars;
        CharSequence text = this.myText;
        int len = text.length();
        if (len > 5 && (chars = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)text)) != null) {
            for (char aChar : chars) {
                if (aChar != c) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (c != text.charAt(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start2) {
        assert (start2 >= 0) : start2;
        return LeafElement.leafTextMatches(this.myText, buffer, start2);
    }

    static int leafTextMatches(@NotNull CharSequence text, @NotNull CharSequence buffer, int start2) {
        assert (start2 >= 0) : start2;
        int length = text.length();
        if (buffer.length() - start2 < length) {
            return start2 == 0 ? Integer.MIN_VALUE : -start2;
        }
        for (int i = 0; i < length; ++i) {
            int k = i + start2;
            if (text.charAt(i) == buffer.charAt(k)) continue;
            return k == 0 ? Integer.MIN_VALUE : -k;
        }
        return start2 + length;
    }

    @NotNull
    public LeafElement rawReplaceWithText(@NotNull String newText) {
        LeafElement newLeaf = ASTFactory.leaf(this.getElementType(), newText);
        this.copyUserDataTo((UserDataHolderBase)newLeaf);
        this.rawReplaceWithList(newLeaf);
        newLeaf.clearCaches();
        return newLeaf;
    }

    @NotNull
    public LeafElement replaceWithText(@NotNull String newText) {
        LeafElement newLeaf = ChangeUtil.copyLeafWithText(this, newText);
        this.getTreeParent().replaceChild(this, newLeaf);
        return newLeaf;
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        return this;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence buf, int start2, int end) {
        CharSequence text = this.getChars();
        int len = text.length();
        if (end - start2 != len) {
            return false;
        }
        if (buf == text) {
            return true;
        }
        if (len > 5 && text instanceof String && buf instanceof String) {
            return ((String)text).regionMatches(0, (String)buf, start2, len);
        }
        for (int i = 0; i < len; ++i) {
            if (text.charAt(i) == buf.charAt(start2 + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void acceptTree(@NotNull TreeElementVisitor visitor) {
        visitor.visitLeaf(this);
    }

    public ASTNode findChildByType(@NotNull IElementType type) {
        return null;
    }

    public ASTNode findChildByType(@NotNull IElementType type, @Nullable ASTNode anchor2) {
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet) {
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, @Nullable ASTNode anchor2) {
        return null;
    }

    @Override
    public int hc() {
        return LeafElement.leafHC(this.getChars());
    }

    static int leafHC(CharSequence text) {
        int len = text.length();
        int hc = 0;
        for (int i = 0; i < len; ++i) {
            hc += text.charAt(i);
        }
        return hc;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return null;
    }

    @Override
    public TreeElement getLastChildNode() {
        return null;
    }

    @Override
    public int getNotCachedLength() {
        return this.myText.length();
    }

    @Override
    public int getCachedLength() {
        return this.getNotCachedLength();
    }

    @NotNull
    public ASTNode[] getChildren(TokenSet filter) {
        return EMPTY_ARRAY;
    }

    public void addChild(@NotNull ASTNode child2, ASTNode anchorBefore) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addLeaf(@NotNull IElementType leafType, @NotNull CharSequence leafText, ASTNode anchorBefore) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addChild(@NotNull ASTNode child2) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void removeChild(@NotNull ASTNode child2) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void replaceAllChildrenToChildrenOf(@NotNull ASTNode anotherParent) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addChildren(@NotNull ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public PsiElement getPsi() {
        return null;
    }

    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    static <T extends PsiElement> T getPsi(@NotNull Class<T> clazz, PsiElement element, @NotNull Logger log2) {
        log2.assertTrue(clazz.isInstance(element), (Object)("unexpected psi class. expected: " + clazz + " got: " + (element == null ? null : element.getClass())));
        return (T)element;
    }
}

