/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightTreeUtil {
    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull IElementType type) {
        if (node == null) {
            return null;
        }
        List children2 = tree.getChildren(node);
        for (int i = 0; i < children2.size(); ++i) {
            LighterASTNode child2 = (LighterASTNode)children2.get(i);
            if (child2.getTokenType() != type) continue;
            return child2;
        }
        return null;
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull TokenSet types) {
        if (node == null) {
            return null;
        }
        List children2 = tree.getChildren(node);
        for (int i = 0; i < children2.size(); ++i) {
            LighterASTNode child2 = (LighterASTNode)children2.get(i);
            if (!types.contains(child2.getTokenType())) continue;
            return child2;
        }
        return null;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        LighterASTNode child2 = LightTreeUtil.firstChildOfType(tree, node, type);
        assert (child2 != null) : "Required child " + type + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        return child2;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        LighterASTNode child2 = LightTreeUtil.firstChildOfType(tree, node, types);
        assert (child2 != null) : "Required child " + types + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        return child2;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        SmartList result2 = null;
        List children2 = tree.getChildren(node);
        int size = children2.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child2 = (LighterASTNode)children2.get(i);
            if (child2.getTokenType() != type) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add((LighterASTNode)child2);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        List children2 = tree.getChildren(node);
        SmartList result2 = null;
        int size = children2.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child2 = (LighterASTNode)children2.get(i);
            if (!types.contains(child2.getTokenType())) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add((LighterASTNode)child2);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    @NotNull
    public static String toFilteredString(@NotNull LighterAST tree, @NotNull LighterASTNode node, @Nullable TokenSet skipTypes) {
        int length = node.getEndOffset() - node.getStartOffset();
        if (length < 0) {
            length = 0;
            Logger.getInstance(LightTreeUtil.class).error("tree=" + tree + " node=" + node);
        }
        StringBuilder buffer = new StringBuilder(length);
        LightTreeUtil.toBuffer(tree, node, buffer, skipTypes);
        return buffer.toString();
    }

    public static void toBuffer(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StringBuilder buffer, @Nullable TokenSet skipTypes) {
        if (skipTypes != null && skipTypes.contains(node.getTokenType())) {
            return;
        }
        if (node instanceof LighterASTTokenNode) {
            buffer.append(((LighterASTTokenNode)node).getText());
            return;
        }
        if (node instanceof LighterLazyParseableNode) {
            buffer.append(((LighterLazyParseableNode)node).getText());
            return;
        }
        List children2 = tree.getChildren(node);
        int size = children2.size();
        for (int i = 0; i < size; ++i) {
            LightTreeUtil.toBuffer(tree, (LighterASTNode)children2.get(i), buffer, skipTypes);
        }
    }

    @Nullable
    public static LighterASTNode getParentOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull TokenSet types, @NotNull TokenSet stopAt) {
        if (node == null) {
            return null;
        }
        node = tree.getParent(node);
        while (node != null) {
            IElementType type = node.getTokenType();
            if (types.contains(type)) {
                return node;
            }
            if (stopAt.contains(type)) {
                return null;
            }
            node = tree.getParent(node);
        }
        return null;
    }

    @Nullable
    public static LighterASTNode findLeafElementAt(@NotNull LighterAST tree, int offset) {
        LighterASTNode eachNode = tree.getRoot();
        if (!LightTreeUtil.containsOffset(eachNode, offset)) {
            return null;
        }
        while (eachNode != null) {
            List children2 = tree.getChildren(eachNode);
            if (children2.isEmpty()) {
                return eachNode;
            }
            eachNode = LightTreeUtil.findChildAtOffset(offset, children2);
        }
        return null;
    }

    private static LighterASTNode findChildAtOffset(int offset, List<? extends LighterASTNode> children2) {
        return (LighterASTNode)ContainerUtil.find(children2, node -> LightTreeUtil.containsOffset(node, offset));
    }

    private static boolean containsOffset(LighterASTNode node, int offset) {
        return node.getStartOffset() <= offset && node.getEndOffset() > offset;
    }
}

