/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.WalkingState;
import org.jetbrains.annotations.NotNull;

public abstract class RecursiveTreeElementWalkingVisitor
extends TreeElementVisitor
implements PsiRecursiveVisitor {
    private final boolean myDoTransform;
    private final WalkingState<ASTNode> myWalkingState = new WalkingState<ASTNode>((WalkingState.TreeGuide)ASTTreeGuide.access$000()){

        public void elementFinished(@NotNull ASTNode element) {
            RecursiveTreeElementWalkingVisitor.this.elementFinished(element);
        }

        public void visit(@NotNull ASTNode element) {
            ((TreeElement)element).acceptTree(RecursiveTreeElementWalkingVisitor.this);
        }
    };

    protected RecursiveTreeElementWalkingVisitor() {
        this(true);
    }

    protected RecursiveTreeElementWalkingVisitor(boolean doTransform) {
        this.myDoTransform = doTransform;
    }

    protected void elementFinished(@NotNull ASTNode element) {
    }

    @Override
    public void visitLeaf(LeafElement leaf) {
        this.visitNode(leaf);
    }

    @Override
    public void visitComposite(CompositeElement composite) {
        this.visitNode(composite);
    }

    protected void visitNode(TreeElement element) {
        if (this.myDoTransform || !TreeUtil.isCollapsedChameleon(element)) {
            this.myWalkingState.elementStarted((Object)element);
        }
    }

    public void stopWalking() {
        this.myWalkingState.stopWalking();
    }

    private static class ASTTreeGuide
    implements WalkingState.TreeGuide<ASTNode> {
        private static final ASTTreeGuide instance = new ASTTreeGuide();

        private ASTTreeGuide() {
        }

        public ASTNode getNextSibling(@NotNull ASTNode element) {
            return element.getTreeNext();
        }

        public ASTNode getPrevSibling(@NotNull ASTNode element) {
            return element.getTreePrev();
        }

        public ASTNode getFirstChild(@NotNull ASTNode element) {
            return element.getFirstChildNode();
        }

        public ASTNode getParent(@NotNull ASTNode element) {
            return element.getTreeParent();
        }

        static /* synthetic */ ASTTreeGuide access$000() {
            return instance;
        }
    }
}

