/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiParameterizedCachedValue;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConcatenationInjectorManager
extends SimpleModificationTracker {
    public static final ProjectExtensionPointName<ConcatenationAwareInjector> CONCATENATION_INJECTOR_EP_NAME = new ProjectExtensionPointName("com.intellij.concatenationAwareInjector");
    private static final Key<ParameterizedCachedValue<InjectionResult, PsiElement>> INJECTED_PSI_IN_CONCATENATION = Key.create((String)"INJECTED_PSI_IN_CONCATENATION");
    private static final Key<Integer> NO_CONCAT_INJECTION_TIMESTAMP = Key.create((String)"NO_CONCAT_INJECTION_TIMESTAMP");
    private final List<ConcatenationAwareInjector> myConcatenationInjectors = ContainerUtil.createLockFreeCopyOnWriteList();

    public ConcatenationInjectorManager(Project project, PsiManagerEx psiManagerEx) {
        CONCATENATION_INJECTOR_EP_NAME.getPoint((AreaInstance)project).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ConcatenationAwareInjector>(){

            public void extensionAdded(@NotNull ConcatenationAwareInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                ConcatenationInjectorManager.this.registerConcatenationInjector(injector);
            }

            public void extensionRemoved(@NotNull ConcatenationAwareInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                ConcatenationInjectorManager.this.unregisterConcatenationInjector(injector);
            }
        }, true, (Disposable)project);
        psiManagerEx.registerRunnableToRunOnAnyChange(() -> ((ConcatenationInjectorManager)this).incModificationCount());
    }

    public static ConcatenationInjectorManager getInstance(Project project) {
        return (ConcatenationInjectorManager)((Object)ServiceManager.getService((Project)project, ConcatenationInjectorManager.class));
    }

    private static InjectionResult doCompute(@NotNull PsiFile containingFile, @NotNull Project project, @NotNull PsiElement anchor2, @NotNull PsiElement[] operands) {
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
        InjectionRegistrarImpl registrar = new InjectionRegistrarImpl(project, containingFile, anchor2, docManager);
        InjectionResult result2 = null;
        ConcatenationInjectorManager concatenationInjectorManager = ConcatenationInjectorManager.getInstance(project);
        for (ConcatenationAwareInjector concatenationInjector : concatenationInjectorManager.myConcatenationInjectors) {
            concatenationInjector.getLanguagesToInject((MultiHostRegistrar)registrar, operands);
            result2 = registrar.getInjectedResult();
            if (result2 == null) continue;
            break;
        }
        return result2;
    }

    public void registerConcatenationInjector(@NotNull ConcatenationAwareInjector injector) {
        this.myConcatenationInjectors.add(injector);
        this.concatenationInjectorsChanged();
    }

    public boolean unregisterConcatenationInjector(@NotNull ConcatenationAwareInjector injector) {
        boolean removed = this.myConcatenationInjectors.remove(injector);
        this.concatenationInjectorsChanged();
        return removed;
    }

    private void concatenationInjectorsChanged() {
        this.incModificationCount();
    }

    public static abstract class BaseConcatenation2InjectorAdapter
    implements MultiHostInjector {
        private final ConcatenationInjectorManager myManager;

        public BaseConcatenation2InjectorAdapter(ConcatenationInjectorManager manager) {
            this.myManager = manager;
        }

        public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
            InjectionResult result2;
            if (this.myManager.myConcatenationInjectors.isEmpty()) {
                return;
            }
            PsiFile containingFile = ((InjectionRegistrarImpl)registrar).getHostPsiFile();
            Project project = containingFile.getProject();
            long modificationCount = PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount();
            Pair<PsiElement, PsiElement[]> pair = this.computeAnchorAndOperands(context);
            PsiElement anchor2 = (PsiElement)pair.first;
            PsiElement[] operands = (PsiElement[])pair.second;
            Integer noInjectionTimestamp = (Integer)anchor2.getUserData(NO_CONCAT_INJECTION_TIMESTAMP);
            ParameterizedCachedValue data = null;
            if (operands.length == 0 || noInjectionTimestamp != null && (long)noInjectionTimestamp.intValue() == modificationCount) {
                result2 = null;
            } else {
                data = (ParameterizedCachedValue)anchor2.getUserData(INJECTED_PSI_IN_CONCATENATION);
                InjectionResult injectionResult = result2 = data == null ? null : (InjectionResult)data.getValue((Object)context);
                if (result2 == null || !result2.isValid()) {
                    result2 = ConcatenationInjectorManager.doCompute(containingFile, project, anchor2, operands);
                }
            }
            if (result2 != null) {
                ((InjectionRegistrarImpl)registrar).addToResults(result2);
                if (data == null) {
                    CachedValueProvider.Result cachedResult = CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.myManager});
                    data = CachedValuesManager.getManager((Project)project).createParameterizedCachedValue(context1 -> {
                        PsiFile containingFile1 = context1.getContainingFile();
                        Project project1 = containingFile1.getProject();
                        Pair<PsiElement, PsiElement[]> pair1 = this.computeAnchorAndOperands((PsiElement)context1);
                        InjectionResult result1 = ((PsiElement[])pair1.second).length == 0 ? null : ConcatenationInjectorManager.doCompute(containingFile1, project1, (PsiElement)pair1.first, (PsiElement[])pair1.second);
                        return result1 == null ? null : CachedValueProvider.Result.create((Object)result1, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.myManager});
                    }, false);
                    ((PsiParameterizedCachedValue)data).setValue(cachedResult);
                    anchor2.putUserData(INJECTED_PSI_IN_CONCATENATION, (Object)data);
                    if (anchor2.getUserData(NO_CONCAT_INJECTION_TIMESTAMP) != null) {
                        anchor2.putUserData(NO_CONCAT_INJECTION_TIMESTAMP, null);
                    }
                }
            } else {
                if (anchor2.getUserData(INJECTED_PSI_IN_CONCATENATION) != null) {
                    anchor2.putUserData(INJECTED_PSI_IN_CONCATENATION, null);
                }
                anchor2.putUserData(NO_CONCAT_INJECTION_TIMESTAMP, (Object)((int)modificationCount));
            }
        }

        protected abstract Pair<PsiElement, PsiElement[]> computeAnchorAndOperands(@NotNull PsiElement var1);
    }
}

