/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedCaret
implements Caret {
    private final EditorWindow myEditorWindow;
    final Caret myDelegate;

    InjectedCaret(EditorWindow window, Caret delegate) {
        this.myEditorWindow = window;
        this.myDelegate = delegate;
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditorWindow;
    }

    @NotNull
    public CaretModel getCaretModel() {
        return this.myEditorWindow.getCaretModel();
    }

    public Caret getDelegate() {
        return this.myDelegate;
    }

    public boolean isValid() {
        return this.myDelegate.isValid();
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        this.myDelegate.moveCaretRelatively(columnShift, lineShift, withSelection, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(pos);
        this.myDelegate.moveToLogicalPosition(hostPos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(this.myEditorWindow.visualToLogicalPosition(pos));
        this.myDelegate.moveToLogicalPosition(hostPos);
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        int hostOffset = this.myEditorWindow.getDocument().injectedToHost(offset);
        this.myDelegate.moveToOffset(hostOffset, locateBeforeSoftWrap);
    }

    public boolean isUpToDate() {
        return this.myDelegate.isUpToDate();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition hostPos = this.myDelegate.getLogicalPosition();
        return this.myEditorWindow.hostToInjected(hostPos);
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        LogicalPosition logicalPosition = this.getLogicalPosition();
        return this.myEditorWindow.logicalToVisualPosition(logicalPosition);
    }

    public int getOffset() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getOffset());
    }

    public int getVisualLineStart() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getVisualLineStart());
    }

    public int getVisualLineEnd() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getVisualLineEnd());
    }

    public int getSelectionStart() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getSelectionStart());
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        return this.myDelegate.getSelectionStartPosition();
    }

    public int getSelectionEnd() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getSelectionEnd());
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        return this.myDelegate.getSelectionEndPosition();
    }

    @Nullable
    public String getSelectedText() {
        return this.myDelegate.getSelectedText();
    }

    public int getLeadSelectionOffset() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getLeadSelectionOffset());
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        return this.myDelegate.getLeadSelectionPosition();
    }

    public boolean hasSelection() {
        return this.myDelegate.hasSelection();
    }

    public void setSelection(int startOffset, int endOffset) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(hostRange.getStartOffset(), hostRange.getEndOffset());
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(hostRange.getStartOffset(), hostRange.getEndOffset(), updateSystemSelection);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(hostRange.getStartOffset(), endPosition, hostRange.getEndOffset());
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(startPosition, hostRange.getStartOffset(), endPosition, hostRange.getEndOffset());
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(startPosition, hostRange.getStartOffset(), endPosition, hostRange.getEndOffset(), updateSystemSelection);
    }

    public void removeSelection() {
        this.myDelegate.removeSelection();
    }

    public void selectLineAtCaret() {
        this.myDelegate.selectLineAtCaret();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.myDelegate.selectWordAtCaret(honorCamelWordsSettings);
    }

    @Nullable
    public Caret clone(boolean above) {
        Caret clone = this.myDelegate.clone(above);
        return clone == null ? null : new InjectedCaret(this.myEditorWindow, clone);
    }

    public void dispose() {
        this.myDelegate.dispose();
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        return (T)this.myDelegate.putUserDataIfAbsent(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        return this.myDelegate.replace(key, oldValue, newValue);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myDelegate.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myDelegate.putUserData(key, value);
    }

    public boolean isAtRtlLocation() {
        return this.myDelegate.isAtRtlLocation();
    }

    public boolean isAtBidiRunBoundary() {
        return this.myDelegate.isAtBidiRunBoundary();
    }

    @NotNull
    public CaretVisualAttributes getVisualAttributes() {
        return this.myDelegate.getVisualAttributes();
    }

    public void setVisualAttributes(@NotNull CaretVisualAttributes attributes) {
        this.myDelegate.setVisualAttributes(attributes);
    }
}

