/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InjectedFileViewProvider
extends SingleRootFileViewProvider
implements FreeThreadedFileViewProvider {
    private final Object myLock = new Object();
    private final DocumentWindowImpl myDocumentWindow;
    private static final ThreadLocal<Boolean> disabledTemporarily = ThreadLocal.withInitial(() -> false);
    private boolean myPatchingLeaves;
    static Key<Language> LANGUAGE_FOR_INJECTED_COPY_KEY = Key.create((String)"LANGUAGE_FOR_INJECTED_COPY_KEY");

    InjectedFileViewProvider(@NotNull PsiManager psiManager, @NotNull VirtualFileWindow virtualFile, @NotNull DocumentWindowImpl documentWindow, @NotNull Language language) {
        super(psiManager, (VirtualFile)virtualFile, true, language);
        this.myDocumentWindow = documentWindow;
    }

    @Override
    public void rootChanged(@NotNull PsiFile psiFile) {
        super.rootChanged(psiFile);
        if (!this.isPhysical()) {
            return;
        }
        if (this.myPatchingLeaves) {
            return;
        }
        DocumentWindowImpl documentWindow = this.myDocumentWindow;
        Place shreds = documentWindow.getShreds();
        assert (documentWindow.getHostRanges().length == shreds.size());
        String[] changes2 = documentWindow.calculateMinEditSequence(psiFile.getNode().getText());
        assert (changes2.length == shreds.size());
        for (int i = 0; i < changes2.length; ++i) {
            String change = changes2[i];
            if (change == null) continue;
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(i);
            PsiLanguageInjectionHost host = shred.getHost();
            TextRange rangeInsideHost = shred.getRangeInsideHost();
            String newHostText = StringUtil.replaceSubstring((String)host.getText(), (TextRange)rangeInsideHost, (String)change);
            host.updateText(newHostText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileViewProvider clone() {
        DocumentWindow oldDocumentWindow = ((VirtualFileWindow)this.getVirtualFile()).getDocumentWindow();
        Document hostDocument = oldDocumentWindow.getDelegate();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getManager().getProject());
        PsiFile hostFile = documentManager.getPsiFile(hostDocument);
        Language language = this.getBaseLanguage();
        PsiFile file2 = this.getPsi(language);
        Language hostFileLanguage = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2).getLanguage();
        PsiFile hostPsiFileCopy = (PsiFile)hostFile.copy();
        Segment firstTextRange = oldDocumentWindow.getHostRanges()[0];
        PsiElement hostElementCopy = hostPsiFileCopy.getViewProvider().findElementAt(firstTextRange.getStartOffset(), hostFileLanguage);
        assert (hostElementCopy != null);
        Ref provider = new Ref();
        PsiLanguageInjectionHost.InjectedPsiVisitor visitor = (injectedPsi, places) -> {
            Document document = documentManager.getCachedDocument(injectedPsi);
            if (document instanceof DocumentWindowImpl && oldDocumentWindow.areRangesEqual((DocumentWindow)((DocumentWindowImpl)document))) {
                provider.set((Object)injectedPsi.getViewProvider());
            }
        };
        for (PsiElement current = hostElementCopy; current != null && current != hostPsiFileCopy; current = current.getParent()) {
            current.putUserData(LANGUAGE_FOR_INJECTED_COPY_KEY, (Object)language);
            try {
                InjectedLanguageManager.getInstance((Project)hostPsiFileCopy.getProject()).enumerateEx(current, hostPsiFileCopy, false, visitor);
            }
            finally {
                current.putUserData(LANGUAGE_FOR_INJECTED_COPY_KEY, null);
            }
            if (provider.get() != null) break;
        }
        return (FileViewProvider)provider.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setShreds(@NotNull Place newShreds) {
        Object object = this.myLock;
        synchronized (object) {
            Place oldShreds = this.myDocumentWindow.getShreds();
            if (InjectedFileViewProvider.same(oldShreds, newShreds)) {
                return false;
            }
            this.myDocumentWindow.setShreds(newShreds);
            return true;
        }
    }

    @NotNull
    private Project getProject() {
        return this.getManager().getProject();
    }

    private static boolean same(Place oldShreds, Place newShreds) {
        if (oldShreds == newShreds) {
            return true;
        }
        if (oldShreds.size() != newShreds.size()) {
            return false;
        }
        for (int i = 0; i < oldShreds.size(); ++i) {
            PsiLanguageInjectionHost.Shred newShred;
            PsiLanguageInjectionHost.Shred oldShred = (PsiLanguageInjectionHost.Shred)oldShreds.get(i);
            if (oldShred.equals(newShred = (PsiLanguageInjectionHost.Shred)newShreds.get(i))) continue;
            return false;
        }
        return true;
    }

    boolean isValid() {
        return this.getShreds().isValid();
    }

    boolean isDisposed() {
        return this.getProject().isDisposed();
    }

    Place getShreds() {
        return this.myDocumentWindow.getShreds();
    }

    @NotNull
    public DocumentWindow getDocument() {
        return this.myDocumentWindow;
    }

    @Override
    public boolean isEventSystemEnabled() {
        return disabledTemporarily.get() == false;
    }

    @Override
    public boolean isPhysical() {
        return this.isEventSystemEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performNonPhysically(Runnable runnable2) {
        Object object = this.myLock;
        synchronized (object) {
            disabledTemporarily.set(true);
            try {
                runnable2.run();
            }
            finally {
                disabledTemporarily.set(false);
            }
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "Injected file '" + this.getVirtualFile().getName() + "' " + (this.isValid() ? "" : " invalid") + (this.isPhysical() ? "" : " nonphysical");
    }

    void doNotInterruptMeWhileImPatchingLeaves(@NotNull Runnable runnable2) {
        this.myPatchingLeaves = true;
        try {
            runnable2.run();
        }
        finally {
            this.myPatchingLeaves = false;
        }
    }
}

