/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.ClassMapCachingNulls;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.EditorWindowImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.ShredImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedLanguageManagerImpl
extends InjectedLanguageManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl");
    static final Object ourInjectionPsiLock = new String("injectionPsiLock");
    private final Project myProject;
    private final DumbService myDumbService;
    private final PsiDocumentManager myDocManager;
    private final Set<MultiHostInjector> myManualInjectors = Collections.synchronizedSet(new LinkedHashSet());
    private volatile ClassMapCachingNulls<MultiHostInjector> cachedInjectors;
    private final Map<Class, MultiHostInjector[]> myInjectorsClone = new HashMap<Class, MultiHostInjector[]>();

    public static InjectedLanguageManagerImpl getInstanceImpl(Project project) {
        return (InjectedLanguageManagerImpl)InjectedLanguageManager.getInstance((Project)project);
    }

    public InjectedLanguageManagerImpl(Project project, DumbService dumbService) {
        this.myProject = project;
        this.myDumbService = dumbService;
        this.myDocManager = PsiDocumentManager.getInstance((Project)project);
        MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.getPoint((AreaInstance)project).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<MultiHostInjector>(){

            public void extensionAdded(@NotNull MultiHostInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                InjectedLanguageManagerImpl.this.clearInjectorCache();
            }

            public void extensionRemoved(@NotNull MultiHostInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                InjectedLanguageManagerImpl.this.clearInjectorCache();
            }
        }, false, (Disposable)this);
        LanguageInjector.EXTENSION_POINT_NAME.getPoint(null).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<LanguageInjector>(){

            public void extensionAdded(@NotNull LanguageInjector extension, @Nullable PluginDescriptor pluginDescriptor) {
                InjectedLanguageManagerImpl.this.clearInjectorCache();
            }

            public void extensionRemoved(@NotNull LanguageInjector extension, @Nullable PluginDescriptor pluginDescriptor) {
                InjectedLanguageManagerImpl.this.clearInjectorCache();
            }
        }, false, (Disposable)this);
    }

    PsiDocumentManager getDocManager() {
        return this.myDocManager;
    }

    public void dispose() {
        InjectedLanguageManagerImpl.disposeInvalidEditors();
    }

    public static void disposeInvalidEditors() {
        EditorWindowImpl.disposeInvalidEditors();
    }

    public PsiLanguageInjectionHost getInjectionHost(@NotNull FileViewProvider provider) {
        if (!(provider instanceof InjectedFileViewProvider)) {
            return null;
        }
        return (PsiLanguageInjectionHost)((InjectedFileViewProvider)provider).getShreds().getHostPointer().getElement();
    }

    public PsiLanguageInjectionHost getInjectionHost(@NotNull PsiElement element) {
        PsiElement host;
        VirtualFile virtualFile;
        PsiFile file2 = element.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = file2 == null ? null : file2.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow && (host = FileContextUtil.getFileContext(file2)) instanceof PsiLanguageInjectionHost) {
            return (PsiLanguageInjectionHost)host;
        }
        return null;
    }

    @NotNull
    public TextRange injectedToHost(@NotNull PsiElement injectedContext, @NotNull TextRange injectedTextRange) {
        DocumentWindow documentWindow = InjectedLanguageManagerImpl.getDocumentWindow(injectedContext);
        return documentWindow == null ? injectedTextRange : documentWindow.injectedToHost(injectedTextRange);
    }

    public int injectedToHost(@NotNull PsiElement element, int offset) {
        DocumentWindow documentWindow = InjectedLanguageManagerImpl.getDocumentWindow(element);
        return documentWindow == null ? offset : documentWindow.injectedToHost(offset);
    }

    public int injectedToHost(@NotNull PsiElement injectedContext, int injectedOffset, boolean minHostOffset) {
        DocumentWindow documentWindow = InjectedLanguageManagerImpl.getDocumentWindow(injectedContext);
        return documentWindow == null ? injectedOffset : documentWindow.injectedToHost(injectedOffset, minHostOffset);
    }

    private static DocumentWindow getDocumentWindow(@NotNull PsiElement element) {
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getCachedDocument(file2);
        return !(document instanceof DocumentWindow) ? null : (DocumentWindow)document;
    }

    public void processInjectableElements(@NotNull Collection<? extends PsiElement> in, @NotNull Processor<? super PsiElement> processor2) {
        ClassMapCachingNulls<MultiHostInjector> map2 = this.getInjectorMap();
        for (PsiElement psiElement : in) {
            if (map2.get(psiElement.getClass()) == null) continue;
            processor2.process((Object)psiElement);
        }
    }

    @NotNull
    private ClassMapCachingNulls<MultiHostInjector> getInjectorMap() {
        ClassMapCachingNulls<MultiHostInjector> cached = this.cachedInjectors;
        if (cached != null) {
            return cached;
        }
        HashMap injectors = ContainerUtil.newHashMap();
        ArrayList allInjectors = ContainerUtil.newArrayList();
        allInjectors.addAll(this.myManualInjectors);
        Collections.addAll(allInjectors, MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.getExtensions((AreaInstance)this.myProject));
        if (LanguageInjector.EXTENSION_POINT_NAME.hasAnyExtensions()) {
            allInjectors.add(PsiManagerRegisteredInjectorsAdapter.INSTANCE);
        }
        for (MultiHostInjector injector : allInjectors) {
            for (Class place : injector.elementsToInjectIn()) {
                MultiHostInjector[] multiHostInjectorArray;
                LOG.assertTrue(place != null, (Object)injector);
                Object[] existing = (MultiHostInjector[])injectors.get(place);
                if (existing == null) {
                    MultiHostInjector[] multiHostInjectorArray2 = new MultiHostInjector[1];
                    multiHostInjectorArray = multiHostInjectorArray2;
                    multiHostInjectorArray2[0] = injector;
                } else {
                    multiHostInjectorArray = (MultiHostInjector[])ArrayUtil.append((Object[])existing, (Object)injector);
                }
                injectors.put(place, multiHostInjectorArray);
            }
        }
        ClassMapCachingNulls<MultiHostInjector> result2 = new ClassMapCachingNulls<MultiHostInjector>(injectors, new MultiHostInjector[0], allInjectors);
        this.cachedInjectors = result2;
        return result2;
    }

    private void clearInjectorCache() {
        this.cachedInjectors = null;
    }

    public void registerMultiHostInjector(@NotNull MultiHostInjector injector) {
        this.myManualInjectors.add(injector);
        this.clearInjectorCache();
    }

    public void registerMultiHostInjector(@NotNull MultiHostInjector injector, @NotNull Disposable parentDisposable) {
        this.registerMultiHostInjector(injector);
        Disposer.register((Disposable)parentDisposable, () -> this.unregisterMultiHostInjector(injector));
    }

    private void unregisterMultiHostInjector(@NotNull MultiHostInjector injector) {
        try {
            this.myManualInjectors.remove(injector);
        }
        finally {
            this.clearInjectorCache();
        }
    }

    @NotNull
    public String getUnescapedText(@NotNull PsiElement injectedNode) {
        String leafText = InjectedLanguageUtil.getUnescapedLeafText(injectedNode, false);
        if (leafText != null) {
            return leafText;
        }
        final StringBuilder text = new StringBuilder(injectedNode.getTextLength());
        injectedNode.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                String leafText = InjectedLanguageUtil.getUnescapedLeafText(element, false);
                if (leafText != null) {
                    text.append(leafText);
                    return;
                }
                super.visitElement(element);
            }
        });
        return text.toString();
    }

    @NotNull
    public List<TextRange> intersectWithAllEditableFragments(@NotNull PsiFile injectedPsi, @NotNull TextRange rangeToEdit) {
        Place shreds = InjectedLanguageUtil.getShreds(injectedPsi);
        if (shreds == null) {
            return Collections.emptyList();
        }
        Object result2 = null;
        int count = 0;
        int offset = 0;
        Iterator iterator = shreds.iterator();
        while (iterator.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
            TextRange encodedRange = TextRange.from((int)(offset + shred.getPrefix().length()), (int)shred.getRangeInsideHost().getLength());
            TextRange intersection = encodedRange.intersection(rangeToEdit);
            if (intersection != null) {
                if (++count == 1) {
                    result2 = intersection;
                } else if (count == 2) {
                    TextRange range2 = result2;
                    if (range2.isEmpty()) {
                        result2 = intersection;
                        count = 1;
                    } else if (intersection.isEmpty()) {
                        count = 1;
                    } else {
                        ArrayList<TextRange> list2 = new ArrayList<TextRange>();
                        list2.add(range2);
                        list2.add(intersection);
                        result2 = list2;
                    }
                } else if (intersection.isEmpty()) {
                    --count;
                } else {
                    ((List)result2).add(intersection);
                }
            }
            offset += shred.getPrefix().length() + shred.getRangeInsideHost().getLength() + shred.getSuffix().length();
        }
        return count == 0 ? Collections.emptyList() : (count == 1 ? Collections.singletonList((TextRange)result2) : (List<TextRange>)result2);
    }

    public boolean isInjectedFragment(@NotNull PsiFile file2) {
        return file2.getViewProvider() instanceof InjectedFileViewProvider;
    }

    public PsiElement findInjectedElementAt(@NotNull PsiFile hostFile, int hostDocumentOffset) {
        return InjectedLanguageUtil.findInjectedElementNoCommit(hostFile, hostDocumentOffset);
    }

    public void dropFileCaches(@NotNull PsiFile file2) {
        InjectedLanguageUtil.clearCachedInjectedFragmentsForFile(file2);
    }

    public PsiFile getTopLevelFile(@NotNull PsiElement element) {
        return InjectedLanguageUtil.getTopLevelFile(element);
    }

    @NotNull
    public List<DocumentWindow> getCachedInjectedDocumentsInRange(@NotNull PsiFile hostPsiFile, @NotNull TextRange range2) {
        return InjectedLanguageUtil.getCachedInjectedDocumentsInRange(hostPsiFile, range2);
    }

    public void enumerate(@NotNull PsiElement host, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        InjectedLanguageUtil.enumerate(host, visitor);
    }

    public void enumerateEx(@NotNull PsiElement host, @NotNull PsiFile containingFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        InjectedLanguageUtil.enumerate(host, containingFile, probeUp, visitor);
    }

    @NotNull
    public List<TextRange> getNonEditableFragments(@NotNull DocumentWindow window) {
        ArrayList result2 = ContainerUtil.newArrayList();
        int offset = 0;
        Iterator iterator = ((DocumentWindowImpl)window).getShreds().iterator();
        while (iterator.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
            Segment hostRange = shred.getHostRangeMarker();
            if (hostRange == null) continue;
            offset = InjectedLanguageManagerImpl.appendRange(result2, offset, shred.getPrefix().length());
            offset += hostRange.getEndOffset() - hostRange.getStartOffset();
            offset = InjectedLanguageManagerImpl.appendRange(result2, offset, shred.getSuffix().length());
        }
        return result2;
    }

    public boolean mightHaveInjectedFragmentAtOffset(@NotNull Document hostDocument, int hostOffset) {
        return InjectedLanguageUtil.mightHaveInjectedFragmentAtCaret(this.myProject, hostDocument, hostOffset);
    }

    @NotNull
    public DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        Place shreds = ((DocumentWindowImpl)document).getShreds();
        Project project = shreds.getHostPointer().getProject();
        DocumentEx delegate = ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project)).getLastCommittedDocument(document.getDelegate());
        Place place = new Place();
        place.addAll(ContainerUtil.map((Collection)((Object)shreds), shred -> ((ShredImpl)shred).withPsiRange()));
        return new DocumentWindowImpl(delegate, place);
    }

    private static int appendRange(@NotNull List<TextRange> result2, int start2, int length) {
        if (length > 0) {
            TextRange lastRange;
            int lastIndex = result2.size() - 1;
            TextRange textRange = lastRange = lastIndex >= 0 ? result2.get(lastIndex) : null;
            if (lastRange != null && lastRange.getEndOffset() == start2) {
                result2.set(lastIndex, lastRange.grown(length));
            } else {
                result2.add(TextRange.from((int)start2, (int)length));
            }
        }
        return start2 + length;
    }

    public static void pushInjectors(@NotNull Project project) {
        InjectedLanguageManagerImpl cachedManager = (InjectedLanguageManagerImpl)((Object)project.getUserData((Key)INSTANCE_CACHE));
        if (cachedManager == null) {
            return;
        }
        try {
            assert (cachedManager.myInjectorsClone.isEmpty()) : cachedManager.myInjectorsClone;
        }
        finally {
            cachedManager.myInjectorsClone.clear();
        }
        cachedManager.myInjectorsClone.putAll(cachedManager.getInjectorMap().getBackingMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkInjectorsAreDisposed(@Nullable Project project) {
        InjectedLanguageManagerImpl cachedManager;
        InjectedLanguageManagerImpl injectedLanguageManagerImpl = cachedManager = project == null ? null : (InjectedLanguageManagerImpl)((Object)project.getUserData((Key)INSTANCE_CACHE));
        if (cachedManager == null) {
            return;
        }
        try {
            ClassMapCachingNulls<MultiHostInjector> cached = cachedManager.cachedInjectors;
            if (cached == null) {
                return;
            }
            for (Map.Entry<Class, MultiHostInjector[]> entry : cached.getBackingMap().entrySet()) {
                Class key = entry.getKey();
                if (cachedManager.myInjectorsClone.isEmpty()) {
                    return;
                }
                Object[] oldInjectors = cachedManager.myInjectorsClone.get(key);
                for (MultiHostInjector injector : entry.getValue()) {
                    if (ArrayUtil.indexOf((Object[])oldInjectors, (Object)injector) == -1) {
                        throw new AssertionError((Object)("Injector was not disposed: " + key + " -> " + injector));
                    }
                }
            }
        }
        finally {
            cachedManager.myInjectorsClone.clear();
        }
    }

    InjectionResult processInPlaceInjectorsFor(@NotNull PsiFile hostPsiFile, @NotNull PsiElement element) {
        MultiHostInjector[] infos = this.getInjectorMap().get(element.getClass());
        if (infos == null || infos.length == 0) {
            return null;
        }
        boolean dumb = this.myDumbService.isDumb();
        InjectionRegistrarImpl hostRegistrar = new InjectionRegistrarImpl(this.myProject, hostPsiFile, element, this.myDocManager);
        for (MultiHostInjector injector : infos) {
            if (dumb && !DumbService.isDumbAware((Object)injector)) continue;
            injector.getLanguagesToInject((MultiHostRegistrar)hostRegistrar, element);
            InjectionResult result2 = hostRegistrar.getInjectedResult();
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public List<Pair<PsiElement, TextRange>> getInjectedPsiFiles(@NotNull PsiElement host) {
        if (!(host instanceof PsiLanguageInjectionHost) || !((PsiLanguageInjectionHost)host).isValidHost()) {
            return null;
        }
        PsiElement inTree = InjectedLanguageUtil.loadTree(host, host.getContainingFile());
        SmartList result2 = new SmartList();
        this.enumerate(inTree, (arg_0, arg_1) -> InjectedLanguageManagerImpl.lambda$getInjectedPsiFiles$2(inTree, (List)result2, arg_0, arg_1));
        return result2.isEmpty() ? null : result2;
    }

    private static /* synthetic */ void lambda$getInjectedPsiFiles$2(PsiElement inTree, List result2, PsiFile injectedPsi, List places) {
        for (PsiLanguageInjectionHost.Shred place : places) {
            if (place.getHost() != inTree) continue;
            result2.add(new Pair((Object)injectedPsi, (Object)place.getRangeInsideHost()));
        }
    }

    private static class PsiManagerRegisteredInjectorsAdapter
    implements MultiHostInjector {
        public static final PsiManagerRegisteredInjectorsAdapter INSTANCE = new PsiManagerRegisteredInjectorsAdapter();

        private PsiManagerRegisteredInjectorsAdapter() {
        }

        public void getLanguagesToInject(@NotNull MultiHostRegistrar injectionPlacesRegistrar, @NotNull PsiElement context) {
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
            InjectedLanguagePlaces placesRegistrar = (language, rangeInsideHost, prefix, suffix) -> injectionPlacesRegistrar.startInjecting(language).addPlace(prefix, suffix, host, rangeInsideHost).doneInjecting();
            for (LanguageInjector injector : LanguageInjector.EXTENSION_POINT_NAME.getExtensionList()) {
                injector.getLanguagesToInject(host, placesRegistrar);
            }
        }

        @NotNull
        public List<Class<? extends PsiElement>> elementsToInjectIn() {
            return Collections.singletonList(PsiLanguageInjectionHost.class);
        }
    }

    @FunctionalInterface
    static interface InjProcessor {
        public boolean process(@NotNull PsiElement var1, @NotNull MultiHostInjector var2);
    }
}

