/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;

class InjectedPsiCachedValueProvider
implements ParameterizedCachedValueProvider<InjectionResult, PsiElement> {
    InjectedPsiCachedValueProvider() {
    }

    public CachedValueProvider.Result<InjectionResult> compute(PsiElement element) {
        PsiFile hostPsiFile = element.getContainingFile();
        if (hostPsiFile == null) {
            return null;
        }
        FileViewProvider viewProvider = hostPsiFile.getViewProvider();
        if (viewProvider instanceof InjectedFileViewProvider) {
            return null;
        }
        DocumentEx hostDocument = (DocumentEx)viewProvider.getDocument();
        if (hostDocument == null) {
            return null;
        }
        PsiManager psiManager = viewProvider.getManager();
        Project project = psiManager.getProject();
        InjectedLanguageManagerImpl injectedManager = InjectedLanguageManagerImpl.getInstanceImpl(project);
        InjectionResult result2 = injectedManager.processInPlaceInjectorsFor(hostPsiFile, element);
        return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, hostDocument});
    }
}

