/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

class RangeMarkerWindow
implements RangeMarkerEx {
    private final DocumentWindow myDocumentWindow;
    private final RangeMarkerEx myHostMarker;
    private final int myStartShift;
    private final int myEndShift;

    RangeMarkerWindow(@NotNull DocumentWindow documentWindow, RangeMarkerEx hostMarker, int startShift, int endShift) {
        this.myDocumentWindow = documentWindow;
        this.myHostMarker = hostMarker;
        this.myStartShift = startShift;
        this.myEndShift = endShift;
    }

    @NotNull
    public Document getDocument() {
        return this.myDocumentWindow;
    }

    public int getStartOffset() {
        int hostOffset = this.myHostMarker.getStartOffset();
        return this.myDocumentWindow.hostToInjected(hostOffset) - this.myStartShift;
    }

    public int getEndOffset() {
        int hostOffset = this.myHostMarker.getEndOffset();
        return this.myDocumentWindow.hostToInjected(hostOffset) + this.myStartShift + this.myEndShift;
    }

    public boolean isValid() {
        int endOffset;
        if (!this.myHostMarker.isValid() || !this.myDocumentWindow.isValid()) {
            return false;
        }
        int startOffset = this.getStartOffset();
        return startOffset <= (endOffset = this.getEndOffset()) && endOffset <= this.myDocumentWindow.getTextLength();
    }

    public void setGreedyToLeft(boolean greedy) {
        this.myHostMarker.setGreedyToLeft(greedy);
    }

    public void setGreedyToRight(boolean greedy) {
        this.myHostMarker.setGreedyToRight(greedy);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myHostMarker.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        this.myHostMarker.putUserData(key, value);
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent e) {
        this.myHostMarker.documentChanged(e);
    }

    @Override
    public long getId() {
        return this.myHostMarker.getId();
    }

    public RangeMarkerEx getDelegate() {
        return this.myHostMarker;
    }

    public boolean isGreedyToRight() {
        return this.myHostMarker.isGreedyToRight();
    }

    public boolean isGreedyToLeft() {
        return this.myHostMarker.isGreedyToLeft();
    }

    public void dispose() {
        this.myHostMarker.dispose();
    }

    public String toString() {
        return "RangeMarkerWindow" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + this.getId();
    }
}

