/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShredImpl
implements PsiLanguageInjectionHost.Shred {
    private final SmartPsiFileRange relevantRangeInHost;
    private final SmartPsiElementPointer<PsiLanguageInjectionHost> hostElementPointer;
    private final TextRange rangeInDecodedPSI;
    private final String prefix;
    private final String suffix;
    private final boolean usePsiRange;
    private final boolean isOneLine;

    ShredImpl(@NotNull SmartPsiFileRange relevantRangeInHost, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> hostElementPointer, @NotNull String prefix, @NotNull String suffix, @NotNull TextRange rangeInDecodedPSI, boolean usePsiRange, boolean isOneLine) {
        this.hostElementPointer = hostElementPointer;
        this.relevantRangeInHost = relevantRangeInHost;
        this.prefix = prefix;
        this.suffix = suffix;
        this.rangeInDecodedPSI = rangeInDecodedPSI;
        this.usePsiRange = usePsiRange;
        this.isOneLine = isOneLine;
        this.assertValid();
    }

    private void assertValid() {
        Segment hostRange = this.relevantRangeInHost.getPsiRange();
        assert (hostRange != null) : "invalid host range: " + this.relevantRangeInHost;
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)this.hostElementPointer.getElement();
        assert (host != null && host.isValid()) : "no host: " + this.hostElementPointer;
    }

    @NotNull
    ShredImpl withPsiRange() {
        return new ShredImpl(this.relevantRangeInHost, this.hostElementPointer, this.prefix, this.suffix, this.rangeInDecodedPSI, true, this.isOneLine);
    }

    @NotNull
    ShredImpl withRange(@NotNull TextRange rangeInDecodedPSI, @NotNull TextRange rangeInHostElementPSI, @NotNull PsiLanguageInjectionHost newHost) {
        SmartPsiFileRange rangeMarker = this.relevantRangeInHost;
        TextRange oldRangeInHostElementPSI = this.calcRangeInsideHostElement(false);
        SmartPointerManagerImpl pointerManager = (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)rangeMarker.getProject());
        SmartPsiElementPointer<PsiLanguageInjectionHost> newHostPointer = pointerManager.createSmartPsiElementPointer(newHost, newHost.getContainingFile(), true);
        if (!rangeInHostElementPSI.equals((Object)TextRange.create((Segment)oldRangeInHostElementPSI))) {
            Segment hostElementRange = newHostPointer.getRange();
            rangeMarker = pointerManager.createSmartPsiFileRangePointer(rangeMarker.getContainingFile(), rangeInHostElementPSI.shiftRight(hostElementRange.getStartOffset()), true);
        }
        return new ShredImpl(rangeMarker, newHostPointer, this.prefix, this.suffix, rangeInDecodedPSI, this.usePsiRange, this.isOneLine);
    }

    @NotNull
    SmartPsiElementPointer<PsiLanguageInjectionHost> getSmartPointer() {
        return this.hostElementPointer;
    }

    @Nullable(value="returns null when the host document marker is invalid")
    public Segment getHostRangeMarker() {
        return this.usePsiRange ? this.relevantRangeInHost.getPsiRange() : this.relevantRangeInHost.getRange();
    }

    @NotNull
    public TextRange getRangeInsideHost() {
        return this.calcRangeInsideHostElement(true);
    }

    @NotNull
    private TextRange calcRangeInsideHostElement(boolean usePsiRange) {
        TextRange textRange;
        PsiLanguageInjectionHost host = this.getHost();
        Segment psiRange = usePsiRange ? this.relevantRangeInHost.getPsiRange() : this.relevantRangeInHost.getRange();
        TextRange textRange2 = textRange = psiRange == null ? null : TextRange.create((Segment)psiRange);
        if (host == null) {
            Segment fromSP;
            if (textRange != null) {
                return textRange;
            }
            Segment segment = fromSP = usePsiRange ? this.hostElementPointer.getPsiRange() : this.hostElementPointer.getRange();
            if (fromSP != null) {
                return TextRange.create((Segment)fromSP);
            }
            return new TextRange(0, 0);
        }
        TextRange hostTextRange = host.getTextRange();
        TextRange textRange3 = textRange = textRange == null ? null : textRange.intersection(hostTextRange);
        if (textRange == null) {
            return new ProperTextRange(0, hostTextRange.getLength());
        }
        return textRange.shiftLeft(hostTextRange.getStartOffset());
    }

    public String toString() {
        PsiLanguageInjectionHost host = this.getHost();
        Segment hostRange = this.getHostRangeMarker();
        return "Shred " + (host == null ? null : host.getTextRange()) + ": " + host + " In host range: " + (hostRange != null ? "(" + hostRange.getStartOffset() + "," + hostRange.getEndOffset() + ");" : "invalid;") + " PSI range: " + this.rangeInDecodedPSI;
    }

    public boolean isValid() {
        return this.getHostRangeMarker() != null && this.getHost() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)o;
        PsiLanguageInjectionHost host = this.getHost();
        Segment hostRangeMarker = this.getHostRangeMarker();
        Segment hostRangeMarker2 = shred.getHostRangeMarker();
        return host != null && host.equals(shred.getHost()) && this.prefix.equals(shred.getPrefix()) && this.suffix.equals(shred.getSuffix()) && this.rangeInDecodedPSI.equals((Object)shred.getRange()) && hostRangeMarker != null && hostRangeMarker2 != null && TextRange.areSegmentsEqual((Segment)hostRangeMarker, (Segment)hostRangeMarker2);
    }

    public int hashCode() {
        return this.rangeInDecodedPSI.hashCode();
    }

    public void dispose() {
    }

    @Nullable
    public PsiLanguageInjectionHost getHost() {
        return (PsiLanguageInjectionHost)this.hostElementPointer.getElement();
    }

    @NotNull
    public TextRange getRange() {
        return this.rangeInDecodedPSI;
    }

    @NotNull
    public String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public String getSuffix() {
        return this.suffix;
    }

    boolean isOneLine() {
        return this.isOneLine;
    }
}

