/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected.changesHandler;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.changesHandler.BaseInjectedFileChangesHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CommonInjectedFileChangesHandler
extends BaseInjectedFileChangesHandler {
    private final List<Trinity<RangeMarker, RangeMarker, SmartPsiElementPointer<PsiLanguageInjectionHost>>> myMarkers = ContainerUtil.newLinkedList();

    public CommonInjectedFileChangesHandler(List<? extends PsiLanguageInjectionHost.Shred> shreds, Editor editor, Document newDocument, PsiFile injectedFile) {
        super(editor, newDocument, injectedFile);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        int curOffset = -1;
        for (PsiLanguageInjectionHost.Shred shred : shreds) {
            RangeMarker rangeMarker = this.localRangeMarkerFromShred(shred);
            TextRange rangeInsideHost = shred.getRangeInsideHost();
            PsiLanguageInjectionHost host = shred.getHost();
            RangeMarker origMarker = this.myOrigDocument.createRangeMarker(rangeInsideHost.shiftRight(host.getTextRange().getStartOffset()));
            SmartPsiElementPointer elementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)host);
            Trinity markers = Trinity.create((Object)origMarker, (Object)rangeMarker, (Object)elementPointer);
            this.myMarkers.add((Trinity<RangeMarker, RangeMarker, SmartPsiElementPointer<PsiLanguageInjectionHost>>)markers);
            origMarker.setGreedyToRight(true);
            rangeMarker.setGreedyToRight(true);
            if (origMarker.getStartOffset() > curOffset) {
                origMarker.setGreedyToLeft(true);
                rangeMarker.setGreedyToLeft(true);
            }
            curOffset = origMarker.getEndOffset();
        }
    }

    @NotNull
    protected RangeMarker localRangeMarkerFromShred(PsiLanguageInjectionHost.Shred shred) {
        return this.myNewDocument.createRangeMarker(shred.getRange().getStartOffset() + shred.getPrefix().length(), shred.getRange().getEndOffset() - shred.getSuffix().length());
    }

    public boolean isValid() {
        boolean valid = this.myInjectedFile.isValid();
        if (valid) {
            for (Trinity<RangeMarker, RangeMarker, SmartPsiElementPointer<PsiLanguageInjectionHost>> t : this.myMarkers) {
                if (((RangeMarker)t.first).isValid() && ((RangeMarker)t.second).isValid() && ((SmartPsiElementPointer)t.third).getElement() != null) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    public void commitToOriginal(@NotNull DocumentEvent e) {
        String text = this.myNewDocument.getText();
        Map map2 = ContainerUtil.classify(this.myMarkers.iterator(), o -> (PsiLanguageInjectionHost)((SmartPsiElementPointer)o.third).getElement());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        documentManager.commitDocument(this.myOrigDocument);
        int localInsideFileCursor = 0;
        for (PsiLanguageInjectionHost host : map2.keySet()) {
            if (host == null) continue;
            String hostText = host.getText();
            ProperTextRange insideHost = null;
            StringBuilder sb = new StringBuilder();
            for (Trinity entry : (Set)map2.get(host)) {
                RangeMarker origMarker = (RangeMarker)entry.first;
                int hostOffset = host.getTextRange().getStartOffset();
                ProperTextRange localInsideHost = new ProperTextRange(origMarker.getStartOffset() - hostOffset, origMarker.getEndOffset() - hostOffset);
                RangeMarker rangeMarker = (RangeMarker)entry.second;
                ProperTextRange localInsideFile = new ProperTextRange(Math.max(localInsideFileCursor, rangeMarker.getStartOffset()), rangeMarker.getEndOffset());
                if (insideHost != null) {
                    sb.append(hostText, insideHost.getEndOffset(), localInsideHost.getStartOffset());
                }
                sb.append(localInsideFile.getEndOffset() <= text.length() && !localInsideFile.isEmpty() ? localInsideFile.substring(text) : "");
                localInsideFileCursor = localInsideFile.getEndOffset();
                insideHost = insideHost == null ? localInsideHost : insideHost.union((TextRange)localInsideHost);
            }
            assert (insideHost != null);
            this.updateInjectionHostElement(host, insideHost, sb.toString());
            documentManager.commitDocument(this.myOrigDocument);
        }
    }

    protected void updateInjectionHostElement(PsiLanguageInjectionHost host, ProperTextRange insideHost, String content) {
        ElementManipulators.getManipulator((PsiElement)host).handleContentChange((PsiElement)host, (TextRange)insideHost, content);
    }

    public boolean handlesRange(@NotNull TextRange range2) {
        if (!this.myMarkers.isEmpty()) {
            TextRange hostRange = TextRange.create((int)((RangeMarker)this.myMarkers.get((int)0).first).getStartOffset(), (int)((RangeMarker)this.myMarkers.get((int)(this.myMarkers.size() - 1)).first).getEndOffset());
            return range2.intersects(hostRange);
        }
        return false;
    }

    protected List<Trinity<RangeMarker, RangeMarker, SmartPsiElementPointer<PsiLanguageInjectionHost>>> getMarkers() {
        return this.myMarkers;
    }
}

