/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagNameReference
implements PsiReference {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.TagNameReference");
    protected final boolean myStartTagFlag;
    private final ASTNode myNameElement;

    public TagNameReference(ASTNode nameElement, boolean startTagFlag) {
        this.myStartTagFlag = startTagFlag;
        this.myNameElement = nameElement;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement element = this.myNameElement.getPsi();
        PsiElement parent = element.getParent();
        return parent instanceof XmlTag ? parent : element;
    }

    @Nullable
    protected XmlTag getTagElement() {
        PsiElement element = this.getElement();
        if (element == this.myNameElement.getPsi()) {
            return null;
        }
        return (XmlTag)element;
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode nameElement = this.getNameElement();
        if (nameElement == null) {
            return TextRange.EMPTY_RANGE;
        }
        int colon = this.getPrefixIndex(nameElement.getText()) + 1;
        if (this.myStartTagFlag) {
            int parentOffset = ((TreeElement)nameElement).getStartOffsetInParent();
            return new TextRange(parentOffset + colon, parentOffset + nameElement.getTextLength());
        }
        PsiElement element = this.getElement();
        if (element == this.myNameElement) {
            return new TextRange(colon, this.myNameElement.getTextLength());
        }
        int elementLength = element.getTextLength();
        int diffFromEnd = 0;
        for (ASTNode node = element.getNode().getLastChildNode(); node != nameElement && node != null; node = node.getTreePrev()) {
            diffFromEnd += node.getTextLength();
        }
        int nameEnd = elementLength - diffFromEnd;
        return new TextRange(nameEnd - nameElement.getTextLength() + colon, nameEnd);
    }

    protected int getPrefixIndex(@NotNull String name) {
        return name.indexOf(":");
    }

    public ASTNode getNameElement() {
        return this.myNameElement;
    }

    public PsiElement resolve() {
        XmlElementDescriptor descriptor;
        XmlTag tag = this.getTagElement();
        XmlElementDescriptor xmlElementDescriptor = descriptor = tag != null ? tag.getDescriptor() : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Descriptor for tag " + (tag != null ? tag.getName() : "NULL") + " is " + (descriptor != null ? descriptor.toString() + ": " + descriptor.getClass().getCanonicalName() : "NULL"));
        }
        if (descriptor != null) {
            return descriptor instanceof AnyXmlElementDescriptor ? tag : descriptor.getDeclaration();
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        return this.getNameElement().getText();
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        XmlTag element = this.getTagElement();
        if (element == null || !this.myStartTagFlag) {
            return element;
        }
        if (this.getPrefixIndex(newElementName) == -1) {
            PsiElement psiElement;
            String namespacePrefix = element.getNamespacePrefix();
            int index = newElementName.lastIndexOf(46);
            if (index != -1 && ((psiElement = this.resolve()) instanceof PsiFile || psiElement != null && psiElement.isEquivalentTo((PsiElement)psiElement.getContainingFile()))) {
                newElementName = newElementName.substring(0, index);
            }
            newElementName = this.prependNamespacePrefix(newElementName, namespacePrefix);
        }
        element.setName(newElementName);
        return element;
    }

    protected String prependNamespacePrefix(String newElementName, String namespacePrefix) {
        newElementName = (!namespacePrefix.isEmpty() ? namespacePrefix + ":" : namespacePrefix) + newElementName;
        return newElementName;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiMetaData metaData = null;
        if (element instanceof PsiMetaOwner) {
            PsiMetaOwner owner = (PsiMetaOwner)element;
            metaData = owner.getMetaData();
            if (metaData instanceof XmlElementDescriptor) {
                return this.getTagElement().setName(metaData.getName(this.getElement()));
            }
        } else if (element instanceof PsiFile) {
            XmlTag tagElement = this.getTagElement();
            if (tagElement == null || !this.myStartTagFlag) {
                return tagElement;
            }
            String newElementName = ((PsiFile)element).getName();
            int index = newElementName.lastIndexOf(46);
            newElementName = this.prependNamespacePrefix(newElementName.substring(0, index), tagElement.getNamespacePrefix());
            return this.getTagElement().setName(newElementName);
        }
        XmlTag tag = this.getTagElement();
        throw new IncorrectOperationException("Cant bind to not a xml element definition!" + element + "," + metaData + "," + tag + "," + (tag != null ? tag.getDescriptor() : "unknown descriptor"));
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        return this.getElement().getManager().areElementsEquivalent(element, this.resolve());
    }

    public boolean isSoft() {
        return false;
    }

    @Nullable
    static TagNameReference createTagNameReference(XmlElement element, @NotNull ASTNode nameElement, boolean startTagFlag) {
        XmlExtension extension = XmlExtension.getExtensionByElement((PsiElement)element);
        return extension == null ? null : extension.createTagNameReference(nameElement, startTagFlag);
    }

    public boolean isStartTagFlag() {
        return this.myStartTagFlag;
    }
}

