/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.pom.xml.impl.events.XmlAttributeSetImpl;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.XmlAttributeReference;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeImpl
extends XmlElementImpl
implements XmlAttribute,
HintedReferenceHost {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlAttributeImpl");
    private final int myHC = ourHC++;
    private volatile VolatileState myVolatileState;

    public final int hashCode() {
        return this.myHC;
    }

    public XmlAttributeImpl() {
        super(XmlElementType.XML_ATTRIBUTE);
    }

    protected XmlAttributeImpl(@NotNull IElementType elementType) {
        super(elementType);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child2) {
        LOG.assertTrue(child2.getTreeParent() == this);
        IElementType i = child2.getElementType();
        if (i == XmlTokenType.XML_NAME) {
            return 229;
        }
        if (i == XmlElementType.XML_ATTRIBUTE_VALUE) {
            return 243;
        }
        return 0;
    }

    public XmlAttributeValue getValueElement() {
        return (XmlAttributeValue)XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this);
    }

    public void setValue(@NotNull String valueText) throws IncorrectOperationException {
        final ASTNode value = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this);
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAttribute attribute = this.createAttribute(valueText, StringUtil.defaultIfEmpty((String)this.getName(), (String)"a"));
        final ASTNode newValue = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild((ASTNode)attribute);
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

            public PomModelEvent runInner() {
                XmlAttributeImpl att = XmlAttributeImpl.this;
                if (value != null) {
                    if (newValue != null) {
                        att.replaceChild(value, newValue.copyElement());
                    } else {
                        att.removeChild(value);
                    }
                } else if (newValue != null) {
                    att.addChild(newValue.getTreePrev().copyElement());
                    att.addChild(newValue.copyElement());
                }
                return XmlAttributeSetImpl.createXmlAttributeSet(model, XmlAttributeImpl.this.getParent(), XmlAttributeImpl.this.getName(), newValue != null ? newValue.getText() : null);
            }
        });
    }

    @NotNull
    protected XmlAttribute createAttribute(@NotNull String valueText, String name) {
        return XmlElementFactory.getInstance((Project)this.getProject()).createAttribute(name, valueText, (PsiElement)this);
    }

    public XmlElement getNameElement() {
        return (XmlElement)XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(this);
    }

    @NotNull
    public String getNamespace() {
        String name = this.getName();
        String prefixByQualifiedName = XmlUtil.findPrefixByQualifiedName(name);
        if (prefixByQualifiedName.isEmpty()) {
            return "";
        }
        return this.getParent().getNamespaceByPrefix(prefixByQualifiedName);
    }

    @NonNls
    @NotNull
    public String getNamespacePrefix() {
        return XmlUtil.findPrefixByQualifiedName(this.getName());
    }

    public XmlTag getParent() {
        PsiElement parentTag = super.getParent();
        return parentTag instanceof XmlTag ? (XmlTag)parentTag : null;
    }

    @NotNull
    public String getLocalName() {
        return XmlUtil.findLocalNameByQualifiedName(this.getName());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttribute((XmlAttribute)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getValue() {
        XmlAttributeValue valueElement = this.getValueElement();
        return valueElement != null ? valueElement.getValue() : null;
    }

    protected void appendChildToDisplayValue(@NotNull StringBuilder buffer, @NotNull ASTNode child2) {
        buffer.append(child2.getChars());
    }

    @Nullable
    public String getDisplayValue() {
        VolatileState state = this.getFreshState();
        return state == null ? null : state.myDisplayText;
    }

    public int physicalToDisplay(int physicalIndex) {
        VolatileState state = this.getFreshState();
        if (state == null) {
            return -1;
        }
        if (physicalIndex < 0 || physicalIndex > state.myValueTextRange.getLength()) {
            return -1;
        }
        if (state.myGapPhysicalStarts.length == 0) {
            return physicalIndex;
        }
        int bsResult = Arrays.binarySearch(state.myGapPhysicalStarts, physicalIndex);
        int gapIndex = bsResult > 0 ? bsResult : (bsResult < -1 ? -bsResult - 2 : -1);
        if (gapIndex < 0) {
            return physicalIndex;
        }
        int shift = state.myGapPhysicalStarts[gapIndex] - state.myGapDisplayStarts[gapIndex];
        return Math.max(state.myGapDisplayStarts[gapIndex], physicalIndex - shift);
    }

    public int displayToPhysical(int displayIndex) {
        VolatileState state = this.getFreshState();
        if (state == null) {
            return -1;
        }
        String displayValue = state.myDisplayText;
        if (displayIndex < 0 || displayIndex > displayValue.length()) {
            return -1;
        }
        int[] gapDisplayStarts = state.myGapDisplayStarts;
        if (gapDisplayStarts.length == 0) {
            return displayIndex;
        }
        int bsResult = Arrays.binarySearch(gapDisplayStarts, displayIndex);
        int gapIndex = bsResult > 0 ? bsResult - 1 : (bsResult < -1 ? -bsResult - 2 : -1);
        if (gapIndex < 0) {
            return displayIndex;
        }
        int shift = state.myGapPhysicalStarts[gapIndex] - gapDisplayStarts[gapIndex];
        return displayIndex + shift;
    }

    @NotNull
    public TextRange getValueTextRange() {
        VolatileState state = this.getFreshState();
        return state == null ? TextRange.EMPTY_RANGE : state.myValueTextRange;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myVolatileState = null;
    }

    @Override
    @NotNull
    public String getName() {
        XmlElement element = this.getNameElement();
        return element != null ? element.getText() : "";
    }

    public boolean isNamespaceDeclaration() {
        String name = this.getName();
        return name.startsWith("xmlns:") || name.equals("xmlns");
    }

    @NotNull
    public PsiElement setName(final @NotNull String nameText) throws IncorrectOperationException {
        final ASTNode name = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(this);
        final String oldName = name == null ? "" : name.getText();
        final String oldValue = (String)ObjectUtils.notNull((Object)this.getValue(), (Object)"");
        final PomModel model = PomManager.getModel((Project)this.getProject());
        final XmlAttribute attribute = this.createAttribute(oldValue, nameText);
        final ASTNode newName = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild((ASTNode)attribute);
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        final Ref replaced = Ref.create((Object)this);
        model.runTransaction((PomTransaction)new PomTransactionBase((PsiElement)this.getParent(), (PomModelAspect)aspect){

            public PomModelEvent runInner() {
                PomModelEvent event = new PomModelEvent(model);
                PsiFile file2 = XmlAttributeImpl.this.getContainingFile();
                XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(model, file2 instanceof XmlFile ? (XmlFile)file2 : null);
                xmlAspectChangeSet.add((XmlChange)new XmlAttributeSetImpl(XmlAttributeImpl.this.getParent(), oldName, null));
                xmlAspectChangeSet.add((XmlChange)new XmlAttributeSetImpl(XmlAttributeImpl.this.getParent(), nameText, oldValue));
                event.registerChangeSet(model.getModelAspect(XmlAspect.class), (PomChangeSet)xmlAspectChangeSet);
                if (!oldValue.isEmpty() && XmlAttributeImpl.this.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE)) {
                    CodeEditUtil.replaceChild(XmlAttributeImpl.this.getTreeParent(), XmlAttributeImpl.this, attribute.getNode());
                    replaced.set((Object)attribute);
                } else if (name != null && newName != null) {
                    CodeEditUtil.replaceChild(XmlAttributeImpl.this, name, newName);
                }
                return event;
            }
        });
        return (PsiElement)replaced.get();
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] refs = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (refs.length > 0) {
            return refs[0];
        }
        return null;
    }

    public boolean shouldAskParentForReferences(@NotNull PsiReferenceService.Hints hints) {
        return false;
    }

    @Override
    @Deprecated
    @NotNull
    public final PsiReference[] getReferences() {
        return this.getReferences(PsiReferenceService.Hints.NO_HINTS);
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull PsiReferenceService.Hints hints) {
        PsiReference[] refs;
        XmlElement nameElement;
        if (hints.offsetInElement != null && ((nameElement = this.getNameElement()) == null || hints.offsetInElement > nameElement.getStartOffsetInParent() + nameElement.getTextLength())) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] referencesFromProviders = ReferenceProvidersRegistry.getReferencesFromProviders(this);
        if (this.isNamespaceDeclaration()) {
            refs = new PsiReference[referencesFromProviders.length + 1];
            String localName = this.getLocalName();
            String prefix = XmlUtil.findPrefixByQualifiedName(this.getName());
            TextRange range2 = prefix.isEmpty() ? TextRange.from((int)this.getName().length(), (int)0) : TextRange.from((int)(prefix.length() + 1), (int)localName.length());
            refs[0] = new SchemaPrefixReference(this, range2, localName, null);
        } else {
            String prefix = this.getNamespacePrefix();
            if (!prefix.isEmpty() && !this.getLocalName().isEmpty()) {
                refs = new PsiReference[referencesFromProviders.length + 2];
                refs[0] = new SchemaPrefixReference(this, TextRange.from((int)0, (int)prefix.length()), prefix, null);
                refs[1] = new XmlAttributeReference(this);
            } else {
                refs = new PsiReference[referencesFromProviders.length + 1];
                refs[0] = new XmlAttributeReference(this);
            }
        }
        System.arraycopy(referencesFromProviders, 0, refs, refs.length - referencesFromProviders.length, referencesFromProviders.length);
        return refs;
    }

    @Nullable
    public XmlAttributeDescriptor getDescriptor() {
        return (XmlAttributeDescriptor)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.getDescriptorImpl(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.externalResourceModificationTracker()}));
    }

    @NotNull
    private ModificationTracker externalResourceModificationTracker() {
        Project project = this.getProject();
        ExternalResourceManagerEx manager = ExternalResourceManagerEx.getInstanceEx();
        return () -> manager.getModificationCount(project);
    }

    @Nullable
    private XmlAttributeDescriptor getDescriptorImpl() {
        XmlTag tag = this.getParent();
        if (tag == null) {
            return null;
        }
        XmlElementDescriptor descr = tag.getDescriptor();
        if (descr == null) {
            return null;
        }
        XmlAttributeDescriptor attributeDescr = descr.getAttributeDescriptor((XmlAttribute)this);
        return attributeDescr == null ? descr.getAttributeDescriptor(this.getName(), tag) : attributeDescr;
    }

    @NotNull
    public String getRealLocalName() {
        String name = this.getLocalName();
        return name.endsWith("IntellijIdeaRulezzz") ? name.substring(0, name.length() - "IntellijIdeaRulezzz".length()) : name;
    }

    @Nullable
    private VolatileState getFreshState() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VolatileState state = this.myVolatileState;
        if (state == null) {
            state = this.recalculate();
        }
        return state;
    }

    @Nullable
    private VolatileState recalculate() {
        VolatileState volatileState;
        XmlAttributeValue value = this.getValueElement();
        if (value == null) {
            return null;
        }
        PsiElement firstChild = value.getFirstChild();
        if (firstChild == null) {
            return null;
        }
        ASTNode child2 = firstChild.getNode();
        TextRange valueTextRange = new TextRange(0, value.getTextLength());
        if (child2 != null && child2.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            valueTextRange = new TextRange(child2.getTextLength(), valueTextRange.getEndOffset());
            child2 = child2.getTreeNext();
        }
        TIntArrayList gapsStarts = new TIntArrayList();
        TIntArrayList gapsShifts = new TIntArrayList();
        StringBuilder buffer = new StringBuilder(this.getTextLength());
        while (child2 != null) {
            int start2 = buffer.length();
            IElementType elementType = child2.getElementType();
            if (elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                valueTextRange = new TextRange(valueTextRange.getStartOffset(), child2.getTextRange().getStartOffset() - value.getTextRange().getStartOffset());
                break;
            }
            if (elementType == XmlTokenType.XML_CHAR_ENTITY_REF) {
                buffer.append(XmlUtil.getCharFromEntityRef(child2.getText()));
            } else if (elementType == XmlElementType.XML_ENTITY_REF) {
                buffer.append(XmlAttributeImpl.getEntityValue((XmlEntityRef)child2));
            } else {
                this.appendChildToDisplayValue(buffer, child2);
            }
            int end = buffer.length();
            int originalLength = child2.getTextLength();
            if (end - start2 != originalLength) {
                gapsStarts.add(start2);
                gapsShifts.add(originalLength - (end - start2));
            }
            child2 = child2.getTreeNext();
        }
        int[] gapDisplayStarts = ArrayUtil.newIntArray((int)gapsShifts.size());
        int[] gapPhysicalStarts = ArrayUtil.newIntArray((int)gapsShifts.size());
        int currentGapsSum = 0;
        for (int i = 0; i < gapDisplayStarts.length; ++i) {
            gapDisplayStarts[i] = gapsStarts.get(i);
            gapPhysicalStarts[i] = gapDisplayStarts[i] + (currentGapsSum += gapsShifts.get(i));
        }
        this.myVolatileState = volatileState = new VolatileState(buffer.toString(), gapDisplayStarts, gapPhysicalStarts, valueTextRange);
        return volatileState;
    }

    @NotNull
    private static String getEntityValue(@NotNull XmlEntityRef entityRef) {
        XmlAttributeValue valueElement;
        XmlEntityDecl decl = entityRef.resolve(entityRef.getContainingFile());
        if (decl != null && (valueElement = decl.getValueElement()) != null) {
            return valueElement.getValue();
        }
        return entityRef.getText();
    }

    private static class VolatileState {
        @NotNull
        private final String myDisplayText;
        @NotNull
        private final int[] myGapDisplayStarts;
        @NotNull
        private final int[] myGapPhysicalStarts;
        @NotNull
        private final TextRange myValueTextRange;

        private VolatileState(@NotNull String displayText, @NotNull int[] gapDisplayStarts, @NotNull int[] gapPhysicalStarts, @NotNull TextRange valueTextRange) {
            this.myDisplayText = displayText;
            this.myGapDisplayStarts = gapDisplayStarts;
            this.myGapPhysicalStarts = gapPhysicalStarts;
            this.myValueTextRange = valueTextRange;
        }
    }
}

