/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.util.XmlPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlElementImpl
extends CompositePsiElement
implements XmlElement {
    public XmlElementImpl(IElementType type) {
        super(type);
    }

    public boolean processElements(PsiElementProcessor processor2, PsiElement place) {
        return XmlPsiUtil.processXmlElements(this, processor2, false);
    }

    public boolean processChildren(PsiElementProcessor processor2) {
        return XmlPsiUtil.processXmlElementChildren(this, processor2, false);
    }

    public XmlElement findElementByTokenType(final IElementType type) {
        final XmlElement[] result2 = new XmlElement[]{null};
        this.processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element instanceof TreeElement && ((ASTNode)element).getElementType() == type) {
                    result2[0] = (XmlElement)element;
                    return false;
                }
                return true;
            }
        }, this);
        return result2[0];
    }

    @Override
    public PsiElement getContext() {
        XmlElement data = (XmlElement)this.getUserData(INCLUDING_ELEMENT);
        if (data != null) {
            return data;
        }
        return this.getAstParent();
    }

    private PsiElement getAstParent() {
        return super.getParent();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        if (!this.isPhysical()) {
            XmlElement including = (XmlElement)this.getUserData(INCLUDING_ELEMENT);
            if (including != null) {
                return including;
            }
            PsiElement astParent = this.getAstParent();
            PsiElement parentNavigation = astParent.getNavigationElement();
            if (parentNavigation.getTextOffset() == this.getTextOffset()) {
                return parentNavigation;
            }
            return this;
        }
        return super.getNavigationElement();
    }

    @Override
    public PsiElement getParent() {
        return this.getContext();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return this.getContainingFile().getLanguage();
    }

    @Nullable
    protected static String getNameFromEntityRef(CompositeElement compositeElement, IElementType xmlEntityDeclStart) {
        ASTNode node = compositeElement.findChildByType(xmlEntityDeclStart);
        if (node == null) {
            return null;
        }
        ASTNode name = node.getTreeNext();
        if (name != null && name.getElementType() == TokenType.WHITE_SPACE) {
            name = name.getTreeNext();
        }
        if (name != null && name.getElementType() == XmlElementType.XML_ENTITY_REF) {
            final StringBuilder builder2 = new StringBuilder();
            ((XmlElement)name.getPsi()).processElements(new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    builder2.append(element.getText());
                    return true;
                }
            }, name.getPsi());
            if (builder2.length() > 0) {
                return builder2.toString();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        return GlobalSearchScope.allScope((Project)this.getProject());
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        if (super.isEquivalentTo(another)) {
            return true;
        }
        XmlElementImpl element1 = this;
        if (element1 instanceof XmlTag && another instanceof XmlTag && !element1.isPhysical() && !another.isPhysical()) {
            return element1.getText().equals(another.getText());
        }
        return false;
    }

    public boolean skipValidation() {
        PsiFile containingFile;
        Boolean doNotValidate = (Boolean)DO_NOT_VALIDATE.get((UserDataHolder)this);
        if (doNotValidate != null) {
            return doNotValidate;
        }
        OuterLanguageElement element = (OuterLanguageElement)PsiTreeUtil.getChildOfType((PsiElement)this, OuterLanguageElement.class);
        if (element == null) {
            for (PsiElement child2 = this.getFirstChild(); !(child2 == null || child2 instanceof XmlText && (element = (OuterLanguageElement)PsiTreeUtil.getChildOfType((PsiElement)child2, OuterLanguageElement.class)) != null); child2 = child2.getNextSibling()) {
            }
        }
        doNotValidate = element == null ? Boolean.valueOf(false) : Boolean.valueOf((containingFile = this.getContainingFile()).getViewProvider().getBaseLanguage() != containingFile.getLanguage());
        this.putUserData(DO_NOT_VALIDATE, doNotValidate);
        return doNotValidate;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.putUserData(DO_NOT_VALIDATE, null);
    }
}

