/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.impl.source.xml.behavior.DefaultXmlPsiPolicy;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class XmlTagValueImpl
implements XmlTagValue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlTagValueImpl");
    private final XmlTag myTag;
    private final XmlTagChild[] myElements;
    private volatile XmlText[] myTextElements;
    private volatile String myText;
    private volatile String myTrimmedText;

    public XmlTagValueImpl(@NotNull XmlTagChild[] bodyElements, @NotNull XmlTag tag) {
        this.myTag = tag;
        this.myElements = bodyElements;
    }

    @NotNull
    public XmlTagChild[] getChildren() {
        return this.myElements;
    }

    @NotNull
    public XmlText[] getTextElements() {
        XmlText[] textElements = this.myTextElements;
        if (textElements == null) {
            textElements = (XmlText[])Arrays.stream(this.myElements).filter(element -> element instanceof XmlText).map(element -> (XmlText)element).toArray(XmlText[]::new);
            textElements = textElements.length == 0 ? XmlText.EMPTY_ARRAY : textElements;
            this.myTextElements = textElements;
        }
        return textElements;
    }

    @NotNull
    public String getText() {
        String text = this.myText;
        if (text == null) {
            StringBuilder consolidatedText = new StringBuilder();
            for (XmlTagChild element : this.myElements) {
                consolidatedText.append(element.getText());
            }
            this.myText = text = consolidatedText.toString();
        }
        return text;
    }

    @NotNull
    public TextRange getTextRange() {
        if (this.myElements.length == 0) {
            ASTNode child2 = XmlChildRole.START_TAG_END_FINDER.findChild((ASTNode)this.myTag);
            if (child2 != null) {
                return new TextRange(child2.getStartOffset() + 1, child2.getStartOffset() + 1);
            }
            return new TextRange(this.myTag.getTextRange().getEndOffset(), this.myTag.getTextRange().getEndOffset());
        }
        return new TextRange(this.myElements[0].getTextRange().getStartOffset(), this.myElements[this.myElements.length - 1].getTextRange().getEndOffset());
    }

    @NotNull
    public String getTrimmedText() {
        String trimmedText = this.myTrimmedText;
        if (trimmedText == null) {
            XmlText[] textElements;
            StringBuilder consolidatedText = new StringBuilder();
            for (XmlText textElement : textElements = this.getTextElements()) {
                consolidatedText.append(textElement.getValue());
            }
            this.myTrimmedText = trimmedText = consolidatedText.toString().trim();
        }
        return trimmedText;
    }

    public void setText(String value) {
        this.setText(value, false);
    }

    public void setEscapedText(String value) {
        this.setText(value, true);
    }

    private void setText(String value, boolean defaultPolicy) {
        try {
            XmlText text = null;
            if (value != null) {
                XmlText[] texts = this.getTextElements();
                text = texts.length == 0 ? (XmlText)this.myTag.add((PsiElement)XmlElementFactory.getInstance((Project)this.myTag.getProject()).createDisplayText("x")) : texts[0];
                if (StringUtil.isEmpty((String)value)) {
                    text.delete();
                } else if (defaultPolicy && text instanceof XmlTextImpl) {
                    ((XmlTextImpl)text).doSetValue(value, new DefaultXmlPsiPolicy());
                } else {
                    text.setValue(value);
                }
            }
            if (this.myElements.length > 0) {
                for (XmlTagChild child2 : this.myElements) {
                    if (child2 == text) continue;
                    child2.delete();
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean hasCDATA() {
        for (XmlText xmlText : this.getTextElements()) {
            PsiElement[] children2;
            for (PsiElement child2 : children2 = xmlText.getChildren()) {
                if (child2.getNode().getElementType() != XmlElementType.XML_CDATA) continue;
                return true;
            }
        }
        return false;
    }

    public static XmlTagValue createXmlTagValue(XmlTag tag) {
        final ArrayList bodyElements = new ArrayList();
        tag.processElements(new PsiElementProcessor(){
            boolean insideBody;

            public boolean execute(@NotNull PsiElement element) {
                ASTNode treeElement = element.getNode();
                if (this.insideBody) {
                    if (treeElement != null && treeElement.getElementType() == XmlTokenType.XML_END_TAG_START) {
                        return false;
                    }
                    if (!(element instanceof XmlTagChild)) {
                        return true;
                    }
                    bodyElements.add((XmlTagChild)element);
                } else if (treeElement != null && treeElement.getElementType() == XmlTokenType.XML_TAG_END) {
                    this.insideBody = true;
                }
                return true;
            }
        }, (PsiElement)tag);
        XmlTagChild[] tagChildren = bodyElements.toArray(XmlTagChild.EMPTY_ARRAY);
        return new XmlTagValueImpl(tagChildren, tag);
    }
}

