/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.xml.IDTDElementType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class XmlTokenImpl
extends LeafPsiElement
implements XmlToken,
Navigatable {
    public XmlTokenImpl(@NotNull IElementType type, CharSequence text) {
        super(type, text);
    }

    public boolean processElements(PsiElementProcessor processor2, PsiElement place) {
        return false;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlToken((XmlToken)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        if (this.getTokenType() instanceof IDTDElementType) {
            return "DTDToken:" + this.getTokenType().toString();
        }
        return "XmlToken:" + this.getTokenType().toString();
    }

    public IElementType getTokenType() {
        return this.getElementType();
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiElement element;
        IElementType elementType = this.getElementType();
        if (elementType == XmlTokenType.XML_DATA_CHARACTERS || elementType == XmlTokenType.XML_CHAR_ENTITY_REF) {
            return ReferenceProvidersRegistry.getReferencesFromProviders(this);
        }
        if (elementType == XmlTokenType.XML_NAME && this.getParent() instanceof PsiErrorElement && (element = this.getPrevSibling()) instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_END_TAG_START) {
            return new PsiReference[]{TagNameReference.createTagNameReference((XmlElement)this, this.getNode(), false)};
        }
        return super.getReferences();
    }

    @Override
    public PsiElement getNavigationElement() {
        if (this.getTokenType() == XmlTokenType.XML_COMMENT_CHARACTERS) {
            PsiElement parent = this.getParent();
            return parent != null ? parent : this;
        }
        return super.getNavigationElement();
    }

    @Override
    public boolean canNavigate() {
        return this.getTokenType() == XmlTokenType.XML_NAME && PsiNavigationSupport.getInstance().canNavigate((PsiElement)this) || this.getTokenType() == XmlTokenType.XML_COMMENT_CHARACTERS;
    }
}

