/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.FileNameIndexService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilenameIndex {
    @Deprecated
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"FilenameIndex");

    @NotNull
    public static String[] getAllFilenames(@Nullable Project project) {
        THashSet names = new THashSet();
        FilenameIndex.getService().processAllFileNames((Processor<String>)((Processor)arg_0 -> FilenameIndex.lambda$getAllFilenames$0((Set)names, arg_0)), (GlobalSearchScope)(project == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project)), null);
        return ArrayUtil.toStringArray((Collection)names);
    }

    public static void processAllFileNames(@NotNull Processor<String> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        FilenameIndex.getService().processAllFileNames(processor2, scope, filter);
    }

    @NotNull
    public static Collection<VirtualFile> getVirtualFilesByName(Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        return FilenameIndex.getService().getVirtualFilesByName(project, name, scope, null);
    }

    @NotNull
    public static Collection<VirtualFile> getVirtualFilesByName(Project project, @NotNull String name, boolean caseSensitively, @NotNull GlobalSearchScope scope) {
        if (caseSensitively) {
            return FilenameIndex.getVirtualFilesByName(project, name, scope);
        }
        return FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, project, null);
    }

    @NotNull
    public static PsiFile[] getFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        return (PsiFile[])FilenameIndex.getFilesByName(project, name, scope, false);
    }

    public static boolean processFilesByName(@NotNull String name, boolean directories, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        return FilenameIndex.processFilesByName(name, directories, true, processor2, scope, project, idFilter);
    }

    public static boolean processFilesByName(@NotNull String name, boolean directories, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        Collection<VirtualFile> files2 = caseSensitively ? FilenameIndex.getService().getVirtualFilesByName(project, name, scope, idFilter) : FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, project, idFilter);
        if (files2.isEmpty()) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        int processedFiles = 0;
        for (VirtualFile file2 : files2) {
            PsiDirectory dir;
            if (!file2.isValid()) continue;
            if (!directories && !file2.isDirectory()) {
                PsiFile psiFile = psiManager.findFile(file2);
                if (psiFile == null) continue;
                if (!processor2.process((Object)psiFile)) {
                    return true;
                }
                ++processedFiles;
                continue;
            }
            if (!directories || !file2.isDirectory() || (dir = psiManager.findDirectory(file2)) == null) continue;
            if (!processor2.process((Object)dir)) {
                return true;
            }
            ++processedFiles;
        }
        return processedFiles > 0;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNameIgnoringCase(@NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        THashSet keys = new THashSet();
        FileNameIndexService fileNameIndexService = FilenameIndex.getService();
        fileNameIndexService.processAllFileNames((Processor<String>)((Processor)arg_0 -> FilenameIndex.lambda$getVirtualFilesByNameIgnoringCase$1(name, (Set)keys, arg_0)), scope, idFilter);
        THashSet files2 = new THashSet();
        for (String each : keys) {
            files2.addAll(fileNameIndexService.getVirtualFilesByName(project, each, scope, idFilter));
        }
        return files2;
    }

    @NotNull
    public static PsiFileSystemItem[] getFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope, boolean directories) {
        SmartList result2 = new SmartList();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)result2);
        FilenameIndex.processFilesByName(name, directories, (Processor<? super PsiFileSystemItem>)processor2, scope, project, null);
        if (directories) {
            return (PsiFileSystemItem[])result2.toArray((Object[])new PsiFileSystemItem[0]);
        }
        return (PsiFileSystemItem[])result2.toArray((Object[])PsiFile.EMPTY_ARRAY);
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext) {
        return FilenameIndex.getAllFilesByExt(project, ext, GlobalSearchScope.allScope((Project)project));
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        int len = ext.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        ext = "." + ext;
        ++len;
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (String name : FilenameIndex.getAllFilenames(project)) {
            int length = name.length();
            if (length <= len || !name.substring(length - len).equalsIgnoreCase(ext)) continue;
            files2.addAll(FilenameIndex.getVirtualFilesByName(project, name, searchScope));
        }
        return files2;
    }

    static FileNameIndexService getService() {
        return (FileNameIndexService)ServiceManager.getService(FileNameIndexService.class);
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByNameIgnoringCase$1(String name, Set keys, String value) {
        if (name.equalsIgnoreCase(value)) {
            keys.add(value);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getAllFilenames$0(Set names, String s) {
        names.add(s);
        return true;
    }
}

