/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.core.CoreProjectScopeBuilder;
import com.intellij.ide.scratch.RootType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScopeEnlarger;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ProjectScopeBuilderImpl
extends ProjectScopeBuilder {
    protected final Project myProject;

    public ProjectScopeBuilderImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public GlobalSearchScope buildEverythingScope() {
        return new EverythingGlobalScope(this.myProject){

            public boolean contains(@NotNull VirtualFile file2) {
                RootType rootType = RootType.forFile((VirtualFile)file2);
                return rootType == null || !rootType.isHidden() && !rootType.isIgnored(ProjectScopeBuilderImpl.this.myProject, file2);
            }
        };
    }

    @NotNull
    public GlobalSearchScope buildLibrariesScope() {
        ProjectAndLibrariesScope result2 = new ProjectAndLibrariesScope(this.myProject){

            public boolean contains(@NotNull VirtualFile file2) {
                return this.myProjectFileIndex.isInLibrary(file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                return false;
            }

            @NotNull
            public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
                return Collections.emptySet();
            }
        };
        result2.setDisplayName(PsiBundle.message((String)"psi.search.scope.libraries", (Object[])new Object[0]));
        return result2;
    }

    @NotNull
    public GlobalSearchScope buildAllScope() {
        SearchScopeEnlarger each;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        if (projectRootManager == null) {
            return new EverythingGlobalScope(this.myProject);
        }
        boolean searchOutsideRootModel = false;
        Iterator iterator = SearchScopeEnlarger.EXTENSION.getExtensionList().iterator();
        while (iterator.hasNext() && !(searchOutsideRootModel = (each = (SearchScopeEnlarger)iterator.next()).allScopeSearchesOutsideRootModel(this.myProject))) {
        }
        return new ProjectAndLibrariesScope(this.myProject, searchOutsideRootModel){

            public boolean contains(@NotNull VirtualFile file2) {
                DirectoryInfo info = ((ProjectFileIndexImpl)this.myProjectFileIndex).getInfoForFileOrDirectory(file2);
                return info.isInProject(file2) && (info.getModule() != null || info.hasLibraryClassRoot() || info.isInLibrarySource(file2));
            }
        };
    }

    @NotNull
    public GlobalSearchScope buildProjectScope() {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        if (projectRootManager == null) {
            return new EverythingGlobalScope(this.myProject){

                public boolean isSearchInLibraries() {
                    return false;
                }
            };
        }
        return new ProjectScopeImpl(this.myProject, FileIndexFacade.getInstance((Project)this.myProject));
    }

    @NotNull
    public GlobalSearchScope buildContentScope() {
        return new CoreProjectScopeBuilder.ContentSearchScope(this.myProject, FileIndexFacade.getInstance((Project)this.myProject));
    }
}

