/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.TokenType;
import com.intellij.psi.search.scope.packageSet.ComplementPackageSet;
import com.intellij.psi.search.scope.packageSet.IntersectionPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedPackageSetReference;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.PackageSetParserExtension;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.psi.search.scope.packageSet.UnionPackageSet;
import com.intellij.psi.search.scope.packageSet.lexer.ScopeTokenTypes;
import com.intellij.psi.search.scope.packageSet.lexer.ScopesLexer;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageSetFactoryImpl
extends PackageSetFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.search.scope.packageSet.PackageSetFactoryImpl");

    public PackageSet compile(String text) throws ParsingException {
        ScopesLexer lexer = new ScopesLexer();
        lexer.start(text);
        return new Parser((Lexer)lexer).parse();
    }

    private static class Parser {
        private final Lexer myLexer;

        Parser(Lexer lexer) {
            this.myLexer = lexer;
        }

        public PackageSet parse() throws ParsingException {
            PackageSet set2 = this.parseUnion();
            if (this.myLexer.getTokenType() != null) {
                this.error(AnalysisScopeBundle.message((String)"error.package.set.token.expectations", (Object[])new Object[]{this.getTokenText()}));
            }
            return set2;
        }

        private PackageSet parseUnion() throws ParsingException {
            ArrayList<PackageSet> sets = new ArrayList<PackageSet>();
            PackageSet set2 = this.parseIntersection();
            sets.add(set2);
            while (this.myLexer.getTokenType() == ScopeTokenTypes.OROR) {
                this.myLexer.advance();
                sets.add(this.parseIntersection());
            }
            return UnionPackageSet.create((PackageSet[])sets.toArray(new PackageSet[0]));
        }

        private PackageSet parseIntersection() throws ParsingException {
            PackageSet set2 = this.parseTerm();
            ArrayList<PackageSet> sets = new ArrayList<PackageSet>();
            sets.add(set2);
            while (this.myLexer.getTokenType() == ScopeTokenTypes.ANDAND) {
                this.myLexer.advance();
                sets.add(this.parseTerm());
            }
            return IntersectionPackageSet.create((PackageSet[])sets.toArray(new PackageSet[0]));
        }

        private PackageSet parseTerm() throws ParsingException {
            if (this.myLexer.getTokenType() == ScopeTokenTypes.EXCL) {
                this.myLexer.advance();
                return new ComplementPackageSet(this.parseTerm());
            }
            if (this.myLexer.getTokenType() == ScopeTokenTypes.LPARENTH) {
                return this.parseParenthesized();
            }
            if (this.myLexer.getTokenType() == ScopeTokenTypes.IDENTIFIER && this.myLexer.getBufferSequence().charAt(this.myLexer.getTokenStart()) == '$') {
                NamedPackageSetReference namedPackageSetReference = new NamedPackageSetReference(this.getTokenText());
                this.myLexer.advance();
                return namedPackageSetReference;
            }
            return this.parsePattern();
        }

        private PackageSet parsePattern() throws ParsingException {
            PackageSetParserExtension extension;
            String scope = null;
            Iterator iterator = PackageSetParserExtension.EP_NAME.getExtensionList().iterator();
            while (iterator.hasNext() && (scope = (extension = (PackageSetParserExtension)iterator.next()).parseScope(this.myLexer)) == null) {
            }
            if (scope == null) {
                this.error("Unknown scope type");
            }
            String modulePattern = this.parseModulePattern();
            if (this.myLexer.getTokenType() == ScopeTokenTypes.COLON) {
                this.myLexer.advance();
            }
            for (PackageSetParserExtension extension2 : PackageSetParserExtension.EP_NAME.getExtensionList()) {
                PackageSet packageSet = extension2.parsePackageSet(this.myLexer, scope, modulePattern);
                if (packageSet == null) continue;
                return packageSet;
            }
            this.error("Unknown scope type");
            return null;
        }

        private String getTokenText() {
            int start2 = this.myLexer.getTokenStart();
            int end = this.myLexer.getTokenEnd();
            return this.myLexer.getBufferSequence().subSequence(start2, end).toString();
        }

        @Nullable
        private String parseModulePattern() throws ParsingException {
            if (this.myLexer.getTokenType() != ScopeTokenTypes.LBRACKET) {
                return null;
            }
            this.myLexer.advance();
            StringBuilder pattern = new StringBuilder();
            while (true) {
                if (this.myLexer.getTokenType() == ScopeTokenTypes.RBRACKET || this.myLexer.getTokenType() == null) break;
                if (this.myLexer.getTokenType() == ScopeTokenTypes.ASTERISK) {
                    pattern.append("*");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.IDENTIFIER || this.myLexer.getTokenType() == TokenType.WHITE_SPACE || this.myLexer.getTokenType() == ScopeTokenTypes.INTEGER_LITERAL) {
                    pattern.append(this.getTokenText());
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.DOT) {
                    pattern.append(".");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.MINUS) {
                    pattern.append("-");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.TILDE) {
                    pattern.append("~");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.SHARP) {
                    pattern.append("#");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.COLON) {
                    pattern.append(":");
                } else {
                    pattern.append(this.getTokenText());
                }
                this.myLexer.advance();
            }
            this.myLexer.advance();
            if (pattern.length() == 0) {
                this.error(AnalysisScopeBundle.message((String)"error.package.set.pattern.expectations", (Object[])new Object[0]));
            }
            return pattern.toString();
        }

        private PackageSet parseParenthesized() throws ParsingException {
            LOG.assertTrue(this.myLexer.getTokenType() == ScopeTokenTypes.LPARENTH);
            this.myLexer.advance();
            PackageSet result2 = this.parseUnion();
            if (this.myLexer.getTokenType() != ScopeTokenTypes.RPARENTH) {
                this.error(AnalysisScopeBundle.message((String)"error.package.set.rparen.expected", (Object[])new Object[0]));
            }
            this.myLexer.advance();
            return result2;
        }

        private void error(@NotNull String message) throws ParsingException {
            throw new ParsingException(AnalysisScopeBundle.message((String)"error.package.set.position.parsing.error", (Object[])new Object[]{message, this.myLexer.getTokenStart() + 1}));
        }
    }
}

