/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.LazyStubData;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubSerializationHelper;
import com.intellij.psi.tree.IElementType;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LazyStubList
extends StubList {
    private final AtomicReferenceArray<StubBase<?>> myStubs;
    private final ObjectStubSerializer myRootSerializer;
    private int mySize;
    private final AtomicInteger myInstantiated = new AtomicInteger(1);
    private volatile LazyStubData myData;

    LazyStubList(int size, StubBase<?> root, ObjectStubSerializer rootSerializer) {
        super(size);
        this.myStubs = new AtomicReferenceArray(size);
        this.myRootSerializer = rootSerializer;
        this.myStubs.set(0, root);
        root.myStubList = this;
    }

    void addStub(@NotNull StubBase<?> stub, @Nullable StubBase<?> parent, @Nullable IStubElementType<?, ?> type) {
    }

    void addLazyStub(IElementType type, int childIndex, int parentIndex) {
        this.addStub(childIndex, parentIndex, type.getIndex());
        ++this.mySize;
    }

    boolean areChildrenNonAdjacent(int childId, int parentId) {
        return false;
    }

    public int size() {
        return this.mySize;
    }

    public StubBase<?> get(int index) {
        StubBase<?> stub = this.getCachedStub(index);
        if (stub != null) {
            return stub;
        }
        StubBase<?> newStub = this.instantiateStub(index);
        if (this.myStubs.compareAndSet(index, null, newStub)) {
            if (this.myInstantiated.incrementAndGet() == this.myStubs.length()) {
                this.myData = null;
            }
        } else {
            newStub = this.getCachedStub(index);
        }
        return newStub;
    }

    @Nullable
    StubBase<?> getCachedStub(int index) {
        return this.myStubs.get(index);
    }

    @NotNull
    private StubBase<?> instantiateStub(int index) {
        LazyStubData data = this.myData;
        if (data == null) {
            StubBase<?> stub = this.getCachedStub(index);
            if (stub != null) {
                return stub;
            }
            throw new IllegalStateException("Not all (" + this.mySize + ") stubs are instantiated (" + this.myInstantiated + "), but data for them is missing");
        }
        try {
            StubBase<?> parent = this.get(data.getParentIndex(index));
            StubBase<?> stub = data.deserializeStub(index, parent, this.getStubType(index));
            stub.id = index;
            return stub;
        }
        catch (Error | Exception e) {
            throw new RuntimeException(StubSerializationHelper.brokenStubFormat(this.myRootSerializer), e);
        }
    }

    void setStubData(LazyStubData data) {
        if (this.myInstantiated.get() < this.mySize) {
            this.myData = data;
        }
    }
}

