/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.Key;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectStubTree<T extends Stub> {
    private static final Key<ObjectStubTree> STUB_TO_TREE_REFERENCE = Key.create((String)"stub to tree reference");
    protected final ObjectStubBase myRoot;
    private String myDebugInfo;
    private final List<T> myPlainList;

    public ObjectStubTree(@NotNull ObjectStubBase root, boolean withBackReference) {
        this.myRoot = root;
        this.myPlainList = this.enumerateStubs((Stub)root);
        if (withBackReference) {
            this.myRoot.putUserData(STUB_TO_TREE_REFERENCE, (Object)this);
        }
    }

    @NotNull
    public Stub getRoot() {
        return this.myRoot;
    }

    @NotNull
    public List<T> getPlainList() {
        return this.myPlainList;
    }

    @NotNull
    List<T> getPlainListFromAllRoots() {
        return this.getPlainList();
    }

    @NotNull
    public Map<StubIndexKey, Map<Object, int[]>> indexStubTree() {
        StubIndexSink sink = new StubIndexSink();
        List<T> plainList = this.getPlainListFromAllRoots();
        int plainListSize = plainList.size();
        for (int i = 0; i < plainListSize; ++i) {
            Stub stub = (Stub)plainList.get(i);
            sink.myStubIdx = i;
            StubSerializationUtil.getSerializer((Stub)stub).indexStub(stub, (IndexSink)sink);
        }
        return sink.getResult();
    }

    @NotNull
    protected List<T> enumerateStubs(@NotNull Stub root) {
        ArrayList result2 = new ArrayList();
        ObjectStubTree.enumerateStubsInto(root, result2);
        return result2;
    }

    private static void enumerateStubsInto(@NotNull Stub root, @NotNull List<? super Stub> result2) {
        ((ObjectStubBase)root).id = result2.size();
        result2.add((Stub)root);
        List childrenStubs = root.getChildrenStubs();
        for (int i = 0; i < childrenStubs.size(); ++i) {
            Stub child2 = (Stub)childrenStubs.get(i);
            ObjectStubTree.enumerateStubsInto(child2, result2);
        }
    }

    public void setDebugInfo(@NotNull String info) {
        ObjectStubTree ref = ObjectStubTree.getStubTree(this.myRoot);
        if (ref != null) {
            assert (ref == this);
            info = info + "; with backReference";
        }
        this.myDebugInfo = info;
    }

    @Nullable
    public static ObjectStubTree getStubTree(@NotNull ObjectStubBase root) {
        return (ObjectStubTree)root.getUserData(STUB_TO_TREE_REFERENCE);
    }

    public String getDebugInfo() {
        return this.myDebugInfo;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{myDebugInfo='" + this.myDebugInfo + '\'' + ", myRoot=" + this.myRoot + '}' + this.hashCode();
    }

    private static class StubIndexSink
    implements IndexSink,
    TObjectProcedure<Map<Object, int[]>>,
    TObjectObjectProcedure<Object, int[]> {
        private final THashMap<StubIndexKey, Map<Object, int[]>> myResult = new THashMap();
        private int myStubIdx;
        private Map<Object, int[]> myProcessingMap;

        private StubIndexSink() {
        }

        public void occurrence(@NotNull StubIndexKey indexKey, @NotNull Object value) {
            int[] list2;
            Map map2 = (Map)this.myResult.get((Object)indexKey);
            if (map2 == null) {
                map2 = new THashMap();
                this.myResult.put((Object)indexKey, (Object)map2);
            }
            if ((list2 = (int[])map2.get(value)) == null) {
                map2.put(value, new int[]{this.myStubIdx});
            } else {
                int lastNonZero = ArrayUtil.lastIndexOfNot((int[])list2, (int)0);
                if (lastNonZero >= 0 && list2[lastNonZero] == this.myStubIdx) {
                    return;
                }
                int lastZero = lastNonZero + 1;
                if (lastZero == list2.length) {
                    list2 = ArrayUtil.realloc((int[])list2, (int)Math.max(4, list2.length << 1));
                    map2.put(value, list2);
                }
                list2[lastZero] = this.myStubIdx;
            }
        }

        @NotNull
        public Map<StubIndexKey, Map<Object, int[]>> getResult() {
            this.myResult.forEachValue((TObjectProcedure)this);
            return this.myResult;
        }

        public boolean execute(Map<Object, int[]> object) {
            this.myProcessingMap = object;
            ((THashMap)object).forEachEntry((TObjectObjectProcedure)this);
            return true;
        }

        public boolean execute(Object a, int[] b) {
            if (b.length == 1) {
                return true;
            }
            int firstZero = ArrayUtil.indexOf((int[])b, (int)0);
            if (firstZero != -1) {
                int[] shorterList = ArrayUtil.realloc((int[])b, (int)firstZero);
                this.myProcessingMap.put(a, shorterList);
            }
            return true;
        }
    }
}

