/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexState;
import com.intellij.psi.stubs.StubProcessingHelper;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IdIterator;
import com.intellij.util.indexing.IndexAccessValidator;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileBasedIndex", storages={@Storage(value="$CACHE_FILE$"), @Storage(value="stubIndex.xml", deprecated=true, roamingType=RoamingType.DISABLED)})
public class StubIndexImpl
extends StubIndex
implements PersistentStateComponent<StubIndexState>,
BaseComponent {
    private static final AtomicReference<Boolean> ourForcedClean = new AtomicReference<Object>(null);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubIndexImpl");
    private final StubProcessingHelper myStubProcessingHelper;
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();
    private volatile Future<AsyncState> myStateFuture;
    private volatile AsyncState myState;
    private volatile boolean myInitialized;
    private StubIndexState myPreviouslyRegistered;

    public StubIndexImpl(FileBasedIndex fileBasedIndex) {
        this.myStubProcessingHelper = new StubProcessingHelper(fileBasedIndex);
    }

    @Nullable
    static StubIndexImpl getInstanceOrInvalidate() {
        if (ourForcedClean.compareAndSet(null, Boolean.TRUE)) {
            return null;
        }
        return (StubIndexImpl)StubIndexImpl.getInstance();
    }

    private AsyncState getAsyncState() {
        AsyncState state = this.myState;
        if (state == null) {
            try {
                this.myState = state = this.myStateFuture.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K> boolean registerIndexer(final @NotNull StubIndexExtension<K, ?> extension, boolean forceClean, @NotNull AsyncState state) throws IOException {
        final StubIndexKey indexKey = extension.getKey();
        int version2 = extension.getVersion();
        AsyncState asyncState = state;
        synchronized (asyncState) {
            state.myIndexIdToVersionMap.put((Object)indexKey, version2);
        }
        File indexRootDir = IndexInfrastructure.getIndexRootDir(indexKey);
        boolean needRebuild = false;
        if (forceClean || IndexingStamp.versionDiffers(indexKey, version2)) {
            File versionFile = IndexInfrastructure.getVersionFile(indexKey);
            boolean versionFileExisted = versionFile.exists();
            String[] children2 = indexRootDir.list();
            boolean indexRootHasChildren = children2 != null && children2.length > 0;
            boolean bl = needRebuild = !forceClean && (versionFileExisted || indexRootHasChildren);
            if (needRebuild) {
                LOG.info("Version has changed for stub index " + extension.getKey() + ". The index will be rebuilt.");
            } else {
                LOG.debug("Stub index " + indexKey + " will be built.");
            }
            if (indexRootHasChildren) {
                FileUtil.deleteWithRenaming((File)indexRootDir);
            }
            IndexingStamp.rewriteVersion(indexKey, version2);
        }
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                VfsAwareMapIndexStorage storage2 = new VfsAwareMapIndexStorage(IndexInfrastructure.getStorageFile(indexKey), extension.getKeyDescriptor(), StubIdExternalizer.INSTANCE, extension.getCacheSize(), false, extension instanceof StringStubIndexExtension && ((StringStubIndexExtension)extension).traceKeyHashToVirtualFileMapping());
                MemoryIndexStorage memStorage = new MemoryIndexStorage(storage2, (ID<?, ?>)indexKey);
                MyIndex index = new MyIndex(new IndexExtension<K, StubIdList, Void>(){

                    @NotNull
                    public ID<K, StubIdList> getName() {
                        return indexKey;
                    }

                    @NotNull
                    public DataIndexer<K, StubIdList, Void> getIndexer() {
                        return inputData -> Collections.emptyMap();
                    }

                    @NotNull
                    public KeyDescriptor<K> getKeyDescriptor() {
                        return extension.getKeyDescriptor();
                    }

                    @NotNull
                    public DataExternalizer<StubIdList> getValueExternalizer() {
                        return StubIdExternalizer.INSTANCE;
                    }

                    public int getVersion() {
                        return extension.getVersion();
                    }
                }, memStorage);
                AsyncState asyncState2 = state;
                synchronized (asyncState2) {
                    state.myIndices.put(indexKey, index);
                    break;
                }
            }
            catch (IOException e) {
                needRebuild = true;
                StubIndexImpl.onExceptionInstantiatingIndex(indexKey, version2, indexRootDir, e);
                continue;
            }
            catch (RuntimeException e) {
                Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
                if (cause == null) {
                    throw e;
                }
                StubIndexImpl.onExceptionInstantiatingIndex(indexKey, version2, indexRootDir, e);
            }
        }
        return needRebuild;
    }

    private static <K> void onExceptionInstantiatingIndex(@NotNull StubIndexKey<K, ?> indexKey, int version2, @NotNull File indexRootDir, @NotNull Exception e) throws IOException {
        LOG.info((Throwable)e);
        FileUtil.deleteWithRenaming((File)indexRootDir);
        IndexingStamp.rewriteVersion(indexKey, version2);
    }

    public long getIndexModificationStamp(@NotNull StubIndexKey<?, ?> indexId, @NotNull Project project) {
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(indexId);
        if (index != null) {
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, GlobalSearchScope.allScope((Project)project));
            return index.getModificationStamp();
        }
        return -1L;
    }

    public void flush() throws StorageException {
        if (!this.myInitialized) {
            return;
        }
        for (MyIndex index : this.getAsyncState().myIndices.values()) {
            index.flush();
        }
    }

    <K> void serializeIndexValue(@NotNull DataOutput out, @NotNull StubIndexKey<K, ?> stubIndexKey, @NotNull Map<K, StubIdList> map2) throws IOException {
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(stubIndexKey);
        if (index == null) {
            return;
        }
        KeyDescriptor keyDescriptor = index.getExtension().getKeyDescriptor();
        DataInputOutputUtil.writeINT((DataOutput)out, (int)map2.size());
        for (K key : map2.keySet()) {
            keyDescriptor.save(out, key);
            StubIdExternalizer.INSTANCE.save(out, map2.get(key));
        }
    }

    @NotNull
    <K> Map<K, StubIdList> deserializeIndexValue(@NotNull DataInput in, @NotNull StubIndexKey<K, ?> stubIndexKey) throws IOException {
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(stubIndexKey);
        KeyDescriptor keyDescriptor = index.getExtension().getKeyDescriptor();
        int mapSize = DataInputOutputUtil.readINT((DataInput)in);
        THashMap result2 = new THashMap(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            Object key = keyDescriptor.read(in);
            StubIdList read2 = StubIdExternalizer.INSTANCE.read(in);
            result2.put(key, read2);
        }
        return result2;
    }

    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, final @NotNull Project project, final @Nullable GlobalSearchScope scope, @Nullable IdFilter idFilter, final @NotNull Class<Psi> requiredClass, final @NotNull Processor<? super Psi> processor2) {
        return this.doProcessStubs(indexKey, key, project, scope, new StubIdListContainerAction(idFilter, project){
            final PersistentFS fs;
            {
                super(idFilter, project3);
                this.fs = (PersistentFS)ManagingFS.getInstance();
            }

            @Override
            protected boolean process(int id, @NotNull StubIdList value) {
                VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(this.fs, id);
                if (file2 == null || scope != null && !scope.contains(file2)) {
                    return true;
                }
                return StubIndexImpl.this.myStubProcessingHelper.processStubsInFile(project, file2, value, processor2, scope, requiredClass);
            }
        });
    }

    private <Key> boolean doProcessStubs(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, @NotNull StubIdListContainerAction action) {
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        ID<Integer, SerializedStubTree> stubUpdatingIndexId = StubUpdatingIndex.INDEX_ID;
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(indexKey);
        if (index == null) {
            return true;
        }
        fileBasedIndex.ensureUpToDate(stubUpdatingIndexId, project, scope);
        UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex = fileBasedIndex.getIndex(stubUpdatingIndexId);
        try {
            return (Boolean)this.myAccessValidator.validate(stubUpdatingIndexId, () -> {
                try {
                    Boolean bl = (Boolean)FileBasedIndexImpl.disableUpToDateCheckIn(() -> (Boolean)ConcurrencyUtil.withLock((Lock)stubUpdatingIndex.getReadLock(), () -> index.getData(key).forEach((ValueContainer.ContainerAction)action)));
                    return bl;
                }
                finally {
                    this.wipeProblematicFileIdsForParticularKeyAndStubIndex(indexKey, key, stubUpdatingIndex);
                }
            });
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause != null) {
                this.forceRebuild(cause);
            }
            throw e;
        }
        return true;
    }

    private <Key> void wipeProblematicFileIdsForParticularKeyAndStubIndex(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key key, @NotNull UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex) {
        Set<VirtualFile> filesWithProblems = this.myStubProcessingHelper.takeAccumulatedFilesWithIndexProblems();
        if (filesWithProblems != null) {
            ((FileBasedIndexImpl)FileBasedIndex.getInstance()).runCleanupAction(() -> {
                boolean locked = stubUpdatingIndex.getWriteLock().tryLock();
                if (!locked) {
                    return;
                }
                try {
                    THashMap artificialOldValues = new THashMap();
                    artificialOldValues.put(key, new StubIdList());
                    for (VirtualFile file2 : filesWithProblems) {
                        this.updateIndex(indexKey, FileBasedIndex.getFileId((VirtualFile)file2), (Map)artificialOldValues, Collections.emptyMap());
                    }
                }
                finally {
                    stubUpdatingIndex.getWriteLock().unlock();
                }
            });
        }
    }

    public void forceRebuild(@NotNull Throwable e) {
        FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, e);
    }

    private static void requestRebuild() {
        FileBasedIndex.getInstance().requestRebuild(StubUpdatingIndex.INDEX_ID);
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project) {
        THashSet allKeys = ContainerUtil.newTroveSet();
        this.processAllKeys(indexKey, project, Processors.cancelableCollectProcessor((Collection)allKeys));
        return allKeys;
    }

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Processor<K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(indexKey);
        if (index == null) {
            return true;
        }
        FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, scope.getProject(), scope);
        try {
            return (Boolean)this.myAccessValidator.validate(StubUpdatingIndex.INDEX_ID, () -> (Boolean)FileBasedIndexImpl.disableUpToDateCheckIn(() -> index.processAllKeys(processor2, scope, idFilter)));
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException || cause instanceof StorageException) {
                this.forceRebuild(e);
            }
            throw e;
        }
        return true;
    }

    @NotNull
    public <Key> IdIterator getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        final TIntArrayList result2 = new TIntArrayList();
        this.doProcessStubs(indexKey, dataKey, project, scope, new StubIdListContainerAction(null, project){

            @Override
            protected boolean process(int id, @NotNull StubIdList value) {
                result2.add(id);
                return true;
            }
        });
        return new IdIterator(){
            int cursor;

            public boolean hasNext() {
                return this.cursor < result2.size();
            }

            public int next() {
                return result2.get(this.cursor++);
            }

            public int size() {
                return result2.size();
            }
        };
    }

    public void initComponent() {
        long started = System.nanoTime();
        List<Object> extensions = IndexInfrastructure.hasIndices() ? StubIndexImpl.initExtensions() : Collections.emptyList();
        LOG.info("All stub exts enumerated:" + (System.nanoTime() - started) / 1000000L + ", number of extensions:" + extensions.size());
        started = System.nanoTime();
        this.myStateFuture = IndexInfrastructure.submitGenesisTask(new StubIndexInitialization(extensions));
        LOG.info("stub exts update scheduled:" + (System.nanoTime() - started) / 1000000L);
        if (!IndexInfrastructure.ourDoAsyncIndicesInitialization) {
            try {
                this.myStateFuture.get();
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }

    @NotNull
    static List<StubIndexExtension<?, ?>> initExtensions() {
        List extensions = StubIndexExtension.EP_NAME.getExtensionList();
        for (StubIndexExtension extension : extensions) {
            extension.getKey();
        }
        return extensions;
    }

    public void dispose() {
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            index.dispose();
        }
    }

    void setDataBufferingEnabled(boolean enabled) {
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            IndexStorage indexStorage = ((MapReduceIndex)index).getStorage();
            ((MemoryIndexStorage)indexStorage).setBufferingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupMemoryStorage() {
        UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).getIndex(StubUpdatingIndex.INDEX_ID);
        stubUpdatingIndex.getWriteLock().lock();
        try {
            for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
                IndexStorage indexStorage = ((MapReduceIndex)index).getStorage();
                ((MemoryIndexStorage)indexStorage).clearMemoryMap();
            }
        }
        finally {
            stubUpdatingIndex.getWriteLock().unlock();
        }
    }

    void clearAllIndices() {
        if (!this.myInitialized) {
            return;
        }
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            try {
                index.clear();
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    <K> void removeTransientDataForFile(@NotNull StubIndexKey<K, ?> key, int inputId, @NotNull Collection<? extends K> keys) {
        MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(key);
        index.removeTransientDataForKeys(inputId, keys);
    }

    private boolean dropUnregisteredIndices(@NotNull AsyncState state) {
        if (ApplicationManager.getApplication().isDisposed() || !IndexInfrastructure.hasIndices()) {
            return false;
        }
        HashSet indicesToDrop = new HashSet(this.myPreviouslyRegistered != null ? this.myPreviouslyRegistered.registeredIndices : Collections.emptyList());
        for (ID key : state.myIndices.keySet()) {
            indicesToDrop.remove(key.getName());
        }
        if (!indicesToDrop.isEmpty()) {
            LOG.info("Dropping indices:" + StringUtil.join(indicesToDrop, (String)","));
            for (String s : indicesToDrop) {
                FileUtil.delete((File)IndexInfrastructure.getIndexRootDir(StubIndexKey.createIndexKey((String)s)));
            }
            return true;
        }
        return false;
    }

    public StubIndexState getState() {
        if (!this.myInitialized) {
            return null;
        }
        return new StubIndexState(this.getAsyncState().myIndices.keySet());
    }

    public void loadState(@NotNull StubIndexState state) {
        this.myPreviouslyRegistered = state;
    }

    public <K> void updateIndex(@NotNull StubIndexKey key, int fileId, @NotNull Map<K, StubIdList> oldValues, @NotNull Map<K, StubIdList> newValues) {
        try {
            MyIndex index = (MyIndex)this.getAsyncState().myIndices.get(key);
            if (index == null) {
                return;
            }
            ThrowableComputable oldMapGetter = () -> new MapInputDataDiffBuilder(fileId, oldValues);
            index.updateWithMap(fileId, new UpdateData(newValues, oldMapGetter, (IndexId)key, null));
        }
        catch (StorageException e) {
            LOG.info((Throwable)e);
            StubIndexImpl.requestRebuild();
        }
    }

    private class StubIndexInitialization
    extends IndexInfrastructure.DataInitialization<AsyncState> {
        private final AsyncState state = new AsyncState();
        private final StringBuilder updated = new StringBuilder();
        private final List<? extends StubIndexExtension<?, ?>> myExtensions;

        StubIndexInitialization(List<? extends StubIndexExtension<?, ?>> extensions) {
            this.myExtensions = extensions;
        }

        @Override
        protected void prepare() {
            boolean forceClean = Boolean.TRUE == ourForcedClean.getAndSet(Boolean.FALSE);
            for (StubIndexExtension<?, ?> extension : this.myExtensions) {
                this.addNestedInitializationTask(() -> {
                    boolean rebuildRequested = StubIndexImpl.registerIndexer(extension, forceClean, this.state);
                    if (rebuildRequested) {
                        StringBuilder stringBuilder = this.updated;
                        synchronized (stringBuilder) {
                            this.updated.append(extension).append(' ');
                        }
                    }
                });
            }
        }

        @Override
        protected void onThrowable(@NotNull Throwable t) {
            LOG.error(t);
        }

        @Override
        protected AsyncState finish() {
            boolean someIndicesWereDropped = StubIndexImpl.this.dropUnregisteredIndices(this.state);
            if (someIndicesWereDropped) {
                this.updated.append(" and some indices were dropped");
            }
            if (this.updated.length() > 0) {
                Throwable e = new Throwable(this.updated.toString());
                ApplicationManager.getApplication().invokeLater(() -> StubIndexImpl.this.forceRebuild(e), ModalityState.NON_MODAL);
            }
            StubIndexImpl.this.myInitialized = true;
            return this.state;
        }
    }

    private static abstract class StubIdListContainerAction
    implements ValueContainer.ContainerAction<StubIdList> {
        private final IdFilter myIdFilter;

        StubIdListContainerAction(@Nullable IdFilter idFilter, @NotNull Project project) {
            this.myIdFilter = idFilter != null ? idFilter : ((FileBasedIndexImpl)FileBasedIndex.getInstance()).projectIndexableFiles(project);
        }

        public boolean perform(int id, @NotNull StubIdList value) {
            ProgressManager.checkCanceled();
            if (this.myIdFilter != null && !this.myIdFilter.containsFileId(id)) {
                return true;
            }
            return this.process(id, value);
        }

        protected abstract boolean process(int var1, @NotNull StubIdList var2);
    }

    private static class MyIndex<K>
    extends VfsAwareMapReduceIndex<K, StubIdList, Void> {
        @NotNull
        protected ReentrantReadWriteLock createLock() {
            UpdatableIndex<Integer, SerializedStubTree, FileContent> index = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).getIndex(StubUpdatingIndex.INDEX_ID);
            return ((MapReduceIndex)index).getLock();
        }

        MyIndex(@NotNull IndexExtension<K, StubIdList, Void> extension, @NotNull IndexStorage<K, StubIdList> storage2) throws IOException {
            super(extension, storage2, null);
        }

        public void updateWithMap(int inputId, @NotNull UpdateData<K, StubIdList> updateData) throws StorageException {
            super.updateWithMap(inputId, updateData);
        }

        @NotNull
        public IndexExtension<K, StubIdList, Void> getExtension() {
            return this.myExtension;
        }
    }

    private static class StubIdExternalizer
    implements DataExternalizer<StubIdList> {
        private static final StubIdExternalizer INSTANCE = new StubIdExternalizer();

        private StubIdExternalizer() {
        }

        public void save(@NotNull DataOutput out, @NotNull StubIdList value) throws IOException {
            int size = value.size();
            if (size == 0) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)Integer.MAX_VALUE);
            } else if (size == 1) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.get(0));
            } else {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-size));
                for (int i = 0; i < size; ++i) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)value.get(i));
                }
            }
        }

        @NotNull
        public StubIdList read(@NotNull DataInput in) throws IOException {
            int size = DataInputOutputUtil.readINT((DataInput)in);
            if (size == Integer.MAX_VALUE) {
                return new StubIdList();
            }
            if (size >= 0) {
                return new StubIdList(size);
            }
            size = -size;
            int[] result2 = new int[size];
            for (int i = 0; i < size; ++i) {
                result2[i] = DataInputOutputUtil.readINT((DataInput)in);
            }
            return new StubIdList(result2, size);
        }
    }

    private static class AsyncState {
        private final Map<StubIndexKey<?, ?>, MyIndex<?>> myIndices = new THashMap();
        private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap = new TObjectIntHashMap();

        private AsyncState() {
        }
    }
}

