/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubProcessingHelperBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubProcessingHelperBase");

    public <Psi extends PsiElement> boolean processStubsInFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull StubIdList value, @NotNull Processor<? super Psi> processor2, @Nullable GlobalSearchScope scope, @NotNull Class<Psi> requiredClass) {
        PsiElement psi;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (psiFile == null) {
            LOG.error("Stub index points to a file without PSI: " + file2.getFileType() + ", used scope " + scope);
            this.onInternalError(file2);
            return true;
        }
        if (value.size() == 1 && value.get(0) == 0) {
            return !this.checkType(requiredClass, psiFile, (PsiElement)psiFile) || processor2.process((Object)psiFile);
        }
        List<StubbedSpine> spines = StubProcessingHelperBase.getAllSpines(psiFile);
        if (spines.isEmpty()) {
            return this.handleNonPsiStubs(file2, processor2, requiredClass, psiFile);
        }
        int size = value.size();
        for (int i = 0; i < size && this.checkType(requiredClass, psiFile, psi = StubProcessingHelperBase.getStubPsi(spines, value.get(i))); ++i) {
            if (processor2.process((Object)psi)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<StubbedSpine> getAllSpines(PsiFile psiFile) {
        if (!(psiFile instanceof PsiFileImpl) && psiFile instanceof PsiFileWithStubSupport) {
            return Collections.singletonList(((PsiFileWithStubSupport)psiFile).getStubbedSpine());
        }
        return ContainerUtil.map(StubTreeBuilder.getStubbedRoots(psiFile.getViewProvider()), t -> ((PsiFileImpl)t.second).getStubbedSpine());
    }

    private <Psi extends PsiElement> boolean checkType(@NotNull Class<Psi> requiredClass, PsiFile psiFile, PsiElement psiElement) {
        if (requiredClass.isInstance(psiElement)) {
            return true;
        }
        StubTree stubTree = ((PsiFileWithStubSupport)psiFile).getStubTree();
        if (stubTree == null && psiFile instanceof PsiFileImpl) {
            stubTree = ((PsiFileImpl)psiFile).calcStubTree();
        }
        this.inconsistencyDetected(stubTree, (PsiFileWithStubSupport)psiFile);
        return false;
    }

    private static PsiElement getStubPsi(List<? extends StubbedSpine> spines, int index) {
        if (spines.size() == 1) {
            return spines.get(0).getStubPsi(index);
        }
        for (StubbedSpine stubbedSpine : spines) {
            int count = stubbedSpine.getStubCount();
            if (index < count) {
                return stubbedSpine.getStubPsi(index);
            }
            index -= count;
        }
        return null;
    }

    private <Psi extends PsiElement> boolean handleNonPsiStubs(@NotNull VirtualFile file2, @NotNull Processor<? super Psi> processor2, @NotNull Class<Psi> requiredClass, @NotNull PsiFile psiFile) {
        if (BinaryFileStubBuilders.INSTANCE.forFileType(psiFile.getFileType()) == null) {
            LOG.error("unable to get stub builder for " + psiFile.getFileType() + ", " + StubTreeLoader.getFileViewProviderMismatchDiagnostics(psiFile.getViewProvider()));
            this.onInternalError(file2);
            return true;
        }
        if (psiFile instanceof PsiBinaryFile) {
            return true;
        }
        ObjectStubTree objectStubTree = StubTreeLoader.getInstance().readFromVFile(psiFile.getProject(), file2);
        if (objectStubTree == null) {
            LOG.error("Stub index points to a file without indexed stubs: " + psiFile.getFileType());
            this.onInternalError(file2);
            return true;
        }
        if (objectStubTree instanceof StubTree) {
            LOG.error("Stub index points to a file with PSI stubs (instead of non-PSI ones): " + psiFile.getFileType());
            this.onInternalError(file2);
            return true;
        }
        if (!requiredClass.isInstance(psiFile)) {
            this.inconsistencyDetected(objectStubTree, (PsiFileWithStubSupport)psiFile);
            return true;
        }
        return processor2.process((Object)psiFile);
    }

    private void inconsistencyDetected(@Nullable ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile) {
        try {
            StubTextInconsistencyException.checkStubTextConsistency(psiFile);
            LOG.error((Throwable)StubTreeLoader.getInstance().stubTreeAndIndexDoNotMatch(stubTree, psiFile, null));
        }
        finally {
            this.onInternalError(psiFile.getVirtualFile());
        }
    }

    protected abstract void onInternalError(VirtualFile var1);
}

