/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.LazyStubData;
import com.intellij.psi.stubs.LazyStubList;
import com.intellij.psi.stubs.MostlyUShortIntList;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.RecentStringInterner;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StubSerializationHelper {
    private final AbstractStringEnumerator myNameStorage;
    private final TIntObjectHashMap<String> myIdToName = new TIntObjectHashMap();
    private final TObjectIntHashMap<String> myNameToId = new TObjectIntHashMap();
    private final THashMap<String, Computable<ObjectStubSerializer>> myNameToLazySerializer = new THashMap();
    private final ConcurrentIntObjectMap<ObjectStubSerializer> myIdToSerializer = ContainerUtil.createConcurrentIntObjectMap();
    private final Map<ObjectStubSerializer, Integer> mySerializerToId = ContainerUtil.newConcurrentMap();
    private final RecentStringInterner myStringInterner;
    private static final ThreadLocal<ObjectStubSerializer> ourRootStubSerializer = new ThreadLocal();

    StubSerializationHelper(@NotNull AbstractStringEnumerator nameStorage, @NotNull Disposable parentDisposable) {
        this.myNameStorage = nameStorage;
        this.myStringInterner = new RecentStringInterner(parentDisposable);
    }

    void assignId(@NotNull Computable<ObjectStubSerializer> serializer, String name) throws IOException {
        Computable old = (Computable)this.myNameToLazySerializer.put((Object)name, serializer);
        if (old != null) {
            ObjectStubSerializer computed;
            ObjectStubSerializer existing = (ObjectStubSerializer)old.compute();
            if (existing != (computed = (ObjectStubSerializer)serializer.compute())) {
                throw new AssertionError((Object)("ID: " + name + " is not unique, but found in both " + existing.getClass().getName() + " and " + computed.getClass().getName()));
            }
            return;
        }
        int id = this.myNameStorage.enumerate((Object)name);
        this.myIdToName.put(id, (Object)name);
        this.myNameToId.put((Object)name, id);
    }

    void copyFrom(@Nullable StubSerializationHelper helper) throws IOException {
        if (helper == null) {
            return;
        }
        for (String name : helper.myNameToLazySerializer.keySet()) {
            this.assignId((Computable<ObjectStubSerializer>)((Computable)helper.myNameToLazySerializer.get((Object)name)), name);
        }
    }

    private ObjectStubSerializer<Stub, Stub> writeSerializerId(Stub stub, @NotNull DataOutput stream) throws IOException {
        ObjectStubSerializer serializer = StubSerializationUtil.getSerializer((Stub)stub);
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.getClassId(serializer));
        return serializer;
    }

    private void serializeSelf(Stub stub, @NotNull StubOutputStream stream) throws IOException {
        if (((ObjectStubBase)stub).isDangling()) {
            stream.writeByte(0);
        }
        this.writeSerializerId(stub, (DataOutput)stream).serialize(stub, stream);
    }

    private void serializeChildren(@NotNull Stub parent, @NotNull StubOutputStream stream) throws IOException {
        List children2 = parent.getChildrenStubs();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)children2.size());
        for (Stub child2 : children2) {
            this.serializeSelf(child2, stream);
            this.serializeChildren(child2, stream);
        }
    }

    void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) throws IOException {
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage2 = new FileLocalStringEnumerator(true);
        StubOutputStream stubOutputStream = new StubOutputStream((OutputStream)out, (AbstractStringEnumerator)storage2);
        boolean doDefaultSerialization = true;
        if (rootStub instanceof PsiFileStubImpl) {
            PsiFileStub[] roots = ((PsiFileStubImpl)rootStub).getStubRoots();
            if (roots.length == 0) {
                Logger.getInstance(this.getClass()).error("Incorrect stub files count during serialization:" + rootStub + "," + rootStub.getStubType());
            } else {
                doDefaultSerialization = false;
                DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)roots.length);
                for (PsiFileStub root : roots) {
                    this.serializeRoot(stubOutputStream, (Stub)root, storage2);
                }
            }
        }
        if (doDefaultSerialization) {
            DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)1);
            this.serializeRoot(stubOutputStream, rootStub, storage2);
        }
        DataOutputStream resultStream = new DataOutputStream(stream);
        DataInputOutputUtil.writeINT((DataOutput)resultStream, (int)storage2.myStrings.size());
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        for (String s : storage2.myStrings) {
            IOUtil.writeUTFFast((byte[])buffer, (DataOutput)resultStream, (String)s);
        }
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    private int getClassId(ObjectStubSerializer serializer) {
        Integer idValue = this.mySerializerToId.get(serializer);
        if (idValue == null) {
            String name = serializer.getExternalId();
            idValue = this.myNameToId.get((Object)name);
            assert (idValue > 0) : "No ID found for serializer " + LogUtil.objectAndClass((Object)serializer) + ", external id:" + name + (serializer instanceof IElementType ? ", language:" + ((IElementType)serializer).getLanguage() + ", " + serializer : "");
            this.mySerializerToId.put(serializer, idValue);
        }
        return idValue;
    }

    @NotNull
    Stub deserialize(@NotNull InputStream stream) throws IOException, SerializerNotFoundException {
        PsiFileStub[] stubsArray;
        FileLocalStringEnumerator storage2 = new FileLocalStringEnumerator(false);
        StubInputStream inputStream = new StubInputStream(stream, (AbstractStringEnumerator)storage2);
        int numberOfStrings = DataInputOutputUtil.readINT((DataInput)inputStream);
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        storage2.myStrings.ensureCapacity(numberOfStrings);
        for (int i = 0; i < numberOfStrings; ++i) {
            String s = this.myStringInterner.get(IOUtil.readUTFFast((byte[])buffer, (DataInput)inputStream));
            storage2.myStrings.add(s);
        }
        int stubFilesCount = DataInputOutputUtil.readINT((DataInput)inputStream);
        if (stubFilesCount <= 0) {
            Logger.getInstance(this.getClass()).error("Incorrect stub files count during deserialization:" + stubFilesCount);
        }
        Stub baseStub = this.deserializeRoot(storage2, inputStream);
        ArrayList stubs = ContainerUtil.newArrayListWithCapacity((int)stubFilesCount);
        if (baseStub instanceof PsiFileStub) {
            stubs.add((PsiFileStub)baseStub);
        }
        for (int j = 1; j < stubFilesCount; ++j) {
            Stub deserialize2 = this.deserializeRoot(storage2, inputStream);
            if (deserialize2 instanceof PsiFileStub) {
                PsiFileStub fileStub = (PsiFileStub)deserialize2;
                stubs.add(fileStub);
                continue;
            }
            Logger.getInstance(this.getClass()).error("Stub root must be PsiFileStub for files with several stub roots");
        }
        for (PsiFileStub stub : stubsArray = stubs.toArray(PsiFileStub.EMPTY_ARRAY)) {
            if (!(stub instanceof PsiFileStubImpl)) continue;
            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
        }
        return baseStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stub deserializeRoot(FileLocalStringEnumerator storage2, StubInputStream inputStream) throws IOException, SerializerNotFoundException {
        ObjectStubSerializer<?, Stub> serializer = this.getClassById(DataInputOutputUtil.readINT((DataInput)inputStream), null);
        ourRootStubSerializer.set(serializer);
        try {
            Stub stub = serializer.deserialize(inputStream, null);
            if (stub instanceof StubBase) {
                this.deserializeStubList(storage2, inputStream, (StubBase)stub, serializer);
            } else {
                this.deserializeChildren(inputStream, stub);
            }
            Stub stub2 = stub;
            return stub2;
        }
        finally {
            ourRootStubSerializer.set(null);
        }
    }

    private void serializeRoot(StubOutputStream out, Stub root, AbstractStringEnumerator storage2) throws IOException {
        this.serializeSelf(root, out);
        if (root instanceof StubBase) {
            StubList stubList = ((StubBase)root).myStubList;
            if (root != stubList.get(0)) {
                throw new IllegalArgumentException("Serialization is supported only for root stubs");
            }
            this.serializeStubList((DataOutput)out, storage2, stubList);
        } else {
            this.serializeChildren(root, out);
        }
    }

    private void deserializeStubList(FileLocalStringEnumerator storage2, final StubInputStream inputStream, StubBase<?> root, final ObjectStubSerializer rootType) throws IOException, SerializerNotFoundException {
        int stubCount = DataInputOutputUtil.readINT((DataInput)inputStream);
        final LazyStubList stubList = new LazyStubList(stubCount, root, rootType);
        final MostlyUShortIntList parentsAndStarts = new MostlyUShortIntList(stubCount * 2);
        final BitSet allStarts = new BitSet();
        new Object(){
            int currentIndex = 1;

            private void deserializeStub(int parentIndex) throws IOException, SerializerNotFoundException {
                int index = this.currentIndex++;
                int serializerId = DataInputOutputUtil.readINT((DataInput)inputStream);
                int start2 = DataInputOutputUtil.readINT((DataInput)inputStream);
                allStarts.set(start2);
                this.addStub(parentIndex, index, start2, (IElementType)StubSerializationHelper.this.getClassById(serializerId, null));
                this.deserializeChildren(index);
            }

            private void addStub(int parentIndex, int index, int start2, IElementType type) {
                parentsAndStarts.add(parentIndex);
                parentsAndStarts.add(start2);
                stubList.addLazyStub(type, index, parentIndex);
            }

            private void deserializeChildren(int parentIndex) throws IOException, SerializerNotFoundException {
                int childrenCount = DataInputOutputUtil.readINT((DataInput)inputStream);
                stubList.prepareForChildren(parentIndex, childrenCount);
                for (int i = 0; i < childrenCount; ++i) {
                    this.deserializeStub(parentIndex);
                }
            }

            void deserializeRoot() throws IOException, SerializerNotFoundException {
                this.addStub(0, 0, 0, (IElementType)rootType);
                this.deserializeChildren(0);
            }
        }.deserializeRoot();
        byte[] serializedStubs = this.readByteArray(inputStream);
        stubList.setStubData(new LazyStubData(storage2, parentsAndStarts, serializedStubs, allStarts));
    }

    private void serializeStubList(DataOutput out, AbstractStringEnumerator storage2, StubList stubList) throws IOException {
        if (!stubList.isChildrenLayoutOptimal()) {
            throw new IllegalArgumentException("Manually assembled stubs should be normalized before serialization, consider wrapping them into StubTree");
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.size());
        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.getChildrenCount(0));
        BufferExposingByteArrayOutputStream tempBuffer = new BufferExposingByteArrayOutputStream();
        ByteArrayInterner interner = new ByteArrayInterner();
        for (int i = 1; i < stubList.size(); ++i) {
            StubBase stub = (StubBase)stubList.get(i);
            ObjectStubSerializer<Stub, Stub> serializer = this.writeSerializerId((Stub)stub, out);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)interner.internBytes(StubSerializationHelper.serializeStub(serializer, storage2, stub, tempBuffer)));
            DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.getChildrenCount(stub.id));
        }
        StubSerializationHelper.writeByteArray(out, interner.joinedBuffer.getInternalBuffer(), interner.joinedBuffer.size());
    }

    private static byte[] serializeStub(ObjectStubSerializer<Stub, Stub> serializer, AbstractStringEnumerator storage2, StubBase<?> stub, BufferExposingByteArrayOutputStream tempBuffer) throws IOException {
        tempBuffer.reset();
        StubOutputStream stubOut = new StubOutputStream((OutputStream)tempBuffer, storage2);
        serializer.serialize(stub, stubOut);
        if (stub.isDangling()) {
            stubOut.writeByte(0);
        }
        return tempBuffer.size() == 0 ? ArrayUtil.EMPTY_BYTE_ARRAY : tempBuffer.toByteArray();
    }

    private byte[] readByteArray(StubInputStream inputStream) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)inputStream);
        if (length == 0) {
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        byte[] array = new byte[length];
        int read2 = inputStream.read(array);
        if (read2 != array.length) {
            Logger.getInstance(this.getClass()).error("Serialized array length mismatch");
        }
        return array;
    }

    private static void writeByteArray(DataOutput out, byte[] array, int len) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)len);
        out.write(array, 0, len);
    }

    String intern(String str) {
        return this.myStringInterner.get(str);
    }

    private ObjectStubSerializer<?, Stub> getClassById(int id, @Nullable Stub parentStub) throws SerializerNotFoundException {
        ObjectStubSerializer serializer = (ObjectStubSerializer)this.myIdToSerializer.get(id);
        if (serializer == null) {
            serializer = this.instantiateSerializer(id, parentStub);
            this.myIdToSerializer.put(id, (Object)serializer);
        }
        return serializer;
    }

    @NotNull
    private ObjectStubSerializer instantiateSerializer(int id, @Nullable Stub parentStub) throws SerializerNotFoundException {
        ObjectStubSerializer serializer;
        String name = (String)this.myIdToName.get(id);
        Computable lazy = name == null ? null : (Computable)this.myNameToLazySerializer.get((Object)name);
        ObjectStubSerializer objectStubSerializer = serializer = lazy == null ? null : (ObjectStubSerializer)lazy.compute();
        if (serializer == null) {
            throw this.reportMissingSerializer(id, parentStub);
        }
        return serializer;
    }

    private SerializerNotFoundException reportMissingSerializer(int id, @Nullable Stub parentStub) {
        String externalId = null;
        try {
            externalId = (String)this.myNameStorage.valueOf(id);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SerializerNotFoundException(StubSerializationHelper.brokenStubFormat(ourRootStubSerializer.get()) + "Internal details, no serializer registered for stub: ID=" + id + ", externalId:" + externalId + "; parent stub class=" + (parentStub != null ? parentStub.getClass().getName() + ", parent stub type:" + parentStub.getStubType() : "null"));
    }

    static String brokenStubFormat(ObjectStubSerializer root) {
        return "Broken stub format, most likely version of " + root + " was not updated after serialization changes\n";
    }

    private void deserializeChildren(StubInputStream stream, Stub parent) throws IOException, SerializerNotFoundException {
        int childCount = DataInputOutputUtil.readINT((DataInput)stream);
        for (int i = 0; i < childCount; ++i) {
            boolean dangling = false;
            int id = DataInputOutputUtil.readINT((DataInput)stream);
            if (id == 0) {
                dangling = true;
                id = DataInputOutputUtil.readINT((DataInput)stream);
            }
            Stub child2 = this.getClassById(id, parent).deserialize(stream, parent);
            if (dangling) {
                ((ObjectStubBase)child2).markDangling();
            }
            this.deserializeChildren(stream, child2);
        }
    }

    private static class FileLocalStringEnumerator
    implements AbstractStringEnumerator {
        private final TObjectIntHashMap<String> myEnumerates;
        private final ArrayList<String> myStrings = new ArrayList();

        FileLocalStringEnumerator(boolean forSavingStub) {
            this.myEnumerates = forSavingStub ? new TObjectIntHashMap() : null;
        }

        public int enumerate(@Nullable String value) {
            if (value == null) {
                return 0;
            }
            assert (this.myEnumerates != null);
            int i = this.myEnumerates.get((Object)value);
            if (i == 0) {
                i = this.myStrings.size() + 1;
                this.myEnumerates.put((Object)value, i);
                this.myStrings.add(value);
            }
            return i;
        }

        public String valueOf(int idx) {
            if (idx == 0) {
                return null;
            }
            return this.myStrings.get(idx - 1);
        }

        public void markCorrupted() {
        }

        public void close() throws IOException {
        }

        public boolean isDirty() {
            return false;
        }

        public void force() {
        }
    }

    private static class ByteArrayInterner {
        private static final TObjectHashingStrategy<byte[]> BYTE_ARRAY_STRATEGY = new TObjectHashingStrategy<byte[]>(){

            public int computeHashCode(byte[] object) {
                return Arrays.hashCode(object);
            }

            public boolean equals(byte[] o1, byte[] o2) {
                return Arrays.equals(o1, o2);
            }
        };
        private final TObjectIntHashMap<byte[]> arrayToStart = new TObjectIntHashMap(BYTE_ARRAY_STRATEGY);
        final BufferExposingByteArrayOutputStream joinedBuffer = new BufferExposingByteArrayOutputStream();

        private ByteArrayInterner() {
        }

        int internBytes(byte[] bytes) {
            if (bytes.length == 0) {
                return 0;
            }
            int start2 = this.arrayToStart.get((Object)bytes);
            if (start2 == 0) {
                start2 = this.joinedBuffer.size() + 1;
                this.arrayToStart.put((Object)bytes, start2);
                this.joinedBuffer.write(bytes, 0, bytes.length);
            }
            return start2;
        }
    }
}

