/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.ManyProjectsStubIndexMismatch;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.UpToDateStubIndexMismatch;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubTreeLoader {
    public static StubTreeLoader getInstance() {
        return (StubTreeLoader)ServiceManager.getService(StubTreeLoader.class);
    }

    @Nullable
    public abstract ObjectStubTree readOrBuild(Project var1, VirtualFile var2, @Nullable PsiFile var3);

    @Nullable
    public abstract ObjectStubTree readFromVFile(Project var1, VirtualFile var2);

    public abstract void rebuildStubTree(VirtualFile var1);

    public abstract boolean canHaveStub(VirtualFile var1);

    protected boolean hasPsiInManyProjects(@NotNull VirtualFile virtualFile) {
        return false;
    }

    @Nullable
    protected IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        return null;
    }

    @NotNull
    public RuntimeException stubTreeAndIndexDoNotMatch(@Nullable ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile, @Nullable Throwable cause) {
        VirtualFile file2 = psiFile.getViewProvider().getVirtualFile();
        StubTree stubTreeFromIndex = (StubTree)this.readFromVFile(psiFile.getProject(), file2);
        boolean compiled = psiFile instanceof PsiCompiledElement;
        Document document = compiled ? null : FileDocumentManager.getInstance().getDocument(file2);
        IndexingStampInfo indexingStampInfo = this.getIndexingStampInfo(file2);
        boolean upToDate = indexingStampInfo != null && indexingStampInfo.isUpToDate(document, file2, psiFile);
        boolean canBePrebuilt = this.isPrebuilt(psiFile.getVirtualFile());
        String msg = "PSI and index do not match.\nPlease report the problem to JetBrains with the files attached\n";
        if (canBePrebuilt) {
            msg = msg + "This stub can have pre-built origin\n";
        }
        if (upToDate) {
            msg = msg + "INDEXED VERSION IS THE CURRENT ONE";
        }
        msg = msg + " file=" + psiFile;
        msg = msg + ", file.class=" + psiFile.getClass();
        msg = msg + ", file.lang=" + psiFile.getLanguage();
        msg = msg + ", modStamp=" + psiFile.getModificationStamp();
        if (!compiled) {
            String text = psiFile.getText();
            PsiFile fromText = PsiFileFactory.getInstance((Project)psiFile.getProject()).createFileFromText(psiFile.getName(), psiFile.getFileType(), (CharSequence)text);
            if (fromText.getLanguage().equals(psiFile.getLanguage())) {
                boolean consistent = DebugUtil.psiToString((PsiElement)psiFile, true).equals(DebugUtil.psiToString((PsiElement)fromText, true));
                msg = consistent ? msg + "\n tree consistent" : msg + "\n AST INCONSISTENT, perhaps after incremental reparse; " + fromText;
            }
        }
        if (stubTree != null) {
            msg = msg + "\n stub debugInfo=" + stubTree.getDebugInfo();
        }
        msg = msg + "\nlatestIndexedStub=" + stubTreeFromIndex;
        if (stubTreeFromIndex != null) {
            if (stubTree != null) {
                msg = msg + "\n   same size=" + (stubTree.getPlainList().size() == stubTreeFromIndex.getPlainList().size());
            }
            msg = msg + "\n   debugInfo=" + stubTreeFromIndex.getDebugInfo();
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        msg = msg + "\n viewProvider=" + viewProvider;
        msg = msg + "\n viewProvider stamp: " + viewProvider.getModificationStamp();
        msg = msg + "; file stamp: " + file2.getModificationStamp();
        msg = msg + "; file modCount: " + file2.getModificationCount();
        msg = msg + "; file length: " + file2.getLength();
        if (document != null) {
            msg = msg + "\n doc saved: " + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
            msg = msg + "; doc stamp: " + document.getModificationStamp();
            msg = msg + "; doc size: " + document.getTextLength();
            msg = msg + "; committed: " + PsiDocumentManager.getInstance((Project)psiFile.getProject()).isCommitted(document);
        }
        msg = msg + "\nindexing info: " + indexingStampInfo;
        Attachment[] attachments = StubTreeLoader.createAttachments(stubTree, psiFile, file2, stubTreeFromIndex);
        return this.hasPsiInManyProjects(file2) ? StubTreeLoader.handleManyProjectsMismatch(msg, attachments, cause) : (upToDate ? StubTreeLoader.handleUpToDateMismatch(msg, attachments, cause) : new RuntimeExceptionWithAttachments(msg, cause, attachments));
    }

    protected abstract boolean isPrebuilt(@NotNull VirtualFile var1);

    private static RuntimeExceptionWithAttachments handleUpToDateMismatch(@NotNull String message, Attachment[] attachments, @Nullable Throwable cause) {
        return new UpToDateStubIndexMismatch(message, cause, attachments);
    }

    private static RuntimeExceptionWithAttachments handleManyProjectsMismatch(@NotNull String message, Attachment[] attachments, @Nullable Throwable cause) {
        return new ManyProjectsStubIndexMismatch(message, cause, attachments);
    }

    @NotNull
    private static Attachment[] createAttachments(@Nullable ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile, VirtualFile file2, @Nullable StubTree stubTreeFromIndex) {
        ArrayList attachments = ContainerUtil.newArrayList();
        attachments.add(new Attachment(file2.getPath() + "_file.txt", psiFile instanceof PsiCompiledElement ? "compiled" : psiFile.getText()));
        if (stubTree != null) {
            attachments.add(new Attachment("stubTree.txt", ((PsiFileStubImpl)stubTree.getRoot()).printTree()));
        }
        if (stubTreeFromIndex != null) {
            attachments.add(new Attachment("stubTreeFromIndex.txt", ((PsiFileStubImpl)stubTreeFromIndex.getRoot()).printTree()));
        }
        return attachments.toArray(Attachment.EMPTY_ARRAY);
    }

    public static String getFileViewProviderMismatchDiagnostics(@NotNull FileViewProvider provider) {
        Function fileClassName = file2 -> file2.getClass().getSimpleName();
        Function stubRootToString = pair -> "(" + ((IStubFileElementType)((Object)((Object)pair.first))).toString() + ", " + ((IStubFileElementType)((Object)((Object)pair.first))).getLanguage() + " -> " + (String)fileClassName.fun(pair.second) + ")";
        List<Pair<IStubFileElementType, PsiFile>> roots = StubTreeBuilder.getStubbedRoots(provider);
        return ", stubBindingRoot = " + (String)fileClassName.fun((Object)provider.getStubBindingRoot()) + ", languages = [" + StringUtil.join((Collection)provider.getLanguages(), Language::getID, (String)", ") + "], fileTypes = [" + StringUtil.join((Collection)provider.getAllFiles(), file2 -> file2.getFileType().getName(), (String)", ") + "], files = [" + StringUtil.join((Collection)provider.getAllFiles(), (Function)fileClassName, (String)", ") + "], roots = [" + StringUtil.join(roots, (Function)stubRootToString, (String)", ") + "]";
    }
}

