/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.android.tools.analytics.Counter;
import com.intellij.index.PrebuiltIndexProviderBase;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PrebuiltStubsProvider;
import com.intellij.psi.stubs.PrebuiltStubsProviders;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializationManager;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubVersionMap;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.counters.IndexCounters;
import com.intellij.util.indexing.impl.CollectionInputDataDiffBuilder;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMapValueStorage;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubUpdatingIndex
extends CustomImplementationFileBasedIndexExtension<Integer, SerializedStubTree, FileContent>
implements PsiDependentIndex,
CustomInputsIndexFileBasedIndexExtension<Integer> {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubUpdatingIndex");
    private static final int VERSION = 37 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);
    private static final FileAttribute INDEXED_STAMP = new FileAttribute("stubIndexStamp", 2, true);
    public static final ID<Integer, SerializedStubTree> INDEX_ID = ID.create((String)"Stubs");
    private static final DataExternalizer<SerializedStubTree> KEY_EXTERNALIZER = new DataExternalizer<SerializedStubTree>(){

        public void save(@NotNull DataOutput out, @NotNull SerializedStubTree v) throws IOException {
            v.write(out);
        }

        @NotNull
        public SerializedStubTree read(@NotNull DataInput in) throws IOException {
            return new SerializedStubTree(in);
        }
    };
    protected static final FileBasedIndex.InputFilter INPUT_FILTER = file2 -> StubUpdatingIndex.canHaveStub(file2);
    private static final KeyDescriptor<Integer> DATA_DESCRIPTOR = new IntInlineKeyDescriptor();

    public static boolean canHaveStub(@NotNull VirtualFile file2) {
        BinaryFileStubBuilder builder2;
        FileType fileType = SubstitutedFileType.substituteFileType(file2, file2.getFileType(), ProjectUtil.guessProjectForFile((VirtualFile)file2));
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            if (elementType instanceof IStubFileElementType) {
                if (((IStubFileElementType)elementType).shouldBuildStubFor(file2)) {
                    return true;
                }
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                if (file2 instanceof NewVirtualFile && fileBasedIndex instanceof FileBasedIndexImpl && ((FileBasedIndexImpl)fileBasedIndex).getIndex(INDEX_ID).isIndexedStateForFile(((NewVirtualFile)file2).getId(), file2)) {
                    return true;
                }
            }
        }
        return (builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) != null && builder2.acceptsFile(file2);
    }

    @NotNull
    public ID<Integer, SerializedStubTree> getName() {
        return INDEX_ID;
    }

    public int getCacheSize() {
        return 5;
    }

    public boolean keyIsUniqueForIndexedFile() {
        return true;
    }

    @Override
    @NotNull
    public DataExternalizer<Collection<Integer>> createExternalizer() {
        return new DataExternalizer<Collection<Integer>>(){
            private volatile boolean myEnsuredStubElementTypesLoaded;

            public void save(@NotNull DataOutput out, Collection<Integer> value) throws IOException {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.iterator().next());
                Map stubIndicesValueMap = ((StubUpdatingIndexKeys)value).myStubIndicesValueMap;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(stubIndicesValueMap != null ? stubIndicesValueMap.size() : 0));
                if (stubIndicesValueMap != null && !stubIndicesValueMap.isEmpty()) {
                    StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
                    for (StubIndexKey stubIndexKey : stubIndicesValueMap.keySet()) {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubIndexKey.getUniqueId());
                        Map map2 = (Map)stubIndicesValueMap.get(stubIndexKey);
                        stubIndex.serializeIndexValue(out, stubIndexKey, map2);
                    }
                }
            }

            public Collection<Integer> read(@NotNull DataInput in) throws IOException {
                if (!this.myEnsuredStubElementTypesLoaded) {
                    SerializationManager.getInstance().initSerializers();
                    StubIndexImpl.initExtensions();
                    this.myEnsuredStubElementTypesLoaded = true;
                }
                int fileId = DataInputOutputUtil.readINT((DataInput)in);
                StubUpdatingIndexKeys integers = new StubUpdatingIndexKeys(ContainerUtil.set((Object[])new Integer[]{fileId}));
                int stubIndicesValueMapSize = DataInputOutputUtil.readINT((DataInput)in);
                if (stubIndicesValueMapSize > 0) {
                    THashMap stubIndicesValueMap = new THashMap(stubIndicesValueMapSize);
                    StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
                    for (int i = 0; i < stubIndicesValueMapSize; ++i) {
                        int stubIndexId = DataInputOutputUtil.readINT((DataInput)in);
                        ID indexKey = ID.findById((int)stubIndexId);
                        if (!(indexKey instanceof StubIndexKey)) continue;
                        StubIndexKey stubIndexKey = (StubIndexKey)indexKey;
                        stubIndicesValueMap.put((Object)stubIndexKey, stubIndex.deserializeIndexValue(in, stubIndexKey));
                    }
                    integers.myStubIndicesValueMap = (Map)stubIndicesValueMap;
                }
                return integers;
            }
        };
    }

    @NotNull
    public DataIndexer<Integer, SerializedStubTree, FileContent> getIndexer() {
        return new DataIndexer<Integer, SerializedStubTree, FileContent>(){

            @NotNull
            public Map<Integer, SerializedStubTree> map(@NotNull FileContent inputData) {
                THashMap<Integer, SerializedStubTree> result2 = new THashMap<Integer, SerializedStubTree>(){
                    StubUpdatingIndexKeys myKeySet;

                    @NotNull
                    public Set<Integer> keySet() {
                        if (this.myKeySet == null) {
                            this.myKeySet = new StubUpdatingIndexKeys(super.keySet());
                        }
                        return this.myKeySet;
                    }
                };
                ApplicationManager.getApplication().runReadAction(() -> 3.lambda$map$0(inputData, (Map)result2));
                return result2;
            }

            private static /* synthetic */ void lambda$map$0(FileContent inputData, Map result2) {
                PrebuiltStubsProvider prebuiltStubsProvider;
                Stub rootStub = null;
                if (Registry.is((String)"use.prebuilt.indices") && (prebuiltStubsProvider = (PrebuiltStubsProvider)PrebuiltStubsProviders.INSTANCE.forFileType(inputData.getFileType())) != null) {
                    rootStub = prebuiltStubsProvider.findStub(inputData);
                    if (PrebuiltIndexProviderBase.DEBUG_PREBUILT_INDICES) {
                        Stub stub = StubTreeBuilder.buildStubTree(inputData);
                        if (rootStub != null && stub != null) {
                            StubUpdatingIndex.check(rootStub, stub);
                        }
                    }
                }
                if (rootStub == null) {
                    rootStub = StubTreeBuilder.buildStubTree(inputData);
                }
                if (rootStub == null) {
                    return;
                }
                VirtualFile file2 = inputData.getFile();
                int contentLength = file2.getFileType().isBinary() ? -1 : ((FileContentImpl)inputData).getPsiFileForPsiDependentIndex().getTextLength();
                StubUpdatingIndex.rememberIndexingStamp(file2, contentLength);
                BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
                SerializationManagerEx.getInstanceEx().serialize(rootStub, (OutputStream)bytes);
                if (DebugAssertions.DEBUG) {
                    try {
                        Stub deserialized = SerializationManagerEx.getInstanceEx().deserialize(bytes.toInputStream());
                        StubUpdatingIndex.check(deserialized, rootStub);
                    }
                    catch (ProcessCanceledException pce) {
                        throw pce;
                    }
                    catch (Throwable t) {
                        LOG.error("Error indexing:" + file2, t);
                    }
                }
                int key = SingleEntryFileBasedIndexExtension.getFileKey(file2);
                SerializedStubTree serializedStubTree = new SerializedStubTree(bytes.getInternalBuffer(), bytes.size(), rootStub, file2.getLength(), contentLength);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Indexing " + file2 + "; lengths=" + serializedStubTree.dumpLengths());
                }
                result2.put(key, serializedStubTree);
                try {
                    ((StubUpdatingIndexKeys)result2.keySet()).myStubIndicesValueMap = StubUpdatingIndex.calcStubIndicesValueMap(serializedStubTree);
                }
                catch (StorageException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    private static void check(@NotNull Stub stub, @NotNull Stub stub2) {
        assert (stub.getStubType() == stub2.getStubType());
        List stubs = stub.getChildrenStubs();
        List stubs2 = stub2.getChildrenStubs();
        assert (stubs.size() == stubs2.size());
        int len = stubs.size();
        for (int i = 0; i < len; ++i) {
            StubUpdatingIndex.check((Stub)stubs.get(i), (Stub)stubs2.get(i));
        }
    }

    private static void rememberIndexingStamp(@NotNull VirtualFile file2, long contentLength) {
        try (DataOutputStream stream = INDEXED_STAMP.writeAttribute(file2);){
            DataInputOutputUtil.writeTIME((DataOutput)stream, (long)file2.getTimeStamp());
            DataInputOutputUtil.writeLONG((DataOutput)stream, (long)contentLength);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        try (DataInputStream stream = INDEXED_STAMP.readAttribute(file2);){
            if (stream == null) {
                IndexingStampInfo indexingStampInfo2 = null;
                return indexingStampInfo2;
            }
            long stamp = DataInputOutputUtil.readTIME((DataInput)stream);
            long size = DataInputOutputUtil.readLONG((DataInput)stream);
            IndexingStampInfo indexingStampInfo = new IndexingStampInfo(stamp, size);
            return indexingStampInfo;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        return DATA_DESCRIPTOR;
    }

    @NotNull
    public DataExternalizer<SerializedStubTree> getValueExternalizer() {
        return KEY_EXTERNALIZER;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return INPUT_FILTER;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return VERSION;
    }

    @Override
    @NotNull
    public UpdatableIndex<Integer, SerializedStubTree, FileContent> createIndexImplementation(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage2) throws StorageException, IOException {
        if (storage2 instanceof MemoryIndexStorage) {
            MemoryIndexStorage memStorage = (MemoryIndexStorage)storage2;
            memStorage.addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState) {
                    ((StubIndexImpl)StubIndex.getInstance()).setDataBufferingEnabled(newState);
                }

                @Override
                public void memoryStorageCleared() {
                    ((StubIndexImpl)StubIndex.getInstance()).cleanupMemoryStorage();
                }
            });
        }
        return new MyIndex(extension, storage2);
    }

    private static void updateStubIndices(@NotNull Collection<StubIndexKey> indexKeys, int inputId, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> newStubTree) {
        StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
        for (StubIndexKey key : indexKeys) {
            Map<Object, StubIdList> oldMap = oldStubTree.get(key);
            Map<Object, StubIdList> newMap = newStubTree.get(key);
            Map<Object, StubIdList> _oldMap = oldMap != null ? oldMap : Collections.emptyMap();
            Map<Object, StubIdList> _newMap = newMap != null ? newMap : Collections.emptyMap();
            stubIndex.updateIndex(key, inputId, _oldMap, _newMap);
        }
    }

    @NotNull
    private static Collection<StubIndexKey> getAffectedIndices(@NotNull Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> newStubTree) {
        HashSet<StubIndexKey> allIndices = new HashSet<StubIndexKey>();
        allIndices.addAll(oldStubTree.keySet());
        allIndices.addAll(newStubTree.keySet());
        return allIndices;
    }

    @NotNull
    private static Map<StubIndexKey, Map<Object, StubIdList>> calcStubIndicesValueMap(@NotNull SerializedStubTree stub) throws StorageException {
        try {
            Map<StubIndexKey, Map<Object, StubIdList>> map2;
            ObjectStubBase root = (ObjectStubBase)stub.getStub(true);
            ObjectStubTree objectStubTree = root instanceof PsiFileStub ? new StubTree((PsiFileStub)root, false) : new ObjectStubTree(root, false);
            Map<StubIndexKey, Map<Object, StubIdList>> stubIndicesValueMap = map2 = objectStubTree.indexStubTree();
            for (StubIndexKey key : map2.keySet()) {
                Map<Object, StubIdList> value = map2.get(key);
                for (Object k : value.keySet()) {
                    int[] ints = (int[])value.get(k);
                    StubIdList stubList = ints.length == 1 ? new StubIdList(ints[0]) : new StubIdList(ints, ints.length);
                    value.put(k, stubList);
                }
            }
            return stubIndicesValueMap;
        }
        catch (SerializerNotFoundException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static class MyIndex
    extends VfsAwareMapReduceIndex<Integer, SerializedStubTree, FileContent> {
        private StubIndexImpl myStubIndex;
        private final Counter myWriteLockCounter;
        private final StubVersionMap myStubVersionMap = new StubVersionMap();
        private static final FileAttribute VERSION_STAMP = new FileAttribute("stubIndex.versionStamp", 2, true);

        MyIndex(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage2) throws StorageException, IOException {
            super(extension, storage2);
            this.myWriteLockCounter = IndexCounters.getIndexCounters((String)INDEX_ID.getName()).getWriteLockCounter();
            MyIndex.checkNameStorage();
        }

        @NotNull
        protected UpdateData<Integer, SerializedStubTree> createUpdateData(@NotNull Map<Integer, SerializedStubTree> data, @NotNull ThrowableComputable<InputDataDiffBuilder<Integer, SerializedStubTree>, IOException> oldKeys, @NotNull ThrowableRunnable<IOException> forwardIndexUpdate) {
            return new StubUpdatingData(data, oldKeys, forwardIndexUpdate);
        }

        @Override
        protected void doFlush() throws IOException, StorageException {
            StubIndexImpl stubIndex = this.getStubIndex();
            try {
                stubIndex.flush();
            }
            finally {
                super.doFlush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateWithMap(int inputId, @NotNull UpdateData<Integer, SerializedStubTree> updateData) throws StorageException {
            MyIndex.checkNameStorage();
            StubUpdatingData stubUpdatingData = (StubUpdatingData)updateData;
            Map<StubIndexKey, Map<Object, StubIdList>> newStubIndicesValueMap = stubUpdatingData.getNewStubIndicesValueMap();
            try {
                if (!this.getWriteLock().tryLock()) {
                    this.myWriteLockCounter.timeRunnable(() -> this.getWriteLock().lock());
                }
                super.updateWithMap(inputId, updateData);
                Map<StubIndexKey, Map<Object, StubIdList>> previousStubIndicesValueMap = stubUpdatingData.getOldStubIndicesValueMap();
                StubUpdatingIndex.updateStubIndices(StubUpdatingIndex.getAffectedIndices(previousStubIndicesValueMap, newStubIndicesValueMap), inputId, previousStubIndicesValueMap, newStubIndicesValueMap);
            }
            finally {
                this.getWriteLock().unlock();
            }
        }

        @NotNull
        private StubIndexImpl getStubIndex() {
            StubIndexImpl index = this.myStubIndex;
            if (index == null) {
                this.myStubIndex = index = (StubIndexImpl)StubIndex.getInstance();
            }
            return index;
        }

        private static void checkNameStorage() throws StorageException {
            SerializationManagerEx serializationManager = SerializationManagerEx.getInstanceEx();
            if (serializationManager.isNameStorageCorrupted()) {
                serializationManager.repairNameStorage();
                throw new StorageException("NameStorage for stubs serialization has been corrupted");
            }
        }

        @Override
        public void removeTransientDataForKeys(int inputId, @NotNull Collection<? extends Integer> keys) {
            super.removeTransientDataForKeys(inputId, keys);
            if (keys instanceof StubUpdatingIndexKeys) {
                Map stubIndicesValueMap = ((StubUpdatingIndexKeys)keys).myStubIndicesValueMap;
                StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
                for (StubIndexKey key : stubIndicesValueMap.keySet()) {
                    stubIndex.removeTransientDataForFile(key, inputId, ((Map)stubIndicesValueMap.get(key)).keySet());
                }
            }
        }

        @Override
        protected void doClear() throws StorageException, IOException {
            StubIndexImpl stubIndex = StubIndexImpl.getInstanceOrInvalidate();
            if (stubIndex != null) {
                stubIndex.clearAllIndices();
            }
            this.myStubVersionMap.clear();
            super.doClear();
        }

        @Override
        protected void doDispose() throws StorageException {
            try {
                super.doDispose();
            }
            finally {
                this.getStubIndex().dispose();
            }
        }

        @Override
        public void setIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
            super.setIndexedStateForFile(fileId, file2);
            try (com.intellij.util.io.DataOutputStream stream = FSRecords.writeAttribute(fileId, VERSION_STAMP);){
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.myStubVersionMap.getIndexingTimestampDiffForFileType(file2.getFileType()));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public boolean isIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
            boolean indexedStateForFile = super.isIndexedStateForFile(fileId, file2);
            if (!indexedStateForFile) {
                return false;
            }
            try {
                int diff;
                DataInputStream stream = FSRecords.readAttributeWithLock(fileId, VERSION_STAMP);
                int n = diff = stream != null ? DataInputOutputUtil.readINT((DataInput)stream) : 0;
                if (diff == 0) {
                    return false;
                }
                FileType fileType = this.myStubVersionMap.getFileTypeByIndexingTimestampDiff(diff);
                return fileType != null && this.myStubVersionMap.getStamp(file2.getFileType()) == this.myStubVersionMap.getStamp(fileType);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return false;
            }
        }

        static class StubUpdatingData
        extends UpdateData<Integer, SerializedStubTree> {
            private Collection<Integer> oldStubIndexKeys;

            StubUpdatingData(@NotNull Map<Integer, SerializedStubTree> newData, @NotNull ThrowableComputable<InputDataDiffBuilder<Integer, SerializedStubTree>, IOException> iterator, @Nullable ThrowableRunnable<IOException> forwardIndexUpdate) {
                super(newData, iterator, INDEX_ID, forwardIndexUpdate);
            }

            @NotNull
            protected ThrowableComputable<InputDataDiffBuilder<Integer, SerializedStubTree>, IOException> getCurrentDataEvaluator() {
                return () -> {
                    InputDataDiffBuilder diffBuilder = (InputDataDiffBuilder)super.getCurrentDataEvaluator().compute();
                    if (diffBuilder instanceof CollectionInputDataDiffBuilder) {
                        this.oldStubIndexKeys = ((CollectionInputDataDiffBuilder)diffBuilder).getSeq();
                    } else if (diffBuilder instanceof MapInputDataDiffBuilder) {
                        this.oldStubIndexKeys = ((MapInputDataDiffBuilder)diffBuilder).getMap().keySet();
                    }
                    return diffBuilder;
                };
            }

            @NotNull
            Map<StubIndexKey, Map<Object, StubIdList>> getOldStubIndicesValueMap() {
                return StubUpdatingData.getStubIndicesValuesMap(this.oldStubIndexKeys);
            }

            @NotNull
            Map<StubIndexKey, Map<Object, StubIdList>> getNewStubIndicesValueMap() {
                return StubUpdatingData.getStubIndicesValuesMap(this.getNewData().keySet());
            }

            @NotNull
            private static Map<StubIndexKey, Map<Object, StubIdList>> getStubIndicesValuesMap(@NotNull Collection<Integer> keys) {
                if (keys instanceof StubUpdatingIndexKeys) {
                    return ((StubUpdatingIndexKeys)keys).myStubIndicesValueMap;
                }
                return Collections.emptyMap();
            }
        }
    }

    static class StubUpdatingIndexKeys
    extends AbstractSet<Integer> {
        @NotNull
        private final Set<Integer> myBackingMap;
        @NotNull
        private Map<StubIndexKey, Map<Object, StubIdList>> myStubIndicesValueMap = Collections.emptyMap();

        StubUpdatingIndexKeys(@NotNull Set<Integer> backingMap) {
            this.myBackingMap = backingMap;
        }

        @Override
        @NotNull
        public Iterator<Integer> iterator() {
            return this.myBackingMap.iterator();
        }

        @Override
        public int size() {
            return this.myBackingMap.size();
        }
    }
}

