/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateDataLanguageConfigurable;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTemplateDataLanguageAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setVisible(false);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 != null && files2.length > 1) {
            virtualFile = null;
        }
        if (virtualFile == null || virtualFile.isDirectory()) {
            return;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        FileViewProvider provider = PsiManager.getInstance((Project)project).findViewProvider(virtualFile);
        if (provider instanceof ConfigurableTemplateLanguageFileViewProvider) {
            TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)provider;
            e.getPresentation().setText(LangBundle.message("quickfix.change.template.data.language.text", viewProvider.getTemplateDataLanguage().getDisplayName()));
            e.getPresentation().setEnabled(true);
            e.getPresentation().setVisible(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        ChangeTemplateDataLanguageAction.editSettings(project, (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE));
    }

    public static void editSettings(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        TemplateDataLanguageConfigurable configurable = new TemplateDataLanguageConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
            if (virtualFile != null) {
                configurable.selectFile(virtualFile);
            }
        });
    }
}

