/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.templateLanguages.OuterLanguageElementImpl;
import com.intellij.psi.templateLanguages.SimpleTreePatcher;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TreePatcher;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataElementType
extends IFileElementType
implements ITemplateDataElementType {
    public static final LanguageExtension<TreePatcher> TREE_PATCHER = new LanguageExtension("com.intellij.lang.treePatcher", (Object)new SimpleTreePatcher());
    @NotNull
    private final IElementType myTemplateElementType;
    @NotNull
    private final IElementType myOuterElementType;

    public TemplateDataElementType(@NonNls String debugName, Language language, @NotNull IElementType templateElementType, @NotNull IElementType outerElementType) {
        super(debugName, language);
        this.myTemplateElementType = templateElementType;
        this.myOuterElementType = outerElementType;
    }

    protected Lexer createBaseLexer(TemplateLanguageFileViewProvider viewProvider) {
        return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(viewProvider.getBaseLanguage())).createLexer(viewProvider.getManager().getProject());
    }

    protected LanguageFileType createTemplateFakeFileType(Language language) {
        return new TemplateFileType(language);
    }

    public ASTNode parseContents(@NotNull ASTNode chameleon) {
        CharTable charTable = SharedImplUtil.findCharTableByTree(chameleon);
        FileElement fileElement = TreeUtil.getFileElement((TreeElement)chameleon);
        PsiFile psiFile = (PsiFile)fileElement.getPsi();
        PsiFile originalPsiFile = psiFile.getOriginalFile();
        TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)originalPsiFile.getViewProvider();
        Language templateLanguage = this.getTemplateFileLanguage(viewProvider);
        CharSequence sourceCode = chameleon.getChars();
        RangeCollector collector = new RangeCollector();
        PsiFile templatePsiFile = this.createTemplateFile(psiFile, templateLanguage, sourceCode, viewProvider, collector);
        FileElement templateFileElement = ((PsiFileImpl)templatePsiFile).calcTreeElement();
        return (ASTNode)DebugUtil.performPsiModification("template language parsing", () -> {
            this.prepareParsedTemplateFile(templateFileElement);
            this.insertOuterElementsAndRemoveRanges(templateFileElement, sourceCode, collector, charTable);
            TreeElement childNode = templateFileElement.getFirstChildNode();
            DebugUtil.checkTreeStructure(templateFileElement);
            DebugUtil.checkTreeStructure(chameleon);
            if (fileElement != chameleon) {
                DebugUtil.checkTreeStructure((ASTNode)psiFile.getNode());
                DebugUtil.checkTreeStructure((ASTNode)originalPsiFile.getNode());
            }
            return childNode;
        });
    }

    protected void prepareParsedTemplateFile(@NotNull FileElement root) {
    }

    protected Language getTemplateFileLanguage(TemplateLanguageFileViewProvider viewProvider) {
        return viewProvider.getTemplateDataLanguage();
    }

    protected PsiFile createTemplateFile(PsiFile psiFile, Language templateLanguage, CharSequence sourceCode, TemplateLanguageFileViewProvider viewProvider, @NotNull RangeCollector rangeCollector) {
        CharSequence templateSourceCode = this.createTemplateText(sourceCode, this.createBaseLexer(viewProvider), rangeCollector);
        return this.createPsiFileFromSource(templateLanguage, templateSourceCode, psiFile.getManager());
    }

    protected CharSequence createTemplateText(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer, @NotNull RangeCollector rangeCollector) {
        StringBuilder result2 = new StringBuilder(sourceCode.length());
        baseLexer.start(sourceCode);
        TextRange currentRange = TextRange.EMPTY_RANGE;
        while (baseLexer.getTokenType() != null) {
            TextRange newRange = TextRange.create((int)baseLexer.getTokenStart(), (int)baseLexer.getTokenEnd());
            assert (currentRange.getEndOffset() == newRange.getStartOffset()) : "Inconsistent tokens stream from " + baseLexer + ": " + TemplateDataElementType.getRangeDump(currentRange, sourceCode) + " followed by " + TemplateDataElementType.getRangeDump(newRange, sourceCode);
            currentRange = newRange;
            if (baseLexer.getTokenType() == this.myTemplateElementType) {
                this.appendCurrentTemplateToken(result2, sourceCode, baseLexer, rangeCollector);
            } else {
                rangeCollector.addOuterRange(currentRange);
            }
            baseLexer.advance();
        }
        return result2;
    }

    @NotNull
    private static String getRangeDump(@NotNull TextRange range2, @NotNull CharSequence sequence) {
        return "'" + StringUtil.escapeLineBreak((String)range2.subSequence(sequence).toString()) + "' " + range2;
    }

    protected void appendCurrentTemplateToken(@NotNull StringBuilder result2, @NotNull CharSequence buf, @NotNull Lexer lexer, @NotNull RangeCollector collector) {
        result2.append(buf, lexer.getTokenStart(), lexer.getTokenEnd());
    }

    private void insertOuterElementsAndRemoveRanges(@NotNull TreeElement templateFileElement, @NotNull CharSequence sourceCode, @NotNull RangeCollector rangeCollector, @NotNull CharTable charTable) {
        TreePatcher templateTreePatcher = (TreePatcher)TREE_PATCHER.forLanguage(templateFileElement.getPsi().getLanguage());
        LeafElement currentLeaf = TreeUtil.findFirstLeaf(templateFileElement);
        int currentLeafOffset = 0;
        for (TextRange rangeToProcess : rangeCollector.myOuterAndRemoveRanges) {
            int rangeStartOffset = rangeToProcess.getStartOffset();
            while (currentLeaf != null && currentLeafOffset < rangeStartOffset && !TemplateDataElementType.shouldRemoveRangeInsideLeaf(currentLeaf, currentLeafOffset, rangeToProcess)) {
                if ((currentLeafOffset += currentLeaf.getTextLength()) > rangeStartOffset) {
                    int splitOffset = currentLeaf.getTextLength() - (currentLeafOffset - rangeStartOffset);
                    currentLeaf = templateTreePatcher.split(currentLeaf, splitOffset, charTable);
                    currentLeafOffset = rangeStartOffset;
                }
                currentLeaf = TreeUtil.nextLeaf(currentLeaf);
            }
            if (rangeToProcess instanceof RangeToRemove) {
                assert (currentLeaf != null);
                currentLeaf = TemplateDataElementType.removeElementsForRange(currentLeaf, currentLeafOffset, rangeToProcess, templateTreePatcher, charTable);
                continue;
            }
            if (currentLeaf == null) {
                this.insertLastOuterElementForRange((CompositeElement)templateFileElement, rangeToProcess, sourceCode, rangeCollector, charTable);
                continue;
            }
            currentLeaf = this.insertOuterElementFromRange(currentLeaf, rangeToProcess, sourceCode, templateTreePatcher, charTable);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String after = templateFileElement.getText();
            assert (after.contentEquals(sourceCode)) : "Text presentation for the new tree must be the same: \nbefore: " + sourceCode + "\nafter: " + after;
        }
    }

    private static boolean shouldRemoveRangeInsideLeaf(LeafElement currentLeaf, int currentLeafOffset, TextRange rangeToProcess) {
        return rangeToProcess instanceof RangeToRemove && currentLeafOffset + currentLeaf.getTextLength() > rangeToProcess.getEndOffset();
    }

    private void insertLastOuterElementForRange(@NotNull CompositeElement templateFileElement, @NotNull TextRange outerElementRange, @NotNull CharSequence sourceCode, @NotNull RangeCollector collector, @NotNull CharTable charTable) {
        assert (TemplateDataElementType.isLastRange(collector.myOuterAndRemoveRanges, outerElementRange)) : "This should only happen for the last inserted range. Got " + RangeCollector.access$000(collector).lastIndexOf(outerElementRange) + " of " + (RangeCollector.access$000(collector).size() - 1);
        templateFileElement.rawAddChildren(this.createOuterLanguageElement(charTable.intern(outerElementRange.subSequence(sourceCode)), this.myOuterElementType));
    }

    @NotNull
    private LeafElement insertOuterElementFromRange(@NotNull LeafElement currentLeaf, @NotNull TextRange outerElementRange, @NotNull CharSequence sourceCode, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        OuterLanguageElementImpl newLeaf = this.createOuterLanguageElement(charTable.intern(outerElementRange.subSequence(sourceCode)), this.myOuterElementType);
        CompositeElement parent = currentLeaf.getTreeParent();
        templateTreePatcher.insert(parent, currentLeaf, newLeaf);
        return newLeaf;
    }

    @Nullable
    private static LeafElement removeElementsForRange(@NotNull LeafElement startLeaf, int startLeafOffset, @NotNull TextRange rangeToRemove, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        LeafElement nextLeaf = startLeaf;
        int nextLeafStartOffset = startLeafOffset;
        ArrayList leavesToRemove = ContainerUtil.newArrayList();
        while (nextLeaf != null && rangeToRemove.containsRange(nextLeafStartOffset, nextLeafStartOffset + nextLeaf.getTextLength())) {
            leavesToRemove.add(nextLeaf);
            nextLeafStartOffset += nextLeaf.getTextLength();
            nextLeaf = TreeUtil.nextLeaf(nextLeaf);
        }
        nextLeaf = TemplateDataElementType.splitOrRemoveRangeInsideLeafIfOverlap(nextLeaf, nextLeafStartOffset, rangeToRemove, templateTreePatcher, charTable);
        for (TreeElement element : leavesToRemove) {
            element.rawRemove();
        }
        return nextLeaf;
    }

    @Nullable
    private static LeafElement splitOrRemoveRangeInsideLeafIfOverlap(@Nullable LeafElement nextLeaf, int nextLeafStartOffset, @NotNull TextRange rangeToRemove, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        if (nextLeaf == null) {
            return null;
        }
        if (nextLeafStartOffset >= rangeToRemove.getEndOffset()) {
            return nextLeaf;
        }
        if (rangeToRemove.getStartOffset() > nextLeafStartOffset) {
            return templateTreePatcher.removeRange(nextLeaf, rangeToRemove.shiftLeft(nextLeafStartOffset), charTable);
        }
        int offsetToSplit = rangeToRemove.getEndOffset() - nextLeafStartOffset;
        return TemplateDataElementType.removeLeftPartOfLeaf(nextLeaf, offsetToSplit, templateTreePatcher, charTable);
    }

    @NotNull
    private static LeafElement removeLeftPartOfLeaf(@NotNull LeafElement nextLeaf, int offsetToSplit, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        LeafElement lLeaf = templateTreePatcher.split(nextLeaf, offsetToSplit, charTable);
        LeafElement rLeaf = TreeUtil.nextLeaf(lLeaf);
        assert (rLeaf != null);
        lLeaf.rawRemove();
        return rLeaf;
    }

    private static boolean isLastRange(@NotNull List<TextRange> outerElementsRanges, @NotNull TextRange outerElementRange) {
        return outerElementsRanges.get(outerElementsRanges.size() - 1) == outerElementRange;
    }

    protected OuterLanguageElementImpl createOuterLanguageElement(@NotNull CharSequence internedTokenText, @NotNull IElementType outerElementType) {
        return new OuterLanguageElementImpl(outerElementType, internedTokenText);
    }

    protected PsiFile createPsiFileFromSource(final Language language, CharSequence sourceCode, PsiManager manager) {
        LightVirtualFile virtualFile = new LightVirtualFile("foo", (FileType)this.createTemplateFakeFileType(language), sourceCode, LocalTimeCounter.currentTime());
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(manager, (VirtualFile)virtualFile, false){

            @Override
            @NotNull
            public Language getBaseLanguage() {
                return language;
            }
        };
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)virtualFile);
        return viewProvider.getPsi(language);
    }

    private static final class RangeToRemove
    extends TextRange {
        private RangeToRemove(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }
    }

    protected static class RangeCollector {
        private final List<TextRange> myOuterAndRemoveRanges = new ArrayList<TextRange>();

        protected RangeCollector() {
        }

        public void addOuterRange(@NotNull TextRange newRange) {
            int lastItemIndex;
            TextRange lastRange;
            if (newRange.isEmpty()) {
                return;
            }
            this.assertRangeOrder(newRange);
            if (!this.myOuterAndRemoveRanges.isEmpty() && (lastRange = this.myOuterAndRemoveRanges.get(lastItemIndex = this.myOuterAndRemoveRanges.size() - 1)).getEndOffset() == newRange.getStartOffset() && !(lastRange instanceof RangeToRemove)) {
                this.myOuterAndRemoveRanges.set(lastItemIndex, TextRange.create((int)lastRange.getStartOffset(), (int)newRange.getEndOffset()));
                return;
            }
            this.myOuterAndRemoveRanges.add(newRange);
        }

        public void addRangeToRemove(@NotNull TextRange rangeToRemove) {
            if (rangeToRemove.isEmpty()) {
                return;
            }
            this.assertRangeOrder(rangeToRemove);
            this.myOuterAndRemoveRanges.add(new RangeToRemove(rangeToRemove.getStartOffset(), rangeToRemove.getEndOffset()));
        }

        private void assertRangeOrder(@NotNull TextRange newRange) {
            TextRange range2 = (TextRange)ContainerUtil.getLastItem(this.myOuterAndRemoveRanges);
            assert (range2 == null || newRange.getStartOffset() >= range2.getStartOffset());
        }
    }

    protected static class TemplateFileType
    extends LanguageFileType {
        private final Language myLanguage;

        protected TemplateFileType(Language language) {
            super(language);
            this.myLanguage = language;
        }

        @NotNull
        public String getDefaultExtension() {
            return "";
        }

        @NotNull
        @NonNls
        public String getDescription() {
            return "fake for language" + this.myLanguage.getID();
        }

        @Nullable
        public Icon getIcon() {
            return null;
        }

        @NotNull
        @NonNls
        public String getName() {
            return this.myLanguage.getID();
        }
    }
}

