/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TreePatcher {
    public void insert(@NotNull CompositeElement var1, @Nullable TreeElement var2, @NotNull OuterLanguageElement var3);

    @NotNull
    default public LeafElement split(@NotNull LeafElement leaf, int offset, @NotNull CharTable table) {
        CharSequence chars = leaf.getChars();
        LeafElement leftPart = ASTFactory.leaf(leaf.getElementType(), table.intern(chars, 0, offset));
        LeafElement rightPart = ASTFactory.leaf(leaf.getElementType(), table.intern(chars, offset, chars.length()));
        leaf.rawInsertAfterMe(leftPart);
        leftPart.rawInsertAfterMe(rightPart);
        leaf.rawRemove();
        return leftPart;
    }

    @NotNull
    default public LeafElement removeRange(@NotNull LeafElement leaf, @NotNull TextRange rangeToRemove, @NotNull CharTable table) {
        CharSequence chars = leaf.getChars();
        String res2 = rangeToRemove.replace(chars.toString(), "");
        LeafElement newLeaf = ASTFactory.leaf(leaf.getElementType(), table.intern((CharSequence)res2));
        leaf.rawInsertBeforeMe(newLeaf);
        leaf.rawRemove();
        return newLeaf;
    }
}

