/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class OpenedInEditorWeigher
extends ProximityWeigher {
    private static final NotNullLazyKey<VirtualFile[], ProximityLocation> OPENED_EDITORS = NotNullLazyKey.create((String)"openedEditors", location -> FileEditorManager.getInstance((Project)location.getProject()).getOpenFiles());

    @Override
    public Comparable weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        if (location.getProject() == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return Boolean.valueOf(false);
        }
        VirtualFile virtualFile = psiFile.getOriginalFile().getVirtualFile();
        return Boolean.valueOf(virtualFile != null && ArrayUtil.find((Object[])((Object[])OPENED_EDITORS.getValue((UserDataHolder)location)), (Object)virtualFile) != -1);
    }
}

