/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;

public class SameDirectoryWeigher
extends ProximityWeigher {
    private static final NullableLazyKey<PsiDirectory, ProximityLocation> PLACE_DIRECTORY = NullableLazyKey.create((String)"placeDirectory", location -> SameDirectoryWeigher.getParentDirectory(location.getPosition()));

    private static PsiDirectory getParentDirectory(PsiElement element) {
        PsiFile file2 = InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element);
        if (file2 != null) {
            element = file2.getOriginalFile();
        }
        while (element != null && !(element instanceof PsiDirectory)) {
            element = element.getParent();
        }
        return (PsiDirectory)element;
    }

    @Override
    public Boolean weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        if (location.getPosition() == null) {
            return Boolean.TRUE;
        }
        PsiDirectory placeDirectory = (PsiDirectory)PLACE_DIRECTORY.getValue((UserDataHolder)location);
        return placeDirectory != null && placeDirectory.equals(SameDirectoryWeigher.getParentDirectory(element));
    }
}

