/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.html.HTMLParser;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.parsing.xml.DtdParsing;
import com.intellij.psi.tree.CustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILightLazyParseableElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.tree.xml.IXmlElementType;
import com.intellij.psi.xml.XmlTextElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.annotations.NotNull;

public interface XmlElementType
extends XmlTokenType {
    public static final IElementType XML_DOCUMENT = new IXmlElementType("XML_DOCUMENT");
    public static final IElementType XML_PROLOG = new IXmlElementType("XML_PROLOG");
    public static final IElementType XML_DECL = new IXmlElementType("XML_DECL");
    public static final IElementType XML_DOCTYPE = new IXmlElementType("XML_DOCTYPE");
    public static final IElementType XML_ATTRIBUTE = new IXmlElementType("XML_ATTRIBUTE");
    public static final IElementType XML_COMMENT = new IXmlElementType("XML_COMMENT");
    public static final IElementType XML_TAG = new IXmlElementType("XML_TAG");
    public static final IElementType XML_ELEMENT_DECL = new IXmlElementType("XML_ELEMENT_DECL");
    public static final IElementType XML_CONDITIONAL_SECTION = new IXmlElementType("XML_CONDITIONAL_SECTION");
    public static final IElementType XML_ATTLIST_DECL = new IXmlElementType("XML_ATTLIST_DECL");
    public static final IElementType XML_NOTATION_DECL = new IXmlElementType("XML_NOTATION_DECL");
    public static final IElementType XML_ENTITY_DECL = new IXmlElementType("XML_ENTITY_DECL");
    public static final IElementType XML_ELEMENT_CONTENT_SPEC = new IXmlElementType("XML_ELEMENT_CONTENT_SPEC");
    public static final IElementType XML_ELEMENT_CONTENT_GROUP = new IXmlElementType("XML_ELEMENT_CONTENT_GROUP");
    public static final IElementType XML_ATTRIBUTE_DECL = new IXmlElementType("XML_ATTRIBUTE_DECL");
    public static final IElementType XML_ATTRIBUTE_VALUE = new IXmlElementType("XML_ATTRIBUTE_VALUE");
    public static final IElementType XML_ENTITY_REF = new IXmlElementType("XML_ENTITY_REF");
    public static final IElementType XML_ENUMERATED_TYPE = new IXmlElementType("XML_ENUMERATED_TYPE");
    public static final IElementType XML_PROCESSING_INSTRUCTION = new IXmlElementType("XML_PROCESSING_INSTRUCTION");
    public static final IElementType XML_CDATA = new IXmlElementType("XML_CDATA");
    public static final IElementType HTML_DOCUMENT = new IXmlElementType("HTML_DOCUMENT");
    public static final IElementType HTML_TAG = new IXmlElementType("HTML_TAG");
    public static final IFileElementType HTML_FILE = new IStubFileElementType((Language)HTMLLanguage.INSTANCE){

        @Override
        public int getStubVersion() {
            return super.getStubVersion() + 1;
        }
    };
    public static final IElementType HTML_EMBEDDED_CONTENT = new EmbeddedHtmlContentElementType();
    public static final IElementType XML_TEXT = new XmlTextElementType();
    public static final IFileElementType XML_FILE = new IFileElementType((Language)XMLLanguage.INSTANCE);
    public static final IElementType XHTML_FILE = new IFileElementType((Language)XHTMLLanguage.INSTANCE);
    public static final IFileElementType DTD_FILE = new IFileElementType("DTD_FILE", (Language)DTDLanguage.INSTANCE);
    public static final IElementType XML_MARKUP_DECL = new CustomParsingType("XML_MARKUP_DECL", (Language)XMLLanguage.INSTANCE){

        @NotNull
        public ASTNode parse(@NotNull CharSequence text, @NotNull CharTable table) {
            return new DtdParsing(text, XML_MARKUP_DECL, DtdParsing.TYPE_FOR_MARKUP_DECL, null).parse();
        }
    };

    public static class EmbeddedHtmlContentElementType
    extends ILazyParseableElementType
    implements ILightLazyParseableElementType {
        public EmbeddedHtmlContentElementType() {
            super("HTML_EMBEDDED_CONTENT", (Language)HTMLLanguage.INSTANCE);
        }

        public FlyweightCapableTreeStructure<LighterASTNode> parseContents(LighterLazyParseableNode chameleon) {
            PsiFile file2 = chameleon.getContainingFile();
            assert (file2 != null) : chameleon;
            PsiBuilder builder2 = PsiBuilderFactory.getInstance().createBuilder(file2.getProject(), chameleon);
            HTMLParser.parseWithoutBuildingTree((IElementType)HTML_FILE, builder2);
            return builder2.getLightTree();
        }
    }
}

