/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.ide.actions.CopyElementAction;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringQuickListPopupAction
extends QuickSwitchSchemeAction {
    public RefactoringQuickListPopupAction() {
        this.setInjectedContext(true);
    }

    protected void fillActions(@Nullable Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (project == null) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction("RefactoringMenu");
        RefactoringQuickListPopupAction.collectEnabledChildren(action, group, dataContext, actionManager, false);
    }

    private static void collectEnabledChildren(AnAction action, @NotNull DefaultActionGroup destinationGroup, @NotNull DataContext dataContext, @NotNull ActionManager actionManager, boolean popup2) {
        if (action instanceof DefaultActionGroup) {
            AnAction[] children2;
            for (AnAction child2 : children2 = ((DefaultActionGroup)action).getChildren(null)) {
                if (child2 instanceof DefaultActionGroup) {
                    boolean isPopup = ((DefaultActionGroup)child2).isPopup();
                    if (isPopup) {
                        destinationGroup.add((AnAction)new Separator(child2.getTemplatePresentation().getText()));
                    }
                    RefactoringQuickListPopupAction.collectEnabledChildren(child2, destinationGroup, dataContext, actionManager, isPopup || popup2);
                    if (!isPopup) continue;
                    destinationGroup.add((AnAction)Separator.getInstance());
                    continue;
                }
                if (child2 instanceof Separator && !popup2) {
                    destinationGroup.add(child2);
                    continue;
                }
                if ((!(child2 instanceof BaseRefactoringAction) || !((BaseRefactoringAction)child2).hasAvailableHandler(dataContext)) && !(child2 instanceof CopyElementAction)) continue;
                Presentation presentation = new Presentation();
                AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", presentation, actionManager, 0);
                event.setInjectedContext(child2.isInInjectedContext());
                child2.update(event);
                if (!presentation.isEnabled() || !presentation.isVisible()) continue;
                destinationGroup.add(child2);
            }
        }
    }

    protected void showPopup(AnActionEvent e, ListPopup popup2) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            popup2.showInBestPositionFor(editor);
        } else {
            super.showPopup(e, popup2);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setVisible(ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "ActionPlace.QuickListPopupAction".equals(e.getPlace()) || "TouchBarGeneral".equals(e.getPlace()));
    }

    protected String getPopupTitle(@NotNull AnActionEvent e) {
        return "Refactor This";
    }
}

