/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetectors;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.PositionTracker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InplaceChangeSignature
implements DocumentListener {
    public static final Key<InplaceChangeSignature> INPLACE_CHANGE_SIGNATURE = Key.create((String)"EditorInplaceChangeSignature");
    private ChangeInfo myCurrentInfo;
    private ChangeInfo myStableChange;
    private String myInitialSignature;
    private String myInitialName;
    private Editor myEditor;
    private LanguageChangeSignatureDetector<ChangeInfo> myDetector;
    private final Project myProject;
    private final PsiDocumentManager myDocumentManager;
    private final ArrayList<RangeHighlighter> myHighlighters = new ArrayList();
    private StartMarkAction myMarkAction;
    private Balloon myBalloon;
    private boolean myDelegate;
    private EditorEx myPreview;

    public InplaceChangeSignature(Project project, Editor editor, @NotNull PsiElement element) {
        this.myDocumentManager = PsiDocumentManager.getInstance((Project)project);
        this.myProject = project;
        try {
            this.myMarkAction = StartMarkAction.start(editor, project, ChangeSignatureHandler.REFACTORING_NAME);
        }
        catch (StartMarkAction.AlreadyStartedException e) {
            int exitCode = Messages.showYesNoDialog((Project)this.myProject, (String)e.getMessage(), (String)ChangeSignatureHandler.REFACTORING_NAME, (String)"Navigate to Started", (String)"Cancel", (Icon)Messages.getErrorIcon());
            if (exitCode == 2) {
                return;
            }
            PsiElement method = this.myStableChange.getMethod();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)method);
            PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, method.getTextOffset()).navigate(true);
            return;
        }
        this.myEditor = editor;
        this.myDetector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(element.getLanguage());
        this.myStableChange = this.myDetector.createInitialChangeInfo(element);
        this.myInitialSignature = this.myDetector.extractSignature(this.myStableChange);
        this.myInitialName = DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myStableChange.getMethod());
        TextRange highlightingRange = this.myDetector.getHighlightingRange(this.myStableChange);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.LIVE_TEMPLATE_ATTRIBUTES);
        highlightManager.addRangeHighlight(editor, highlightingRange.getStartOffset(), highlightingRange.getEndOffset(), attributes, false, this.myHighlighters);
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.setGreedyToRight(true);
            highlighter.setGreedyToLeft(true);
        }
        this.myEditor.getDocument().addDocumentListener((DocumentListener)this);
        this.myEditor.putUserData(INPLACE_CHANGE_SIGNATURE, (Object)this);
        this.myPreview = InplaceRefactoring.createPreviewComponent(project, this.myDetector.getFileType());
        this.showBalloon();
    }

    @Nullable
    public static InplaceChangeSignature getCurrentRefactoring(@NotNull Editor editor) {
        return (InplaceChangeSignature)editor.getUserData(INPLACE_CHANGE_SIGNATURE);
    }

    public ChangeInfo getCurrentInfo() {
        return this.myCurrentInfo;
    }

    public String getInitialName() {
        return this.myInitialName;
    }

    public String getInitialSignature() {
        return this.myInitialSignature;
    }

    @NotNull
    public ChangeInfo getStableChange() {
        return this.myStableChange;
    }

    public void cancel() {
        TextRange highlightingRange = this.myDetector.getHighlightingRange(this.getStableChange());
        Document document = this.myEditor.getDocument();
        String initialSignature = this.myInitialSignature;
        this.detach();
        InplaceChangeSignature.temporallyRevertChanges(highlightingRange, document, initialSignature, this.myProject);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        RangeMarker marker = event.getDocument().createRangeMarker(event.getOffset(), event.getOffset());
        this.myDocumentManager.performWhenAllCommitted(() -> {
            if (this.myDetector == null) {
                return;
            }
            PsiFile file2 = this.myDocumentManager.getPsiFile(event.getDocument());
            if (file2 == null) {
                return;
            }
            PsiElement element = file2.findElementAt(marker.getStartOffset());
            marker.dispose();
            if (element == null || this.myDetector.ignoreChanges(element)) {
                return;
            }
            if (element instanceof PsiWhiteSpace) {
                PsiElement method = this.myStableChange.getMethod();
                if (PsiTreeUtil.skipWhitespacesForward((PsiElement)element) == method) {
                    return;
                }
            }
            if (!this.myDetector.isChangeSignatureAvailableOnElement(element, this.myStableChange)) {
                this.detach();
                return;
            }
            this.updateCurrentInfo();
        });
    }

    private void updateCurrentInfo() {
        String signature;
        ChangeInfo changeInfo;
        if (this.myCurrentInfo == null) {
            this.myCurrentInfo = this.myStableChange;
        }
        if ((changeInfo = this.myDetector.createNextChangeInfo(signature = this.myDetector.extractSignature(this.myCurrentInfo), this.myCurrentInfo, this.myDelegate)) == null && this.myCurrentInfo != null) {
            this.myStableChange = this.myCurrentInfo;
        }
        if (changeInfo != null) {
            this.updateMethodSignature(changeInfo);
        }
        this.myCurrentInfo = changeInfo;
    }

    private void updateMethodSignature(ChangeInfo changeInfo) {
        ArrayList deleteRanges = new ArrayList();
        ArrayList newRanges = new ArrayList();
        String methodSignature = this.myDetector.getMethodSignaturePreview(changeInfo, deleteRanges, newRanges);
        this.myPreview.getMarkupModel().removeAllHighlighters();
        WriteCommandAction.writeCommandAction(null).run(() -> this.myPreview.getDocument().replaceString(0, this.myPreview.getDocument().getTextLength(), methodSignature));
        TextAttributes deprecatedAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.DEPRECATED_ATTRIBUTES);
        for (TextRange range2 : deleteRanges) {
            this.myPreview.getMarkupModel().addRangeHighlighter(range2.getStartOffset(), range2.getEndOffset(), 3000, deprecatedAttributes, HighlighterTargetArea.EXACT_RANGE);
        }
        TextAttributes todoAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.TODO_DEFAULT_ATTRIBUTES);
        for (TextRange range3 : newRanges) {
            this.myPreview.getMarkupModel().addRangeHighlighter(range3.getStartOffset(), range3.getEndOffset(), 3000, todoAttributes, HighlighterTargetArea.EXACT_RANGE);
        }
    }

    protected void showBalloon() {
        NonFocusableCheckBox checkBox2 = new NonFocusableCheckBox(RefactoringBundle.message((String)"delegation.panel.delegate.via.overloading.method"));
        checkBox2.addActionListener(e -> {
            this.myDelegate = checkBox2.isSelected();
            this.updateCurrentInfo();
        });
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)new JBLabel("Performed signature modifications:"), "North");
        content.add((Component)this.myPreview.getComponent(), "Center");
        this.updateMethodSignature(this.myStableChange);
        content.add((Component)checkBox2, "South");
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createDialogBalloonBuilder((JComponent)content, null).setSmallVariant(true);
        this.myBalloon = balloonBuilder.createBalloon();
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.myBalloon.show((PositionTracker)new PositionTracker<Balloon>((Component)this.myEditor.getContentComponent()){

            public RelativePoint recalculateLocation(Balloon object) {
                int offset = InplaceChangeSignature.this.myStableChange.getMethod().getTextOffset();
                VisualPosition visualPosition = InplaceChangeSignature.this.myEditor.offsetToVisualPosition(offset);
                Point point = InplaceChangeSignature.this.myEditor.visualPositionToXY(new VisualPosition(visualPosition.line, visualPosition.column));
                return new RelativePoint((Component)InplaceChangeSignature.this.myEditor.getContentComponent(), point);
            }
        }, Balloon.Position.above);
        Disposer.register((Disposable)this.myBalloon, () -> {
            EditorFactory.getInstance().releaseEditor((Editor)this.myPreview);
            this.myPreview = null;
        });
    }

    public void detach() {
        this.myEditor.getDocument().removeDocumentListener((DocumentListener)this);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlightManager.removeSegmentHighlighter(this.myEditor, highlighter);
        }
        this.myHighlighters.clear();
        this.myBalloon.hide();
        this.myDetector = null;
        FinishMarkAction.finish(this.myProject, this.myEditor, this.myMarkAction);
        this.myEditor.putUserData(INPLACE_CHANGE_SIGNATURE, null);
    }

    public static void temporallyRevertChanges(TextRange signatureRange, Document document, String initialSignature, Project project) {
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            document.replaceString(signatureRange.getStartOffset(), signatureRange.getEndOffset(), (CharSequence)initialSignature);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        });
    }
}

