/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.classMembers;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoTooltipManager;
import org.jetbrains.annotations.NotNull;

public class ANDCombinedMemberInfoModel<T extends PsiElement, M extends MemberInfoBase<T>>
implements MemberInfoModel<T, M> {
    private final MemberInfoModel<T, M> myModel1;
    private final MemberInfoModel<T, M> myModel2;
    private final MemberInfoTooltipManager<T, M> myTooltipManager = new MemberInfoTooltipManager(new MemberInfoTooltipManager.TooltipProvider<T, M>(){

        @Override
        public String getTooltip(M memberInfo) {
            String tooltipText1 = ANDCombinedMemberInfoModel.this.myModel1.getTooltipText(memberInfo);
            if (tooltipText1 != null) {
                return tooltipText1;
            }
            return ANDCombinedMemberInfoModel.this.myModel2.getTooltipText(memberInfo);
        }
    });

    public ANDCombinedMemberInfoModel(MemberInfoModel<T, M> model1, MemberInfoModel<T, M> model2) {
        this.myModel1 = model1;
        this.myModel2 = model2;
    }

    public boolean isMemberEnabled(M member) {
        return this.myModel1.isMemberEnabled(member) && this.myModel2.isMemberEnabled(member);
    }

    public boolean isCheckedWhenDisabled(M member) {
        return this.myModel1.isCheckedWhenDisabled(member) && this.myModel2.isCheckedWhenDisabled(member);
    }

    public boolean isAbstractEnabled(M member) {
        return this.myModel1.isAbstractEnabled(member) && this.myModel2.isAbstractEnabled(member);
    }

    public boolean isAbstractWhenDisabled(M member) {
        return this.myModel1.isAbstractWhenDisabled(member) && this.myModel2.isAbstractWhenDisabled(member);
    }

    public int checkForProblems(@NotNull M member) {
        return Math.max(this.myModel1.checkForProblems(member), this.myModel2.checkForProblems(member));
    }

    public void memberInfoChanged(@NotNull MemberInfoChange<T, M> event) {
        this.myTooltipManager.invalidate();
        this.myModel1.memberInfoChanged(event);
        this.myModel2.memberInfoChanged(event);
    }

    public Boolean isFixedAbstract(M member) {
        Boolean fixedAbstract1 = this.myModel1.isFixedAbstract(member);
        if (fixedAbstract1 == null) {
            return null;
        }
        if (fixedAbstract1.equals(this.myModel2.isFixedAbstract(member))) {
            return fixedAbstract1;
        }
        return null;
    }

    public MemberInfoModel<T, M> getModel1() {
        return this.myModel1;
    }

    public MemberInfoModel<T, M> getModel2() {
        return this.myModel2;
    }

    public String getTooltipText(M member) {
        return this.myTooltipManager.getTooltip(member);
    }
}

