/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyFilesOrDirectoriesDialog
extends DialogWrapper {
    public static final int MAX_PATH_LENGTH = 70;
    private static final String COPY_OPEN_IN_EDITOR = "Copy.OpenInEditor";
    private static final String RECENT_KEYS = "CopyFile.RECENT_KEYS";
    private JLabel myInformationLabel;
    private TextFieldWithHistoryWithBrowseButton myTargetDirectoryField;
    private final JCheckBox myOpenFilesInEditor = CopyFilesOrDirectoriesDialog.createOpenInEditorCB();
    private boolean myUnknownFileType = false;
    private EditorTextField myNewNameField;
    private final PsiElement[] myElements;
    private final Project myProject;
    private final boolean myShowDirectoryField;
    private final boolean myShowNewNameField;
    private PsiDirectory myTargetDirectory;
    private boolean myFileCopy = false;

    public static String shortenPath(@NotNull VirtualFile file2) {
        return StringUtil.shortenPathWithEllipsis((String)file2.getPresentableUrl(), (int)70);
    }

    public static JCheckBox createOpenInEditorCB() {
        JCheckBox checkBox2 = new JCheckBox("Open copy in editor", PropertiesComponent.getInstance().getBoolean(COPY_OPEN_IN_EDITOR, true));
        checkBox2.setMnemonic('o');
        return checkBox2;
    }

    public static void saveOpenInEditorState(boolean selected) {
        PropertiesComponent.getInstance().setValue(COPY_OPEN_IN_EDITOR, String.valueOf(selected));
    }

    public CopyFilesOrDirectoriesDialog(PsiElement[] elements, @Nullable PsiDirectory defaultTargetDirectory, Project project, boolean doClone) {
        super(project, true);
        this.myElements = elements;
        this.myProject = project;
        this.myShowDirectoryField = !doClone;
        boolean bl = this.myShowNewNameField = ((PsiElement[])elements).length == 1;
        if (doClone && ((PsiElement[])elements).length != 1) {
            throw new IllegalArgumentException("wrong number of elements to clone: " + ((PsiElement[])elements).length);
        }
        this.setTitle(RefactoringBundle.message((String)(doClone ? "copy.files.clone.title" : "copy.files.copy.title")));
        this.init();
        for (int i = 0; i < ((PsiElement[])elements).length; ++i) {
            if (!(elements[i] instanceof PsiFile)) continue;
            elements[i] = ((PsiFile)elements[i]).getOriginalFile();
        }
        if (((PsiElement[])elements).length == 1) {
            String text;
            if (elements[0] instanceof PsiFile) {
                String fileName2;
                PsiFile file2 = (PsiFile)elements[0];
                VirtualFile vFile = file2.getVirtualFile();
                text = RefactoringBundle.message((String)(doClone ? "copy.files.clone.file.0" : "copy.files.copy.file.0"), (Object[])new Object[]{CopyFilesOrDirectoriesDialog.shortenPath(vFile)});
                String string = fileName2 = vFile.isInLocalFileSystem() ? vFile.getName() : PathUtil.suggestFileName((String)file2.getName(), (boolean)true, (boolean)true);
                if (StringUtil.isEmpty((String)vFile.getExtension()) && ScratchUtil.isScratch(vFile)) {
                    FileType type = (FileType)ObjectUtils.notNull((Object)file2.getLanguage().getAssociatedFileType(), (Object)file2.getFileType());
                    fileName2 = PathUtil.makeFileName((String)fileName2, (String)type.getDefaultExtension());
                }
                this.myNewNameField.setText(fileName2);
                int dotIdx = fileName2.lastIndexOf(46);
                if (dotIdx > 0) {
                    this.selectNameWithoutExtension(dotIdx);
                }
                this.myTargetDirectory = file2.getContainingDirectory();
                this.myFileCopy = true;
            } else {
                VirtualFile vFile = ((PsiDirectory)elements[0]).getVirtualFile();
                text = RefactoringBundle.message((String)(doClone ? "copy.files.clone.directory.0" : "copy.files.copy.directory.0"), (Object[])new Object[]{CopyFilesOrDirectoriesDialog.shortenPath(vFile)});
                this.myNewNameField.setText(vFile.getName());
            }
            this.myInformationLabel.setText(text);
        } else {
            this.setMultipleElementCopyLabel((PsiElement[])elements);
        }
        boolean allBinary = true;
        for (VirtualFile element : elements) {
            if (element.getContainingFile() instanceof PsiBinaryFile) continue;
            allBinary = false;
            break;
        }
        if (allBinary) {
            this.myOpenFilesInEditor.setVisible(false);
        }
        if (this.myShowDirectoryField) {
            String targetPath = defaultTargetDirectory == null ? "" : defaultTargetDirectory.getVirtualFile().getPresentableUrl();
            this.getTargetDirectoryComponent().setText(targetPath);
        }
        this.validateOKButton();
    }

    private void selectNameWithoutExtension(int dotIdx) {
        Runnable selectRunnable = () -> {
            Editor editor = this.myNewNameField.getEditor();
            if (editor != null) {
                editor.getSelectionModel().setSelection(0, dotIdx);
                editor.getCaretModel().moveToOffset(dotIdx);
            } else {
                this.myNewNameField.selectAll();
            }
        };
        SwingUtilities.invokeLater(selectRunnable);
    }

    private void setMultipleElementCopyLabel(PsiElement[] elements) {
        boolean allFiles = true;
        boolean allDirectories = true;
        for (PsiElement element : elements) {
            if (element instanceof PsiDirectory) {
                allFiles = false;
                continue;
            }
            allDirectories = false;
        }
        if (allFiles) {
            this.myInformationLabel.setText(RefactoringBundle.message((String)"copy.files.copy.specified.files.label"));
        } else if (allDirectories) {
            this.myInformationLabel.setText(RefactoringBundle.message((String)"copy.files.copy.specified.directories.label"));
        } else {
            this.myInformationLabel.setText(RefactoringBundle.message((String)"copy.files.copy.specified.mixed.label"));
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myShowNewNameField ? this.myNewNameField : this.getTargetDirectoryComponent();
    }

    protected TextFieldWithHistory getTargetDirectoryComponent() {
        return (TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent();
    }

    protected JComponent createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    protected JComponent createNorthPanel() {
        this.myInformationLabel = JBLabelDecorator.createJBLabelDecorator().setBold(true);
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent((JComponent)this.myInformationLabel).addVerticalGap(8);
        if (this.myShowNewNameField) {
            this.myNewNameField = new EditorTextField();
            this.myNewNameField.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    CopyFilesOrDirectoriesDialog.this.validateOKButton();
                }
            });
            formBuilder.addLabeledComponent(RefactoringBundle.message((String)"copy.files.new.name.label"), (JComponent)((Object)this.myNewNameField));
        }
        if (this.myShowDirectoryField) {
            this.myTargetDirectoryField = new TextFieldWithHistoryWithBrowseButton();
            this.myTargetDirectoryField.setTextFieldPreferredWidth(70);
            List<String> recentEntries = RecentsManager.getInstance(this.myProject).getRecentEntries(RECENT_KEYS);
            if (recentEntries != null) {
                this.getTargetDirectoryComponent().setHistory(recentEntries);
            }
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            this.myTargetDirectoryField.addBrowseFolderListener(RefactoringBundle.message((String)"select.target.directory"), RefactoringBundle.message((String)"the.file.will.be.copied.to.this.directory"), this.myProject, descriptor, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
            this.getTargetDirectoryComponent().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                    CopyFilesOrDirectoriesDialog.this.validateOKButton();
                }
            });
            formBuilder.addLabeledComponent(RefactoringBundle.message((String)"copy.files.to.directory.label"), (JComponent)this.myTargetDirectoryField);
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
            formBuilder.addTooltip(RefactoringBundle.message((String)"path.completion.shortcut", (Object[])new Object[]{shortcutText}));
        }
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)this.myOpenFilesInEditor, "East");
        formBuilder.addComponent((JComponent)wrapper2);
        return formBuilder.getPanel();
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public String getNewName() {
        return this.myNewNameField != null ? this.myNewNameField.getText().trim() : null;
    }

    public boolean openInEditor() {
        return this.myOpenFilesInEditor.isVisible() && this.myOpenFilesInEditor.isSelected() && !this.myUnknownFileType;
    }

    protected void doOKAction() {
        if (this.myShowNewNameField) {
            String newName = this.getNewName();
            if (newName.length() == 0) {
                Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"no.new.name.specified"), (String)RefactoringBundle.message((String)"error.title"));
                return;
            }
            if (this.myFileCopy && !PathUtilRt.isValidFileName((String)newName, (boolean)false)) {
                Messages.showErrorDialog((Component)((Object)this.myNewNameField), (String)"Name is not a valid file name");
                return;
            }
            if (this.myFileCopy && this.myTargetDirectory != null && this.myOpenFilesInEditor.isVisible() && this.myOpenFilesInEditor.isSelected() && FileTypeChooser.getKnownFileTypeOrAssociate(this.myTargetDirectory.getVirtualFile(), newName, this.myProject) == null) {
                this.myUnknownFileType = true;
            }
        }
        if (this.myOpenFilesInEditor.isVisible()) {
            CopyFilesOrDirectoriesDialog.saveOpenInEditorState(this.myOpenFilesInEditor.isSelected());
        }
        if (this.myShowDirectoryField) {
            String targetDirectoryName = this.getTargetDirectoryComponent().getText();
            if (targetDirectoryName.length() == 0) {
                Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"no.target.directory.specified"), (String)RefactoringBundle.message((String)"error.title"));
                return;
            }
            RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENT_KEYS, targetDirectoryName);
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    String path = FileUtil.toSystemIndependentName((String)targetDirectoryName);
                    this.myTargetDirectory = DirectoryUtil.mkdirs(PsiManager.getInstance((Project)this.myProject), path);
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }), RefactoringBundle.message((String)"create.directory"), null);
            if (this.myTargetDirectory == null) {
                Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"cannot.create.directory"), (String)RefactoringBundle.message((String)"error.title"));
                return;
            }
            FileChooserUtil.setLastOpenedFile(this.myProject, this.myTargetDirectory.getVirtualFile());
            try {
                for (PsiElement element : this.myElements) {
                    MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf(element, (PsiElement)this.myTargetDirectory);
                }
            }
            catch (IncorrectOperationException e) {
                Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)RefactoringBundle.message((String)"error.title"));
                return;
            }
        }
        super.doOKAction();
    }

    private void validateOKButton() {
        String newName;
        if (this.myShowDirectoryField && this.getTargetDirectoryComponent().getText().length() == 0) {
            this.setOKActionEnabled(false);
            return;
        }
        if (this.myShowNewNameField && ((newName = this.getNewName()).length() == 0 || this.myFileCopy && !PathUtilRt.isValidFileName((String)newName, (boolean)false))) {
            this.setOKActionEnabled(false);
            return;
        }
        this.setOKActionEnabled(true);
    }

    protected String getHelpId() {
        return "refactoring.copyClass";
    }
}

