/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce.inplace;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageTokenSeparatorGenerators;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.PreferrableNameSuggestionProvider;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.MyLookupExpression;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InplaceVariableIntroducer<E extends PsiElement>
extends InplaceRefactoring {
    protected E myExpr;
    protected RangeMarker myExprMarker;
    protected E[] myOccurrences;
    protected List<RangeMarker> myOccurrenceMarkers;

    public InplaceVariableIntroducer(PsiNamedElement elementToRename, Editor editor, Project project, String title, E[] occurrences, @Nullable E expr) {
        super(editor, elementToRename, project);
        this.myTitle = title;
        this.myOccurrences = occurrences;
        if (expr != null) {
            ASTNode node = expr.getNode();
            if (node != null) {
                Lexer lexer;
                ASTNode astNode;
                ASTNode prev2 = node.getTreePrev();
                ASTNode aSTNode = astNode = prev2 instanceof PsiWhiteSpace ? null : ((TokenSeparatorGenerator)LanguageTokenSeparatorGenerators.INSTANCE.forLanguage(expr.getLanguage())).generateWhitespaceBetweenTokens(prev2, node);
                if (astNode != null && LanguageUtil.canStickTokensTogetherByLexer((ASTNode)prev2, (ASTNode)prev2, (Lexer)(lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(expr.getLanguage())).createLexer(project))) == ParserDefinition.SpaceRequirements.MUST) {
                    PostprocessReformattingAspect.getInstance(project).disablePostprocessFormattingInside(() -> WriteCommandAction.writeCommandAction((Project)project).withName("Normalize declaration").run(() -> node.getTreeParent().addChild(astNode, node)));
                }
            }
            this.myExpr = expr;
        }
        this.myExprMarker = this.myExpr != null && this.myExpr.isPhysical() ? this.createMarker((PsiElement)this.myExpr) : null;
        this.initOccurrencesMarkers();
    }

    @Override
    protected boolean shouldSelectAll() {
        return true;
    }

    @Override
    protected StartMarkAction startRename() throws StartMarkAction.AlreadyStartedException {
        return null;
    }

    public void setOccurrenceMarkers(List<RangeMarker> occurrenceMarkers) {
        this.myOccurrenceMarkers = occurrenceMarkers;
    }

    public void setExprMarker(RangeMarker exprMarker) {
        this.myExprMarker = exprMarker;
    }

    @Nullable
    public E getExpr() {
        return this.myExpr != null && this.myExpr.isValid() && this.myExpr.isPhysical() ? (E)this.myExpr : null;
    }

    public E[] getOccurrences() {
        return this.myOccurrences;
    }

    public List<RangeMarker> getOccurrenceMarkers() {
        if (this.myOccurrenceMarkers == null) {
            this.initOccurrencesMarkers();
        }
        return this.myOccurrenceMarkers;
    }

    protected void initOccurrencesMarkers() {
        if (this.myOccurrenceMarkers != null) {
            return;
        }
        this.myOccurrenceMarkers = new ArrayList<RangeMarker>();
        for (E occurrence : this.myOccurrences) {
            this.myOccurrenceMarkers.add(this.createMarker((PsiElement)occurrence));
        }
    }

    protected RangeMarker createMarker(PsiElement element) {
        return this.myEditor.getDocument().createRangeMarker(element.getTextRange());
    }

    public RangeMarker getExprMarker() {
        return this.myExprMarker;
    }

    @Override
    protected boolean performRefactoring() {
        return false;
    }

    @Override
    protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
    }

    @Override
    protected String getCommandName() {
        return this.myTitle;
    }

    @Override
    protected void moveOffsetAfter(boolean success2) {
        super.moveOffsetAfter(success2);
        if (this.myOccurrenceMarkers != null) {
            for (RangeMarker marker : this.myOccurrenceMarkers) {
                marker.dispose();
            }
        }
        if (this.myExprMarker != null && !this.isRestart()) {
            this.myExprMarker.dispose();
        }
    }

    @Override
    protected MyLookupExpression createLookupExpression(PsiElement selectedElement) {
        return new MyIntroduceLookupExpression(this.getInitialName(), this.myNameSuggestions, this.myElementToRename, this.shouldSelectAll(), this.myAdvertisementText);
    }

    private static class MyIntroduceLookupExpression
    extends MyLookupExpression {
        private final SmartPsiElementPointer<PsiNamedElement> myPointer;

        MyIntroduceLookupExpression(String initialName, LinkedHashSet<String> names, PsiNamedElement elementToRename, boolean shouldSelectAll, String advertisementText) {
            super(initialName, names, elementToRename, (PsiElement)elementToRename, shouldSelectAll, advertisementText);
            this.myPointer = SmartPointerManager.getInstance((Project)elementToRename.getProject()).createSmartPsiElementPointer((PsiElement)elementToRename);
        }

        @Override
        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return this.createLookupItems(this.myName, context.getEditor(), this.getElement());
        }

        @Nullable
        public PsiNamedElement getElement() {
            return (PsiNamedElement)this.myPointer.getElement();
        }

        @Nullable
        private LookupElement[] createLookupItems(String name, Editor editor, PsiNamedElement psiVariable) {
            TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
            if (psiVariable != null) {
                String text;
                TextResult insertedValue;
                TextResult textResult = insertedValue = templateState != null ? templateState.getVariableValue("PrimaryVariable") : null;
                if (insertedValue != null && !(text = insertedValue.getText()).isEmpty() && !Comparing.strEqual((String)text, (String)name)) {
                    NameSuggestionProvider provider;
                    SuggestedNameInfo suggestedNameInfo;
                    LinkedHashSet<String> names = new LinkedHashSet<String>();
                    names.add(text);
                    Iterator iterator = NameSuggestionProvider.EP_NAME.getExtensionList().iterator();
                    while (iterator.hasNext() && ((suggestedNameInfo = (provider = (NameSuggestionProvider)iterator.next()).getSuggestedNames((PsiElement)psiVariable, (PsiElement)psiVariable, names)) == null || !(provider instanceof PreferrableNameSuggestionProvider) || ((PreferrableNameSuggestionProvider)provider).shouldCheckOthers())) {
                    }
                    LookupElement[] items = new LookupElement[names.size()];
                    Iterator iterator2 = names.iterator();
                    for (int i = 0; i < items.length; ++i) {
                        items[i] = LookupElementBuilder.create((String)((String)iterator2.next()));
                    }
                    return items;
                }
            }
            return this.myLookupItems;
        }
    }
}

